/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.item.IUpgradeItem;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.common.util.upgrade.UpgradeCache;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.items.ItemStackHandler;

public class UpgradableItemUtils {
    public static final String NBT_CREATIVE = "CreativeUpgrade";
    public static final String NBT_UPGRADE_TAG = "UpgradeInventory";
    public static final int UPGRADE_INV_SIZE = 9;
    private static final String NBT_UPGRADE_CACHE_TAG = "UpgradeCache";

    public static void addUpgradeInformation(ItemStack iStack, List<Component> textList, TooltipFlag flag) {
        Map<PNCUpgrade, Integer> upgrades = UpgradableItemUtils.getUpgrades(iStack);
        if (upgrades.isEmpty()) {
            if (!ApplicableUpgradesDB.getInstance().getApplicableUpgrades(iStack.m_41720_()).isEmpty()) {
                textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.upgrades.empty", new Object[0]).m_130940_(ChatFormatting.DARK_GREEN));
            }
        } else {
            textList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.upgrades.not_empty", new Object[0]).m_130940_(ChatFormatting.GREEN));
            ArrayList l = new ArrayList();
            upgrades.forEach((upgrade, count) -> l.add(upgrade.getItemStack((int)count)));
            PneumaticCraftUtils.summariseItemStacks(textList, l.toArray(new ItemStack[0]), ChatFormatting.DARK_GREEN + "\u2022 ");
        }
    }

    public static void setUpgrades(ItemStack stack, ItemStackHandler handler) {
        stack.m_41784_().m_128365_(NBT_UPGRADE_TAG, (Tag)handler.serializeNBT());
        UpgradeCache cache = new UpgradeCache(() -> handler);
        Objects.requireNonNull(stack.m_41783_()).m_128365_(NBT_UPGRADE_CACHE_TAG, (Tag)cache.toNBT());
        stack.getCapability(PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY).ifPresent(h -> {
            if (h.getPressure() > h.maxPressure()) {
                int maxAir = (int)((float)h.getVolume() * h.maxPressure());
                h.addAir(maxAir - h.getAir());
            }
        });
    }

    public static Map<PNCUpgrade, Integer> getUpgrades(ItemStack stack) {
        CompoundTag tag = UpgradableItemUtils.getSerializedUpgrades(stack);
        ListTag itemList = tag.m_128437_("Items", 10);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < itemList.size(); ++i) {
            ItemStack upgradeStack = ItemStack.m_41712_((CompoundTag)itemList.m_128728_(i));
            Item item = upgradeStack.m_41720_();
            if (!(item instanceof IUpgradeItem)) continue;
            IUpgradeItem upgradeItem = (IUpgradeItem)item;
            builder.put((Object)upgradeItem.getUpgradeType(), (Object)(upgradeItem.getUpgradeTier() * upgradeStack.m_41613_()));
        }
        return builder.build();
    }

    public static int getUpgradeCount(ItemStack stack, PNCUpgrade upgrade) {
        if (stack.m_41783_() != null) {
            UpgradableItemUtils.validateUpgradeCache(stack);
            CompoundTag subTag = Objects.requireNonNull(stack.m_41783_()).m_128469_(NBT_UPGRADE_CACHE_TAG);
            String key = PneumaticCraftUtils.modDefaultedString(Objects.requireNonNull(upgrade.getRegistryName()));
            return subTag.m_128451_(key);
        }
        return 0;
    }

    public static List<Integer> getUpgradeList(ItemStack stack, PNCUpgrade ... upgradeList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (stack.m_41783_() != null) {
            UpgradableItemUtils.validateUpgradeCache(stack);
            CompoundTag subTag = stack.m_41783_().m_128469_(NBT_UPGRADE_CACHE_TAG);
            for (PNCUpgrade upgrade : upgradeList) {
                String key = PneumaticCraftUtils.modDefaultedString(Objects.requireNonNull(upgrade.getRegistryName()));
                builder.add((Object)subTag.m_128451_(key));
            }
        }
        return builder.build();
    }

    public static boolean hasCreativeUpgrade(ItemStack stack) {
        return stack.m_41783_() != null && stack.m_41783_().m_128471_(NBT_CREATIVE);
    }

    private static void validateUpgradeCache(ItemStack stack) {
        if (Objects.requireNonNull(stack.m_41783_()).m_128441_(NBT_UPGRADE_TAG) && !stack.m_41783_().m_128441_(NBT_UPGRADE_CACHE_TAG)) {
            ItemStackHandler handler = new ItemStackHandler(9);
            CompoundTag tag = UpgradableItemUtils.getSerializedUpgrades(stack);
            if (!tag.m_128456_()) {
                handler.deserializeNBT(tag);
            }
            UpgradeCache cache = new UpgradeCache(() -> handler);
            Objects.requireNonNull(stack.m_41783_()).m_128365_(NBT_UPGRADE_CACHE_TAG, (Tag)cache.toNBT());
        }
    }

    private static CompoundTag getSerializedUpgrades(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return new CompoundTag();
        }
        if (Objects.requireNonNull(stack.m_41783_()).m_128441_("BlockEntityTag")) {
            return Objects.requireNonNull(stack.m_41737_("BlockEntityTag")).m_128469_(NBT_UPGRADE_TAG);
        }
        return stack.m_41783_().m_128469_(NBT_UPGRADE_TAG);
    }
}

