/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.server.ServerLifecycleHooks;

public class GlobalPosHelper {
    public static CompoundTag toNBT(GlobalPos globalPos) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)globalPos.m_122646_()));
        tag.m_128359_("dim", globalPos.m_122640_().m_135782_().toString());
        return tag;
    }

    public static GlobalPos fromNBT(CompoundTag tag) {
        ResourceKey worldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dim")));
        return GlobalPos.m_122643_((ResourceKey)worldKey, (BlockPos)NbtUtils.m_129239_((CompoundTag)tag.m_128469_("pos")));
    }

    public static JsonElement toJson(GlobalPos pos) {
        JsonObject posObj = new JsonObject();
        posObj.addProperty("x", (Number)pos.m_122646_().m_123341_());
        posObj.addProperty("y", (Number)pos.m_122646_().m_123342_());
        posObj.addProperty("z", (Number)pos.m_122646_().m_123343_());
        JsonObject obj = new JsonObject();
        obj.addProperty("dimension", pos.m_122640_().m_135782_().toString());
        obj.add("pos", (JsonElement)posObj);
        return obj;
    }

    public static GlobalPos fromJson(JsonObject json) {
        ResourceKey worldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"dimension")));
        JsonObject posObj = json.get("pos").getAsJsonObject();
        BlockPos pos = new BlockPos(GsonHelper.m_13927_((JsonObject)posObj, (String)"x"), GsonHelper.m_13927_((JsonObject)posObj, (String)"y"), GsonHelper.m_13927_((JsonObject)posObj, (String)"z"));
        return GlobalPos.m_122643_((ResourceKey)worldKey, (BlockPos)pos);
    }

    public static ServerLevel getWorldForGlobalPos(GlobalPos pos) {
        return ServerLifecycleHooks.getCurrentServer().m_129880_(pos.m_122640_());
    }

    public static GlobalPos makeGlobalPos(Level w, BlockPos pos) {
        return GlobalPos.m_122643_((ResourceKey)w.m_46472_(), (BlockPos)pos);
    }

    public static boolean isSameWorld(GlobalPos pos, Level world) {
        return pos.m_122640_().compareTo(world.m_46472_()) == 0;
    }

    public static String prettyPrint(GlobalPos pos) {
        BlockPos p = pos.m_122646_();
        String dim = pos.m_122640_().m_135782_().toString();
        return String.format("%s [%d,%d,%d]", dim, p.m_123341_(), p.m_123342_(), p.m_123343_());
    }

    public static BlockEntity getTileEntity(GlobalPos globalPos) {
        ServerLevel world = GlobalPosHelper.getWorldForGlobalPos(globalPos);
        if (world != null && world.m_46749_(globalPos.m_122646_())) {
            return world.m_7702_(globalPos.m_122646_());
        }
        return null;
    }
}

