/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.List;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public abstract class AbstractRedstoneReceivingModule
extends AbstractTubeModule {
    private int redstoneLevel;

    AbstractRedstoneReceivingModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.redstoneLevel = tag.m_128451_("redstone");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128405_("redstone", this.redstoneLevel);
        return tag;
    }

    @Override
    public void addInfo(List<Component> curInfo) {
        super.addInfo(curInfo);
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.redstoneModule.receiving", this.redstoneLevel));
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.tubeModule.threshold", PneumaticCraftUtils.roundNumberTo(this.getThreshold(), 1)));
    }

    @Override
    public void onNeighborBlockUpdate() {
        this.redstoneLevel = this.pressureTube.m_58904_().m_46755_(this.pressureTube.m_58899_());
    }

    public int getReceivingRedstoneLevel() {
        return this.redstoneLevel;
    }

    public float getThreshold() {
        return this.getThreshold(this.redstoneLevel);
    }

    @Override
    public boolean hasGui() {
        return this.upgraded;
    }

    @Override
    public void tickCommon() {
        if (this.upgraded && !this.advancedConfig && this.higherBound != this.lowerBound) {
            this.higherBound = this.lowerBound;
            this.sendDescriptionPacket();
        }
    }
}

