/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.waila;

import java.util.LinkedHashSet;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.heat.TemperatureData;
import me.desht.pneumaticcraft.common.thirdparty.waila.IInfoForwarder;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class PneumaticProvider {

    public static class Component
    implements IComponentProvider {
        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            CompoundTag tag = blockAccessor.getServerData();
            BlockEntity te = blockAccessor.getBlockEntity();
            if (te instanceof IInfoForwarder) {
                BlockPos infoPos = new BlockPos(tag.m_128451_("infoX"), tag.m_128451_("infoY"), tag.m_128451_("infoZ"));
                te = blockAccessor.getLevel().m_7702_(infoPos);
            }
            if (te != null) {
                ListTag l = tag.m_128437_("pressure", 9);
                for (int i = 0; i < l.size(); ++i) {
                    ListTag l2 = l.m_128744_(i);
                    String pressureStr = PneumaticCraftUtils.roundNumberTo(l2.m_128775_(0), 2);
                    String dangerPressureStr = PneumaticCraftUtils.roundNumberTo(l2.m_128775_(1), 1);
                    iTooltip.add((net.minecraft.network.chat.Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressureMax", pressureStr, dangerPressureStr));
                }
                this.handleHeatData(iTooltip, tag);
                if (blockAccessor.getPlayer().m_6047_()) {
                    this.handleFluidData(iTooltip, tag);
                }
            }
        }

        private void handleFluidData(ITooltip tooltip, CompoundTag tag) {
            ListTag list = tag.m_128437_("tanks", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag subtag = list.m_128728_(i);
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)subtag);
                TranslatableComponent fluidDesc = fluidStack.isEmpty() ? PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]) : PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.fluidmB", fluidStack.getAmount()).m_130946_(" ").m_7220_((net.minecraft.network.chat.Component)PneumaticCraftUtils.xlate(fluidStack.getTranslationKey(), new Object[0]));
                tooltip.add((net.minecraft.network.chat.Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.tank", i + 1, fluidDesc.m_6881_().m_130940_(ChatFormatting.AQUA)));
            }
        }

        private void handleHeatData(ITooltip tooltip, CompoundTag tag) {
            if (tag.m_128441_("heatData")) {
                TemperatureData tempData = TemperatureData.fromNBT(tag.m_128469_("heatData"));
                if (tempData.isMultisided()) {
                    for (Direction face : DirectionUtil.VALUES) {
                        if (!tempData.hasData(face)) continue;
                        tooltip.add(HeatUtil.formatHeatString(face, (int)tempData.getTemperature(face)));
                    }
                } else if (tempData.hasData(null)) {
                    tooltip.add(HeatUtil.formatHeatString((int)tempData.getTemperature(null)));
                }
            }
        }
    }

    public static class Data
    implements IServerDataProvider<BlockEntity> {
        public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, BlockEntity blockEntity, boolean b) {
            BlockEntity beInfo;
            if (blockEntity instanceof IInfoForwarder) {
                IInfoForwarder forwarder = (IInfoForwarder)blockEntity;
                beInfo = forwarder.getInfoBlockEntity();
                if (beInfo != null) {
                    compoundTag.m_128405_("infoX", beInfo.m_58899_().m_123341_());
                    compoundTag.m_128405_("infoY", beInfo.m_58899_().m_123342_());
                    compoundTag.m_128405_("infoZ", beInfo.m_58899_().m_123343_());
                }
            } else {
                beInfo = blockEntity;
            }
            if (beInfo != null) {
                LinkedHashSet set = new LinkedHashSet();
                beInfo.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(set::add);
                for (Direction d : DirectionUtil.VALUES) {
                    beInfo.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, d).ifPresent(set::add);
                }
                ListTag l = new ListTag();
                for (IAirHandlerMachine h2 : set) {
                    ListTag l2 = new ListTag();
                    l2.add((Object)FloatTag.m_128566_((float)h2.getPressure()));
                    l2.add((Object)FloatTag.m_128566_((float)h2.getDangerPressure()));
                    l.add((Object)l2);
                }
                compoundTag.m_128365_("pressure", (Tag)l);
                if (beInfo.getCapability(PNCCapabilities.HEAT_EXCHANGER_CAPABILITY).isPresent()) {
                    compoundTag.m_128365_("heatData", (Tag)new TemperatureData((ICapabilityProvider)beInfo).toNBT());
                }
                beInfo.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(h -> {
                    ListTag list = new ListTag();
                    for (int i = 0; i < h.getTanks(); ++i) {
                        list.add((Object)h.getFluidInTank(i).writeToNBT(new CompoundTag()));
                    }
                    compoundTag.m_128365_("tanks", (Tag)list);
                });
            }
        }
    }
}

