/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import me.desht.pneumaticcraft.common.progwidgets.IEntityProvider;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

class EntityFilterPair<T extends IProgWidget & IEntityProvider> {
    private final T widget;
    private final EntityFilter entityWhitelist;
    private final EntityFilter entityBlacklist;
    private String errorWhite = "";
    private String errorBlack = "";

    EntityFilterPair(T widget) {
        this.widget = widget;
        this.entityWhitelist = this.getFilter(widget, true);
        this.entityBlacklist = this.getFilter(widget, false);
    }

    public static <T extends IProgWidget & IEntityProvider> void addErrors(T widget, List<Component> errors) {
        EntityFilterPair<T> filter = new EntityFilterPair<T>(widget);
        if (!filter.errorWhite.isEmpty()) {
            errors.add((Component)new TextComponent("Invalid whitelist filter: " + filter.errorWhite));
        }
        if (!filter.errorBlack.isEmpty()) {
            errors.add((Component)new TextComponent("Invalid blacklist filter: " + filter.errorBlack));
        }
    }

    private EntityFilter getFilter(T widget, boolean whitelist) {
        try {
            return EntityFilter.fromProgWidget(widget, whitelist);
        }
        catch (IllegalArgumentException e) {
            if (whitelist) {
                this.errorWhite = e.getMessage();
                return EntityFilter.allow();
            }
            this.errorBlack = e.getMessage();
            return EntityFilter.deny();
        }
    }

    boolean isEntityValid(Entity e) {
        return this.entityWhitelist.test(e) && !this.entityBlacklist.test(e);
    }

    List<Entity> getValidEntities(Level world) {
        return this.getEntitiesInArea((ProgWidgetArea)this.widget.getConnectedParameters()[0], (ProgWidgetArea)this.widget.getConnectedParameters()[this.widget.getParameters().size()], world);
    }

    private List<Entity> getEntitiesInArea(ProgWidgetArea whitelistWidget, ProgWidgetArea blacklistWidget, Level world) {
        if (whitelistWidget == null) {
            return new ArrayList<Entity>();
        }
        HashSet<Entity> entities = new HashSet<Entity>();
        ProgWidgetArea widget = whitelistWidget;
        while (widget != null) {
            entities.addAll(widget.getEntitiesWithinArea(world, this.entityWhitelist));
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        widget = blacklistWidget;
        while (widget != null) {
            widget.getEntitiesWithinArea(world, this.entityWhitelist).forEach(entities::remove);
            widget = (ProgWidgetArea)widget.getConnectedParameters()[0];
        }
        if (this.entityBlacklist != null) {
            entities.removeIf(this.entityBlacklist);
        }
        return new ArrayList<Entity>(entities);
    }

    public String getFilterString() {
        int pos = ((IEntityProvider)this.widget).getEntityFilterPosition();
        IProgWidget whitelist = this.widget.getConnectedParameters()[pos];
        IProgWidget blacklist = this.widget.getConnectedParameters()[this.widget.getParameters().size() + pos];
        if (whitelist instanceof ProgWidgetText) {
            ProgWidgetText txt = (ProgWidgetText)whitelist;
            return txt.string;
        }
        if (blacklist instanceof ProgWidgetText) {
            ProgWidgetText txt = (ProgWidgetText)blacklist;
            return "!" + txt.string;
        }
        return "";
    }
}

