/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateGPSAreaTool {
    private CompoundTag areaWidgetData;
    private InteractionHand hand;

    public PacketUpdateGPSAreaTool(ProgWidgetArea area, InteractionHand hand) {
        this.hand = hand;
        this.areaWidgetData = new CompoundTag();
        area.writeToNBT(this.areaWidgetData);
    }

    public PacketUpdateGPSAreaTool(FriendlyByteBuf buffer) {
        try {
            this.areaWidgetData = buffer.m_130260_();
            this.hand = buffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toBytes(FriendlyByteBuf buffer) {
        try {
            buffer.m_130079_(this.areaWidgetData);
            buffer.writeBoolean(this.hand == InteractionHand.MAIN_HAND);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            if (((NetworkEvent.Context)ctx.get()).getSender() != null && (stack = ((NetworkEvent.Context)ctx.get()).getSender().m_21120_(this.hand)).m_41720_() == ModItems.GPS_AREA_TOOL.get()) {
                stack.m_41751_(this.areaWidgetData);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

