/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.List;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.DroneDebugClientHandler;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.network.PacketDroneDebugBase;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.WidgetSerializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class PacketSyncDroneEntityProgWidgets
extends PacketDroneDebugBase {
    private final List<IProgWidget> progWidgets;

    public PacketSyncDroneEntityProgWidgets(IDroneBase drone) {
        super(drone);
        this.progWidgets = drone.getActiveAIManager().widgets();
    }

    PacketSyncDroneEntityProgWidgets(FriendlyByteBuf buf) {
        super(buf);
        this.progWidgets = WidgetSerializer.readWidgetsFromPacket(buf);
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        super.toBytes(buf);
        WidgetSerializer.writeProgWidgetsToPacket(this.progWidgets, buf);
    }

    @Override
    void handle(Player player, IDroneBase droneBase) {
        List<IProgWidget> widgets = droneBase.getProgWidgets();
        widgets.clear();
        widgets.addAll(this.progWidgets);
        DroneDebugClientHandler.onWidgetsChanged();
    }
}

