/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.loot;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class PNCDungeonLootModifier
extends LootModifier {
    public PNCDungeonLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (((Boolean)ConfigHelper.common().general.enableDungeonLoot.get()).booleanValue()) {
            generatedLoot.addAll(CustomPools.roll(context));
        }
        return generatedLoot;
    }

    private static class CustomPools {
        private static LootPool commonPool = null;
        private static LootPool uncommonPool = null;
        private static LootPool rarePool = null;

        private CustomPools() {
        }

        private static List<ItemStack> roll(LootContext ctx) {
            if (commonPool == null) {
                commonPool = CustomPools.buildLootPool("common");
                uncommonPool = CustomPools.buildLootPool("uncommon");
                rarePool = CustomPools.buildLootPool("rare");
            }
            ArrayList<ItemStack> res = new ArrayList<ItemStack>();
            commonPool.m_79053_(res::add, ctx);
            uncommonPool.m_79053_(res::add, ctx);
            rarePool.m_79053_(res::add, ctx);
            return res;
        }

        private static LootPool buildLootPool(String name) {
            return LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)PneumaticRegistry.RL("custom/" + name + "_dungeon_loot")).m_79707_(1)).name("pneumaticcraft_custom_" + name).m_79082_();
        }
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<PNCDungeonLootModifier> {
        public PNCDungeonLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] lootConditions) {
            return new PNCDungeonLootModifier(lootConditions);
        }

        public JsonObject write(PNCDungeonLootModifier instance) {
            return this.makeConditions(instance.conditions);
        }
    }
}

