/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.item.minigun.MinigunItem;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class MinigunMagazineMenu
extends AbstractPneumaticCraftMenu<AbstractPneumaticCraftBlockEntity> {
    private final MinigunItem.MagazineHandler gunInv;
    private final InteractionHand hand;

    public MinigunMagazineMenu(int i, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(i, playerInventory, MinigunMagazineMenu.getHand(buffer));
    }

    public MinigunMagazineMenu(int windowId, Inventory playerInventory, InteractionHand hand) {
        super((MenuType)ModMenuTypes.MINIGUN_MAGAZINE.get(), windowId, playerInventory);
        this.hand = hand;
        MinigunItem minigun = (MinigunItem)playerInventory.f_35978_.m_21120_(hand).m_41720_();
        this.gunInv = minigun.getMagazine(playerInventory.f_35978_.m_21120_(hand));
        for (int i = 0; i < this.gunInv.getSlots(); ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.gunInv, i, 26 + i % 2 * 18, 26 + i / 2 * 18));
        }
        this.addPlayerSlots(playerInventory, 84);
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.gunInv.save();
    }

    @Override
    public boolean m_6875_(Player player) {
        return player.m_21120_(this.hand).m_41720_() == ModItems.MINIGUN.get();
    }

    @Override
    @Nonnull
    public void m_150399_(int slotId, int dragType, ClickType clickType, Player player) {
        if (clickType == ClickType.CLONE && dragType == 2 && slotId >= 0 && slotId < 4) {
            ItemStack gunStack = player.m_21120_(this.hand);
            if (gunStack.m_41720_() instanceof MinigunItem) {
                int slot = MinigunItem.getLockedSlot(gunStack);
                if (slot == slotId) {
                    NBTUtils.removeTag(gunStack, "LockedSlot");
                } else {
                    NBTUtils.setInteger(gunStack, "LockedSlot", slotId);
                }
                if (player.f_19853_.f_46443_) {
                    player.m_5496_(SoundEvents.f_12490_, 0.5f, 1.0f);
                }
            }
        } else {
            super.m_150399_(slotId, dragType, clickType, player);
            this.gunInv.save();
        }
    }

    public InteractionHand getHand() {
        return this.hand;
    }
}

