/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.hacking.entity;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IHackableEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class HackableMobDisarm
implements IHackableEntity {
    private static final ResourceLocation ID = PneumaticRegistry.RL("mob_disarm");

    @Override
    public ResourceLocation getHackableId() {
        return ID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canHack(Entity entity, Player player) {
        if (!(entity instanceof Mob)) return false;
        Mob mob = (Mob)entity;
        if (!Arrays.stream(EquipmentSlot.values()).anyMatch(slot -> !mob.m_6844_(slot).m_41619_())) return false;
        return true;
    }

    @Override
    public void addHackInfo(Entity entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.result.disarm", new Object[0]));
    }

    @Override
    public void addPostHackInfo(Entity entity, List<Component> curInfo, Player player) {
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.hacking.finished.disarmed", new Object[0]));
    }

    @Override
    public int getHackTime(Entity entity, Player player) {
        return 60;
    }

    @Override
    public void onHackFinished(Entity entity, Player player) {
        if (!entity.f_19853_.f_46443_) {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (!this.doDisarm((Mob)entity, slot, player.m_21187_())) continue;
                return;
            }
        }
    }

    @Override
    public boolean afterHackTick(Entity entity) {
        return false;
    }

    private boolean doDisarm(Mob entity, EquipmentSlot slot, Random rand) {
        if (entity.m_6844_(slot).m_41619_()) {
            return false;
        }
        float[] dropChances = slot.m_20743_() == EquipmentSlot.Type.ARMOR ? entity.f_21348_ : entity.f_21347_;
        int slotIdx = slot.m_20749_();
        boolean noDamage = dropChances[slotIdx] > 1.0f;
        ItemStack stack = entity.m_6844_(slot);
        if (!stack.m_41619_() && rand.nextFloat() < dropChances[slotIdx]) {
            if (!noDamage && stack.m_41763_()) {
                int k = Math.max(stack.m_41776_() - 25, 1);
                int l = stack.m_41776_() - rand.nextInt(rand.nextInt(k) + 1);
                stack.m_41721_(Mth.m_14045_((int)l, (int)1, (int)k));
            }
            entity.m_5552_(stack, 0.0f);
        }
        entity.m_8061_(slot, ItemStack.f_41583_);
        return true;
    }
}

