/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.crafting.TemperatureRange;
import me.desht.pneumaticcraft.api.crafting.recipe.RefineryRecipe;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.AbstractTickingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IComparatorSupport;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.block.entity.RefineryOutputBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.SmartSyncTank;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModRecipeTypes;
import me.desht.pneumaticcraft.common.inventory.RefineryMenu;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.FluidUtils;
import me.desht.pneumaticcraft.common.util.PNCFluidTank;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;

public class RefineryControllerBlockEntity
extends AbstractTickingBlockEntity
implements IRedstoneControl<RefineryControllerBlockEntity>,
IComparatorSupport,
ISerializableTanks,
MenuProvider,
IHeatExchangingTE {
    @GuiSynced
    @DescSynced
    private final RefineryInputTank inputTank = new RefineryInputTank(16000);
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.inputTank);
    @GuiSynced
    public final SyncOnlyTank[] outputsSynced = new SyncOnlyTank[4];
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);
    @GuiSynced
    private final RedstoneController<RefineryControllerBlockEntity> rsController = new RedstoneController<RefineryControllerBlockEntity>(this);
    @GuiSynced
    private boolean blocked;
    @GuiSynced
    public int minTemp;
    @GuiSynced
    public int maxTemp;
    @GuiSynced
    private String currentRecipeIdSynced = "";
    @DescSynced
    private int outputCount;
    @DescSynced
    private int lastProgress;
    private List<LazyOptional<IFluidHandler>> outputCache;
    private TemperatureRange operatingTemp = TemperatureRange.invalid();
    private RefineryRecipe currentRecipe;
    private int workTimer = 0;
    private int comparatorValue;
    private int prevOutputCount = -1;
    private boolean searchForRecipe = true;
    private int nPlayersUsing = 0;

    public RefineryControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.REFINERY.get()), pos, state);
        for (int i = 0; i < 4; ++i) {
            this.outputsSynced[i] = new SyncOnlyTank(this, 16000);
        }
    }

    public static boolean isInputFluidValid(Level world, Fluid fluid, int size) {
        RefineryRecipe recipe = ((PneumaticCraftRecipeType)ModRecipeTypes.REFINERY.get()).findFirst(world, r -> r.getOutputs().size() <= size && FluidUtils.matchFluid(r.getInput(), fluid, true));
        return recipe != null;
    }

    private RefineryRecipe getRecipeFor(FluidStack fluid) {
        return ((PneumaticCraftRecipeType)ModRecipeTypes.REFINERY.get()).stream(this.f_58857_).filter(r -> r.getOutputs().size() <= this.outputCount).filter(r -> FluidUtils.matchFluid(r.getInput(), fluid, true)).max(Comparator.comparingInt(r2 -> r2.getOutputs().size())).orElse(null);
    }

    @Override
    public void tickCommonPre() {
        super.tickCommonPre();
        this.inputTank.tick();
    }

    @Override
    public void tickClient() {
        RefineryOutputBlockEntity teRO;
        super.tickClient();
        if (this.lastProgress > 0 && (teRO = this.findAdjacentOutput()) != null) {
            for (int i = 0; i < this.lastProgress; ++i) {
                ClientUtils.emitParticles(this.m_58904_(), teRO.m_58899_().m_5484_(Direction.UP, this.outputCount - 1), (ParticleOptions)ParticleTypes.f_123762_);
            }
        }
        for (SyncOnlyTank smartSyncTank : this.outputsSynced) {
            smartSyncTank.tick();
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.lastProgress = 0;
        if (this.outputCache == null) {
            this.cacheRefineryOutputs();
        }
        this.outputCount = this.outputCache.size();
        if (this.prevOutputCount != this.outputCount) {
            this.searchForRecipe = true;
        }
        if (this.searchForRecipe) {
            this.currentRecipe = this.getRecipeFor(this.inputTank.getFluid());
            this.currentRecipeIdSynced = this.currentRecipe == null ? "" : this.currentRecipe.m_6423_().toString();
            this.operatingTemp = this.currentRecipe == null ? TemperatureRange.invalid() : this.currentRecipe.getOperatingTemp();
            this.minTemp = this.operatingTemp.getMin();
            this.maxTemp = this.operatingTemp.getMax();
            this.searchForRecipe = false;
        }
        boolean hasWork = false;
        if (this.currentRecipe != null) {
            if (this.prevOutputCount != this.outputCount && this.outputCount > 1) {
                this.redistributeFluids();
            }
            if (this.outputCount > 1 && this.doesRedstoneAllow() && this.doRefiningStep(IFluidHandler.FluidAction.SIMULATE)) {
                hasWork = true;
                if (this.operatingTemp.inRange(this.heatExchanger.getTemperature()) && this.inputTank.getFluidAmount() >= this.currentRecipe.getInput().getAmount()) {
                    int progress = Math.max(0, ((int)this.heatExchanger.getTemperature() - (this.operatingTemp.getMin() - 30)) / 30);
                    progress = Math.min(5, progress);
                    this.heatExchanger.addHeat(-progress);
                    this.workTimer += progress;
                    while (this.workTimer >= 20 && this.inputTank.getFluidAmount() >= this.currentRecipe.getInput().getAmount()) {
                        this.workTimer -= 20;
                        this.doRefiningStep(IFluidHandler.FluidAction.EXECUTE);
                        this.inputTank.drain(this.currentRecipe.getInput().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    this.lastProgress = progress;
                }
            } else {
                this.workTimer = 0;
            }
        }
        if (this.nPlayersUsing > 0) {
            IntStream.range(0, this.outputCount).forEach(i -> this.outputCache.get(i).ifPresent(h -> {
                if (!this.outputsSynced[i].getFluid().isFluidStackIdentical(h.getFluidInTank(0))) {
                    this.outputsSynced[i].setFluid(h.getFluidInTank(0).copy());
                    this.outputsSynced[i].tick();
                }
            }));
        }
        this.prevOutputCount = this.outputCount;
        this.maybeUpdateComparatorValue(hasWork);
    }

    private void redistributeFluids() {
        int i;
        FluidTank[] tempTanks = new FluidTank[this.outputCount];
        for (i = 0; i < this.outputCount; ++i) {
            tempTanks[i] = new FluidTank(16000);
        }
        for (i = 0; i < this.outputCount && i < this.currentRecipe.getOutputs().size(); ++i) {
            FluidStack wantedFluid = this.currentRecipe.getOutputs().get(i);
            this.outputCache.get(i).ifPresent(outputHandler -> {
                FluidStack fluid = outputHandler.getFluidInTank(0);
                if (!fluid.isFluidEqual(wantedFluid)) {
                    for (int j = 0; j < this.currentRecipe.getOutputs().size(); ++j) {
                        if (!this.currentRecipe.getOutputs().get(j).isFluidEqual(fluid)) continue;
                        this.tryMoveFluid((IFluidHandler)outputHandler, (IFluidHandler)tempTanks[j]);
                        break;
                    }
                }
            });
        }
        for (i = 0; i < this.outputCount; ++i) {
            FluidTank tempTank = tempTanks[i];
            this.outputCache.get(i).ifPresent(arg_0 -> this.lambda$redistributeFluids$9((IFluidHandler)tempTank, arg_0));
        }
    }

    private void tryMoveFluid(IFluidHandler sourceHandler, IFluidHandler destHandler) {
        int moved;
        FluidStack fluid = sourceHandler.drain(sourceHandler.getTankCapacity(0), IFluidHandler.FluidAction.SIMULATE);
        if (!fluid.isEmpty() && (moved = destHandler.fill(fluid, IFluidHandler.FluidAction.EXECUTE)) > 0) {
            sourceHandler.drain(moved, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void cacheRefineryOutputs() {
        if (this.m_58901_()) {
            return;
        }
        ArrayList<LazyOptional<IFluidHandler>> cache = new ArrayList<LazyOptional<IFluidHandler>>();
        RefineryOutputBlockEntity output = this.findAdjacentOutput();
        while (output != null) {
            LazyOptional handler = output.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN);
            if (handler.isPresent()) {
                handler.addListener(l -> this.cacheRefineryOutputs());
            }
            cache.add(handler);
            BlockEntity te = output.getCachedNeighbor(Direction.UP);
            output = te instanceof RefineryOutputBlockEntity ? (RefineryOutputBlockEntity)te : null;
        }
        this.outputCache = cache;
    }

    public RefineryOutputBlockEntity findAdjacentOutput() {
        for (Direction d : DirectionUtil.VALUES) {
            BlockEntity te;
            if (d == Direction.DOWN || !((te = this.getCachedNeighbor(d)) instanceof RefineryOutputBlockEntity)) continue;
            return (RefineryOutputBlockEntity)te;
        }
        return null;
    }

    private boolean doRefiningStep(IFluidHandler.FluidAction action) {
        List<FluidStack> recipeOutputs = this.currentRecipe.getOutputs();
        for (int i = 0; i < this.outputCache.size() && i < recipeOutputs.size(); ++i) {
            FluidStack outFluid = recipeOutputs.get(i);
            int filled = this.outputCache.get(i).map(h -> h.fill(outFluid, action)).orElse(0);
            if (filled == outFluid.getAmount()) continue;
            this.blocked = true;
            return false;
        }
        this.blocked = false;
        return true;
    }

    private boolean doesRedstoneAllow() {
        int totalPower = this.getRedstoneController().getCurrentRedstonePower();
        RefineryOutputBlockEntity teRO = this.findAdjacentOutput();
        if (teRO != null) {
            while (teRO.getCachedNeighbor(Direction.UP) instanceof RefineryOutputBlockEntity) {
                totalPower = Math.max(totalPower, teRO.getRedstoneController().getCurrentRedstonePower());
                teRO = (RefineryOutputBlockEntity)teRO.getCachedNeighbor(Direction.UP);
            }
        }
        return switch (this.getRedstoneController().getCurrentMode()) {
            case 0 -> true;
            case 1 -> {
                if (totalPower > 0) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (totalPower == 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public String getCurrentRecipeIdSynced() {
        return this.currentRecipeIdSynced;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    public IFluidTank getInputTank() {
        return this.inputTank;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public RedstoneController<RefineryControllerBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    private void maybeUpdateComparatorValue(boolean hasWork) {
        int newValue = hasWork && this.currentRecipe != null && this.inputTank.getFluidAmount() >= this.currentRecipe.getInput().getAmount() && this.outputCount >= this.currentRecipe.getOutputs().size() ? 15 : 0;
        if (newValue != this.comparatorValue) {
            this.comparatorValue = newValue;
            this.nonNullLevel().m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
            RefineryOutputBlockEntity output = this.findAdjacentOutput();
            while (output != null && !output.m_58900_().m_60795_()) {
                this.nonNullLevel().m_46717_(output.m_58899_(), output.m_58900_().m_60734_());
                BlockEntity te = output.getCachedNeighbor(Direction.UP);
                output = te instanceof RefineryOutputBlockEntity ? (RefineryOutputBlockEntity)te : null;
            }
        }
    }

    @Override
    public int getComparatorValue() {
        return this.comparatorValue;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    @Nonnull
    public Map<String, PNCFluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"OilTank", (Object)this.inputTank);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new RefineryMenu(i, playerInventory, this.m_58899_());
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    @Override
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }

    public void incPlayersUsing() {
        ++this.nPlayersUsing;
    }

    public void decPlayersUsing() {
        if (this.nPlayersUsing == 0) {
            Log.warning("decPlayersUsing() called for " + this + " but already 0?", new Object[0]);
        } else {
            this.nPlayersUsing = Math.max(0, this.nPlayersUsing - 1);
        }
    }

    private /* synthetic */ void lambda$redistributeFluids$9(IFluidHandler tempTank, IFluidHandler outputHandler) {
        this.tryMoveFluid(tempTank, outputHandler);
    }

    private class RefineryInputTank
    extends SmartSyncTank {
        RefineryInputTank(int capacity) {
            super(RefineryControllerBlockEntity.this, capacity);
        }

        @Override
        public boolean isFluidValid(FluidStack fluid) {
            return this.getFluid().isFluidEqual(fluid) || RefineryControllerBlockEntity.isInputFluidValid(RefineryControllerBlockEntity.this.f_58857_, fluid.getFluid(), 4);
        }

        @Override
        protected void onContentsChanged(Fluid prevFluid, int prevAmount) {
            super.onContentsChanged(prevFluid, prevAmount);
            Fluid newFluid = this.getFluid().getFluid();
            if (prevFluid != newFluid || RefineryControllerBlockEntity.this.currentRecipe == null && this.getFluidAmount() > prevAmount || RefineryControllerBlockEntity.this.currentRecipe != null && this.getFluidAmount() < prevAmount) {
                RefineryControllerBlockEntity.this.searchForRecipe = true;
            }
        }
    }

    private static class SyncOnlyTank
    extends SmartSyncTank {
        SyncOnlyTank(BlockEntity owner, int capacity) {
            super(owner, capacity);
        }

        @Override
        protected void onContentsChanged(Fluid prevFluid, int prevAmount) {
        }
    }
}

