/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.PneumaticDynamoBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.PneumaticEnergyStorage;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.inventory.PneumaticDynamoMenu;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class PneumaticDynamoBlockEntity
extends AbstractAirHandlingBlockEntity
implements IRedstoneControl<PneumaticDynamoBlockEntity>,
IMinWorkingPressure,
MenuProvider,
IHeatExchangingTE {
    private final PneumaticEnergyStorage energy = new PneumaticEnergyStorage(100000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    @GuiSynced
    private int rfPerTick;
    @GuiSynced
    private int airPerTick;
    private boolean isEnabled;
    @GuiSynced
    private final RedstoneController<PneumaticDynamoBlockEntity> rsController = new RedstoneController<PneumaticDynamoBlockEntity>(this);
    @GuiSynced
    private final IHeatExchangerLogic heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
    private final LazyOptional<IHeatExchangerLogic> heatCap = LazyOptional.of(() -> this.heatExchanger);

    public PneumaticDynamoBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PNEUMATIC_DYNAMO.get(), pos, state, PressureTier.TIER_TWO, 10000, 4);
    }

    public int getEfficiency() {
        return HeatUtil.getEfficiency(this.heatExchanger.getTemperatureAsInt());
    }

    @Override
    public void tickServer() {
        BlockEntity receiver;
        boolean newEnabled;
        super.tickServer();
        Level level = this.nonNullLevel();
        if (level.m_46467_() % 20L == 0L) {
            int efficiency = Math.max(1, (Integer)ConfigHelper.common().machines.pneumaticDynamoEfficiency.get());
            this.airPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades() * 100.0f / (float)efficiency);
            this.rfPerTick = (int)(40.0f * this.getSpeedUsageMultiplierFromUpgrades() * (float)this.getEfficiency() / 100.0f);
        }
        if (this.rsController.shouldRun() && this.getPressure() > this.getMinWorkingPressure() && this.energy.getMaxEnergyStored() - this.energy.getEnergyStored() >= this.rfPerTick) {
            this.addAir(-this.airPerTick);
            this.heatExchanger.addHeat((double)this.airPerTick / 100.0);
            this.energy.receiveEnergy(this.rfPerTick, false);
            newEnabled = true;
        } else {
            newEnabled = false;
        }
        if ((level.m_46467_() & 0xFL) == 0L && newEnabled != this.isEnabled) {
            this.isEnabled = newEnabled;
            BlockState state = level.m_8055_(this.f_58858_);
            level.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)PneumaticDynamoBlock.ACTIVE, (Comparable)Boolean.valueOf(this.isEnabled)));
        }
        if ((receiver = this.getCachedNeighbor(this.getRotation())) != null) {
            receiver.getCapability(CapabilityEnergy.ENERGY, this.getRotation().m_122424_()).ifPresent(neighborStorage -> {
                int extracted = this.energy.extractEnergy(this.rfPerTick * 2, true);
                int energyPushed = neighborStorage.receiveEnergy(extracted, true);
                if (energyPushed > 0) {
                    neighborStorage.receiveEnergy(this.energy.extractEnergy(energyPushed, false), false);
                }
            });
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public RedstoneController<PneumaticDynamoBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side == this.getRotation().m_122424_();
    }

    @Override
    public float getMinWorkingPressure() {
        return 15.0f;
    }

    @Override
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return this.heatCap;
    }

    public int getRFRate() {
        return this.rfPerTick;
    }

    public int getAirRate() {
        return this.airPerTick;
    }

    public int getInfoEnergyStored() {
        return this.energy.getEnergyStored();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == CapabilityEnergy.ENERGY && (facing == this.getRotation() || facing == null) ? this.energyCap.cast() : super.getCapability(capability, facing);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.energy.writeToNBT(tag);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.energy.readFromNBT(tag);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
        return new PneumaticDynamoMenu(windowId, playerInventory, this.m_58899_());
    }

    @Override
    @Nullable
    public IHeatExchangerLogic getHeatExchanger(Direction dir) {
        return this.heatExchanger;
    }
}

