/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.common.PneumaticCraftTags;
import me.desht.pneumaticcraft.common.block.OmnidirectionalHopperBlock;
import me.desht.pneumaticcraft.common.block.entity.AbstractHopperBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.inventory.OmnidirectionalHopperMenu;
import me.desht.pneumaticcraft.common.inventory.handler.ComparatorItemStackHandler;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class OmnidirectionalHopperBlockEntity
extends AbstractHopperBlockEntity<OmnidirectionalHopperBlockEntity> {
    public static final int INVENTORY_SIZE = 5;
    private final ComparatorItemStackHandler itemHandler = new ComparatorItemStackHandler(this, this.getInvSize());
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.itemHandler);
    @GuiSynced
    public boolean roundRobin;
    private int rrSlot;
    @GuiSynced
    private final RedstoneController<OmnidirectionalHopperBlockEntity> rsController = new RedstoneController<OmnidirectionalHopperBlockEntity>(this);

    public OmnidirectionalHopperBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.OMNIDIRECTIONAL_HOPPER.get()), pos, state);
    }

    protected int getInvSize() {
        return 5;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    protected int getComparatorValueInternal() {
        return this.itemHandler.getComparatorValue();
    }

    @Override
    protected boolean doExport(int maxItems) {
        Direction outputDir = this.getRotation();
        LazyOptional<IItemHandler> inv = IOHelper.getInventoryForTE(this.getCachedNeighbor(outputDir), outputDir.m_122424_());
        int notExported = maxItems;
        if (inv.isPresent()) {
            notExported = inv.map(h -> this.exportToInventory((IItemHandler)h, maxItems)).orElse(maxItems);
        } else if (this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.ENTITY_TRACKER.get())) > 0) {
            notExported = this.tryEntityExport(maxItems, outputDir.m_122424_());
        }
        if (notExported == maxItems && ((Boolean)ConfigHelper.common().machines.omniHopperDispenser.get()).booleanValue() && this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.DISPENSER.get())) > 0) {
            notExported = this.exportToInventory(new DropInWorldHandler(this.m_58904_(), this.m_58899_(), outputDir), maxItems);
        }
        return notExported < maxItems;
    }

    private int tryEntityExport(int maxItems, Direction dir) {
        for (Entity e : this.cachedOutputEntities) {
            int notExported;
            if (!e.m_6084_() || (notExported = e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir).map(h -> this.exportToInventory((IItemHandler)h, maxItems)).orElse(maxItems).intValue()) >= maxItems) continue;
            return notExported;
        }
        return maxItems;
    }

    private int exportToInventory(IItemHandler otherHandler, int maxItems) {
        int remaining = maxItems;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            int amount;
            int slot = this.actualSlot(i);
            ItemStack exportedStack = this.itemHandler.extractItem(slot, (amount = this.itemHandler.getStackInSlot(slot).m_41613_()) - this.leaveMaterialCount, true);
            if (exportedStack.m_41613_() <= this.leaveMaterialCount) continue;
            exportedStack.m_41764_(Math.min(exportedStack.m_41613_(), remaining));
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)otherHandler, (ItemStack)exportedStack, (boolean)false);
            int exportedCount = exportedStack.m_41613_() - excess.m_41613_();
            if (!this.isCreative && exportedCount > 0) {
                this.itemHandler.extractItem(slot, exportedCount, false);
            }
            if ((remaining -= exportedCount) > this.leaveMaterialCount) continue;
            if (!this.roundRobin) break;
            this.rrSlot = slot + 1;
            if (this.rrSlot < this.itemHandler.getSlots()) break;
            this.rrSlot = 0;
            break;
        }
        return remaining;
    }

    private int actualSlot(int i) {
        if (this.roundRobin) {
            int slot = this.rrSlot + i;
            if (slot >= this.itemHandler.getSlots()) {
                slot -= this.itemHandler.getSlots();
            }
            return slot;
        }
        return i;
    }

    @Override
    protected boolean doImport(int maxItems) {
        boolean success = false;
        if (this.isInventoryFull()) {
            return false;
        }
        LazyOptional<IItemHandler> cap = IOHelper.getInventoryForTE(this.getCachedNeighbor(this.inputDir), this.inputDir.m_122424_());
        if (cap.isPresent()) {
            int imported = cap.map(otherHandler -> this.importFromInventory((IItemHandler)otherHandler, maxItems, false)).orElse(0);
            return imported > 0;
        }
        if (this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.ENTITY_TRACKER.get())) > 0 && this.tryEntityImport(maxItems) > 0) {
            return true;
        }
        BlockPos inputPos = this.f_58858_.m_142300_(this.inputDir);
        if (!Block.m_49863_((LevelReader)this.nonNullLevel(), (BlockPos)inputPos, (Direction)this.inputDir.m_122424_())) {
            for (Entity e : this.cachedInputEntities) {
                if (!e.m_6084_() || !(e instanceof ItemEntity)) continue;
                ItemEntity entity = (ItemEntity)e;
                ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)entity.m_32055_(), (boolean)false);
                if (remainder.m_41619_()) {
                    entity.m_146870_();
                    success = true;
                    continue;
                }
                if (remainder.m_41613_() >= entity.m_32055_().m_41613_()) continue;
                entity.m_32045_(remainder);
                success = true;
            }
        }
        return success;
    }

    private int tryEntityImport(int maxItems) {
        Direction dir = this.inputDir.m_122424_();
        int remaining = maxItems;
        for (Entity e : this.cachedInputEntities) {
            boolean playerArmor;
            if (!e.m_6084_() || e.m_6095_().m_204039_(PneumaticCraftTags.EntityTypes.OMNIHOPPER_BLACKLISTED)) continue;
            int r = remaining;
            boolean bl = playerArmor = e instanceof Player && dir.m_122434_().m_122479_();
            int imported = e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir).map(h -> this.importFromInventory((IItemHandler)h, r, playerArmor)).orElse(0);
            if ((remaining -= imported) > 0) continue;
            return maxItems - remaining;
        }
        return 0;
    }

    private int importFromInventory(IItemHandler inv, int maxItems, boolean playerArmor) {
        int remaining = maxItems;
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).m_41619_()) continue;
            ItemStack toExtract = inv.extractItem(i, remaining, true);
            if (playerArmor && EnchantmentHelper.m_44920_((ItemStack)toExtract)) continue;
            ItemStack excess = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)toExtract, (boolean)false);
            int transferred = toExtract.m_41613_() - excess.m_41613_();
            if (transferred <= 0) continue;
            inv.extractItem(i, transferred, false);
            if ((remaining -= transferred) > 0) continue;
            return maxItems;
        }
        return maxItems - remaining;
    }

    private boolean isInventoryFull() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!stack.m_41619_() && stack.m_41613_() >= stack.m_41741_()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void setupInputOutputRegions() {
        AABB bowl = OmnidirectionalHopperBlock.INPUT_SHAPES[this.inputDir.m_122411_()].m_83215_().m_82338_(this.f_58858_);
        this.inputAABB = bowl.m_82367_(new AABB(this.f_58858_.m_142300_(this.inputDir)));
        this.outputAABB = new AABB(this.m_58899_().m_142300_(this.getRotation()));
        this.cachedInputEntities.clear();
        this.cachedOutputEntities.clear();
    }

    @Override
    boolean shouldScanForEntities(Direction dir) {
        if (Block.m_49863_((LevelReader)this.nonNullLevel(), (BlockPos)this.f_58858_.m_142300_(dir), (Direction)dir.m_122424_()) || dir == this.getRotation() && this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.ENTITY_TRACKER.get())) == 0) {
            return false;
        }
        BlockEntity te = this.getCachedNeighbor(dir);
        return te == null || !te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.m_122424_()).isPresent();
    }

    @Override
    public int getItemTransferInterval() {
        return 8 / (1 << this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.SPEED.get())));
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
        tag.m_128379_("RoundRobin", this.roundRobin);
        if (this.roundRobin) {
            tag.m_128405_("RRSlot", this.rrSlot);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.itemHandler.deserializeNBT(tag.m_128469_("Items"));
        this.roundRobin = tag.m_128471_("RoundRobin");
        this.rrSlot = tag.m_128451_("RRSlot");
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new OmnidirectionalHopperMenu(i, playerInventory, this.m_58899_());
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (tag.equals("rr")) {
            this.roundRobin = !this.roundRobin;
            this.m_6596_();
        } else {
            super.handleGUIButtonPress(tag, shiftHeld, player);
        }
    }

    @Override
    public RedstoneController<OmnidirectionalHopperBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    private record DropInWorldHandler(Level world, BlockPos pos, Direction outputDir) implements IItemHandler
    {
        private DropInWorldHandler(Level world, BlockPos pos, Direction outputDir) {
            this.world = world;
            this.pos = pos.m_142300_(outputDir);
            this.outputDir = outputDir;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!Block.m_49863_((LevelReader)this.world, (BlockPos)this.pos, (Direction)this.outputDir.m_122424_())) {
                if (!simulate) {
                    PneumaticCraftUtils.dropItemOnGroundPrecisely(stack, this.world, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5);
                }
                return ItemStack.f_41583_;
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

