/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import java.util.Collection;
import me.desht.pneumaticcraft.api.crafting.recipe.AssemblyRecipe;
import me.desht.pneumaticcraft.common.block.entity.AbstractAssemblyRobotBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.AssemblyPlatformBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.util.CountedItemStacks;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class AssemblyIOUnitBlockEntity
extends AbstractAssemblyRobotBlockEntity {
    private static final byte SLEEP_TICKS = 50;
    private static final byte STATE_IDLE = 0;
    private static final byte STATE_SEARCH_SRC = 1;
    private static final byte STATE_CLOSECLAW_AFTER_PICKUP = 5;
    private static final byte STATE_RESET_CLOSECLAW_AFTER_PICKUP = 20;
    private static final byte STATE_RESET_GOTO_IDLE = 26;
    private static final byte STATE_MAX = 127;
    @DescSynced
    private boolean shouldClawClose;
    @DescSynced
    @LazySynced
    public float clawProgress;
    public float oldClawProgress;
    @DescSynced
    private final BaseItemStackHandler itemHandler = new BaseItemStackHandler(this, 1);
    private Collection<AssemblyRecipe> recipeList;
    private ItemStack searchedItemStack = ItemStack.f_41583_;
    private byte state = 0;
    private byte tickCounter = 0;

    public AssemblyIOUnitBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<?>)((BlockEntityType)ModBlockEntities.ASSEMBLY_IO_UNIT.get()), pos, state);
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (!this.isClawDone()) {
            this.moveClaw();
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.slowMode = false;
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                if (!this.findPickupLocation()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 2: 
            case 7: 
            case 22: {
                if (!this.hoverOverTarget()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 3: 
            case 8: 
            case 23: {
                this.slowMode = true;
                if (!this.gotoTarget()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 4: {
                if (!this.getItemFromCurrentDirection()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 5: 
            case 20: {
                if (!this.closeClaw()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 6: 
            case 21: {
                if (!this.findDropOffLocation()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 9: 
            case 24: {
                if (!this.openClaw()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 10: 
            case 25: {
                if (!this.putItemToCurrentDirection()) break;
                this.state = (byte)(this.state + 1);
                break;
            }
            case 11: 
            case 26: {
                if (this.gotoIdlePos()) {
                    this.state = 0;
                }
            }
            case 127: {
                break;
            }
            default: {
                System.out.printf("unexpected state: %d%n", this.state);
                this.state = (byte)127;
            }
        }
    }

    @Override
    public boolean reset() {
        if (this.state >= 20) {
            return false;
        }
        if (!this.itemHandler.getStackInSlot(0).m_41619_()) {
            this.state = (byte)20;
            return false;
        }
        if (this.state == 0) {
            return true;
        }
        this.state = (byte)26;
        return this.isIdle();
    }

    public boolean pickupItem(Collection<AssemblyRecipe> list) {
        this.recipeList = list;
        if (this.state == 0) {
            this.state = (byte)(this.state + 1);
        }
        return this.state > 0 && !this.isSleeping() && this.state < 127;
    }

    private boolean gotoIdlePos() {
        this.gotoHomePosition();
        return this.isDoneMoving();
    }

    private boolean findPickupLocation() {
        if (this.shouldSleep()) {
            return false;
        }
        AbstractAssemblyRobotBlockEntity.TargetDirections inventoryDir = null;
        if (this.isImportUnit()) {
            ItemImportResult result;
            this.searchedItemStack = ItemStack.f_41583_;
            if (this.recipeList != null && (result = this.findImportInventory()) != null) {
                this.searchedItemStack = result.stack;
                inventoryDir = result.targetDirs;
            }
        } else {
            inventoryDir = this.getPlatformDirection();
        }
        this.targetDirection = inventoryDir;
        if (this.targetDirection == null) {
            this.sleepBeforeNextSearch();
            return false;
        }
        return true;
    }

    private ItemImportResult findImportInventory() {
        for (Direction dir : DirectionUtil.HORIZONTALS) {
            ItemStack res;
            BlockEntity te = this.getCachedNeighbor(dir);
            if (te == null || (res = this.searchImportInventory(te)).m_41619_()) continue;
            return new ItemImportResult(dir, res);
        }
        for (Direction secDir : new Direction[]{Direction.WEST, Direction.EAST}) {
            for (Direction primDir : new Direction[]{Direction.NORTH, Direction.SOUTH}) {
                ItemStack res;
                BlockEntity te = this.m_58904_().m_7702_(this.m_58899_().m_142300_(primDir).m_142300_(secDir));
                if (te == null || (res = this.searchImportInventory(te)).m_41619_()) continue;
                return new ItemImportResult(primDir, secDir, res);
            }
        }
        return null;
    }

    private ItemStack searchImportInventory(BlockEntity te) {
        CountedItemStacks counted = IOHelper.getInventoryForTE(te, Direction.UP).map(CountedItemStacks::new).orElse(null);
        if (counted != null) {
            NonNullList<ItemStack> stacks = counted.coalesce();
            for (AssemblyRecipe recipe : this.recipeList) {
                for (ItemStack stack : stacks) {
                    if (!recipe.matches(stack)) continue;
                    return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)recipe.getInputAmount());
                }
            }
        }
        return ItemStack.f_41583_;
    }

    private boolean isSleeping() {
        return this.tickCounter > 0;
    }

    private boolean shouldSleep() {
        if (this.tickCounter > 0) {
            byte by = this.tickCounter;
            this.tickCounter = (byte)(by + 1);
            if (by < 50) {
                return true;
            }
        }
        this.tickCounter = 0;
        return false;
    }

    private void sleepBeforeNextSearch() {
        this.tickCounter = 1;
    }

    private boolean findDropOffLocation() {
        if (this.shouldSleep()) {
            return false;
        }
        AbstractAssemblyRobotBlockEntity.TargetDirections targetDirections = this.targetDirection = this.isImportUnit() ? this.getPlatformDirection() : this.getExportLocationForItem(this.itemHandler.getStackInSlot(0));
        if (this.targetDirection == null) {
            this.sleepBeforeNextSearch();
            return false;
        }
        return true;
    }

    private boolean getItemFromCurrentDirection() {
        AssemblyPlatformBlockEntity plat;
        BlockEntity tile = this.getTileEntityForCurrentDirection();
        if (tile == null) {
            return false;
        }
        boolean extracted = false;
        if (this.isImportUnit()) {
            if (this.searchedItemStack.m_41619_()) {
                this.reset();
            } else {
                extracted = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).map(sourceInv -> {
                    ItemStack heldStack = this.itemHandler.getStackInSlot(0);
                    int initialHeldAmount = heldStack.m_41613_();
                    boolean foundIt = false;
                    int needed = this.searchedItemStack.m_41613_() - heldStack.m_41613_();
                    for (int i = 0; i < sourceInv.getSlots() && !foundIt; ++i) {
                        ItemStack stack = sourceInv.getStackInSlot(i);
                        if (stack.m_41619_()) continue;
                        if (heldStack.m_41619_() && stack.m_41656_(this.searchedItemStack) || ItemHandlerHelper.canItemStacksStack((ItemStack)heldStack, (ItemStack)stack)) {
                            ItemStack takenStack = sourceInv.extractItem(i, needed, false);
                            ItemStack excess = this.itemHandler.insertItem(0, takenStack, false);
                            needed -= takenStack.m_41613_() - excess.m_41613_();
                            ItemHandlerHelper.insertItem((IItemHandler)sourceInv, (ItemStack)excess, (boolean)false);
                        }
                        foundIt = needed <= 0;
                    }
                    if (initialHeldAmount == this.itemHandler.getStackInSlot(0).m_41613_()) {
                        this.state = 1;
                    }
                    return foundIt;
                }).orElseGet(() -> {
                    this.state = 1;
                    return false;
                });
            }
        } else if (tile instanceof AssemblyPlatformBlockEntity && (plat = (AssemblyPlatformBlockEntity)tile).openClaw()) {
            this.itemHandler.setStackInSlot(0, plat.getHeldStack());
            plat.setHeldStack(ItemStack.f_41583_);
            boolean bl = extracted = !this.itemHandler.getStackInSlot(0).m_41619_();
            if (!extracted) {
                this.state = 1;
            }
        }
        return extracted;
    }

    private boolean putItemToCurrentDirection() {
        if (this.isImportUnit()) {
            BlockEntity tile = this.getTileEntityForCurrentDirection();
            if (tile instanceof AssemblyPlatformBlockEntity) {
                AssemblyPlatformBlockEntity plat = (AssemblyPlatformBlockEntity)tile;
                if (this.itemHandler.getStackInSlot(0).m_41619_()) {
                    return plat.closeClaw();
                }
                if (plat.isIdle()) {
                    plat.setHeldStack(this.itemHandler.getStackInSlot(0));
                    this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
                    return plat.closeClaw();
                }
            } else {
                this.repeatDropOffSearch();
            }
        } else {
            BlockEntity te = this.getTileEntityForCurrentDirection();
            if (te == null) {
                this.repeatDropOffSearch();
            } else {
                ItemStack currentStack = this.itemHandler.getStackInSlot(0);
                int startSize = currentStack.m_41613_();
                ItemStack excess = IOHelper.insert(te, currentStack, Direction.UP, false);
                this.itemHandler.setStackInSlot(0, excess);
                currentStack = this.itemHandler.getStackInSlot(0);
                if (!currentStack.m_41619_() && startSize == currentStack.m_41613_()) {
                    this.repeatDropOffSearch();
                }
            }
            return this.itemHandler.getStackInSlot(0).m_41619_();
        }
        return false;
    }

    private void repeatDropOffSearch() {
        this.state = (byte)(this.state >= 20 ? 20 : 5);
    }

    private boolean closeClaw() {
        this.shouldClawClose = true;
        return this.moveClaw();
    }

    private boolean openClaw() {
        this.shouldClawClose = false;
        return this.moveClaw();
    }

    private boolean moveClaw() {
        this.oldClawProgress = this.clawProgress;
        if (!this.shouldClawClose && this.clawProgress > 0.0f) {
            this.clawProgress = Math.max(this.clawProgress - 0.05f * this.speed, 0.0f);
        } else if (this.shouldClawClose && this.clawProgress < 1.0f) {
            this.clawProgress = Math.min(this.clawProgress + 0.05f * this.speed, 1.0f);
        }
        this.m_6596_();
        return this.isClawDone();
    }

    private boolean isClawDone() {
        return this.clawProgress == this.oldClawProgress && this.clawProgress == (this.shouldClawClose ? 1.0f : 0.0f);
    }

    public boolean isImportUnit() {
        return this.m_58900_().m_60734_() == ModBlocks.ASSEMBLY_IO_UNIT_IMPORT.get();
    }

    @Override
    public void gotoHomePosition() {
        super.gotoHomePosition();
        if (this.isClawDone()) {
            this.openClaw();
        }
    }

    @Override
    public boolean isIdle() {
        return this.state == 0;
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return this.isImportUnit() ? AssemblyProgram.EnumMachine.IO_UNIT_IMPORT : AssemblyProgram.EnumMachine.IO_UNIT_EXPORT;
    }

    private AbstractAssemblyRobotBlockEntity.TargetDirections getExportLocationForItem(ItemStack exportedItem) {
        if (!exportedItem.m_41619_()) {
            for (Direction dir : DirectionUtil.HORIZONTALS) {
                BlockEntity te = this.m_58904_().m_7702_(this.m_58899_().m_142300_(dir));
                int slot = AssemblyIOUnitBlockEntity.getPlacementSlot(exportedItem, te);
                if (slot < 0) continue;
                return new AbstractAssemblyRobotBlockEntity.TargetDirections(dir);
            }
            if (this.canMoveToDiagonalNeighbours()) {
                for (Direction secDir : new Direction[]{Direction.WEST, Direction.EAST}) {
                    for (Direction primDir : new Direction[]{Direction.NORTH, Direction.SOUTH}) {
                        BlockEntity te = this.m_58904_().m_7702_(this.m_58899_().m_142300_(primDir).m_142300_(secDir));
                        int slot = AssemblyIOUnitBlockEntity.getPlacementSlot(exportedItem, te);
                        if (slot < 0) continue;
                        return new AbstractAssemblyRobotBlockEntity.TargetDirections(primDir, secDir);
                    }
                }
            }
        }
        return null;
    }

    private static int getPlacementSlot(ItemStack exportedItem, BlockEntity te) {
        if (te == null || te instanceof AbstractAssemblyRobotBlockEntity) {
            return -1;
        }
        return te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).map(handler -> {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack excess = handler.insertItem(slot, exportedItem, true);
                if (excess.m_41613_() >= exportedItem.m_41613_()) continue;
                return slot;
            }
            return -1;
        }).orElse(-1);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.clawProgress = tag.m_128457_("clawProgress");
        this.shouldClawClose = tag.m_128471_("clawClosing");
        this.state = tag.m_128445_("state");
        this.itemHandler.deserializeNBT(tag.m_128469_("Items"));
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("clawProgress", this.clawProgress);
        tag.m_128379_("clawClosing", this.shouldClawClose);
        tag.m_128344_("state", this.state);
        tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
    }

    @Override
    public boolean canMoveToDiagonalNeighbours() {
        return true;
    }

    private static class ItemImportResult {
        final AbstractAssemblyRobotBlockEntity.TargetDirections targetDirs;
        final ItemStack stack;

        ItemImportResult(Direction targetDirs, ItemStack stack) {
            this(targetDirs, null, stack);
        }

        ItemImportResult(Direction primDir, Direction secDir, ItemStack stack) {
            this.targetDirs = new AbstractAssemblyRobotBlockEntity.TargetDirections(primDir, secDir);
            this.stack = stack;
        }
    }
}

