/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.block.entity.AbstractAirHandlingBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.block.entity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.RedstoneController;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import me.desht.pneumaticcraft.common.entity.projectile.MicromissileEntity;
import me.desht.pneumaticcraft.common.inventory.AirCannonMenu;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.util.EntityDistanceComparator;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.ItemLaunching;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class AirCannonBlockEntity
extends AbstractAirHandlingBlockEntity
implements IMinWorkingPressure,
IRedstoneControl<AirCannonBlockEntity>,
IGUIButtonSensitive,
MenuProvider {
    private static final String FP_NAME = "[Air Cannon]";
    private static final UUID FP_UUID = UUID.nameUUIDFromBytes("[Air Cannon]".getBytes());
    private static final List<RedstoneController.RedstoneMode<AirCannonBlockEntity>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.ReceivingRedstoneMode<AirCannonBlockEntity>("airCannon.highSignalAndAngle", Textures.GUI_HIGH_SIGNAL_ANGLE, te -> te.getCurrentRedstonePower() > 0 && te.doneTurning), new RedstoneController.ReceivingRedstoneMode<AirCannonBlockEntity>("standard.high_signal", new ItemStack((ItemLike)Items.f_41978_), te -> te.getCurrentRedstonePower() > 0), new RedstoneController.ReceivingRedstoneMode<AirCannonBlockEntity>("airCannon.highAndSpace", Textures.GUI_HIGH_SIGNAL_SPACE, te -> te.getCurrentRedstonePower() > 0 && te.inventoryCanCarry()));
    private final AirCannonStackHandler itemHandler = new AirCannonStackHandler(this);
    private final LazyOptional<IItemHandler> inventory = LazyOptional.of(() -> this.itemHandler);
    @DescSynced
    @LazySynced
    public float rotationAngle;
    @DescSynced
    @LazySynced
    public float heightAngle;
    @GuiSynced
    public int forceMult = 100;
    @DescSynced
    private float targetRotationAngle;
    @DescSynced
    private float targetHeightAngle;
    @GuiSynced
    public boolean doneTurning = false;
    @GuiSynced
    public int gpsX;
    @GuiSynced
    public int gpsY;
    @GuiSynced
    public int gpsZ;
    @GuiSynced
    public boolean coordWithinReach;
    @GuiSynced
    private final RedstoneController<AirCannonBlockEntity> rsController = new RedstoneController<AirCannonBlockEntity>(this, REDSTONE_MODES);
    private int oldRangeUpgrades;
    private boolean externalControl;
    private boolean entityUpgradeInserted;
    private boolean dispenserUpgradeInserted;
    private final List<ItemEntity> trackedItems = new ArrayList<ItemEntity>();
    private Set<UUID> trackedItemIds;
    private final Set<PrimedTnt> trackedTNT = new HashSet<PrimedTnt>();
    private BlockPos lastInsertingInventory;
    private Direction lastInsertingInventorySide;
    @GuiSynced
    public boolean insertingInventoryHasSpace = true;
    private boolean gpsSlotChanged = true;
    private FakePlayer fakePlayer = null;
    private static final int INVENTORY_SIZE = 2;
    private static final int CANNON_SLOT = 0;
    private static final int GPS_SLOT = 1;

    public AirCannonBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.AIR_CANNON.get(), pos, state, PressureTier.TIER_ONE, 2000, 4);
    }

    @Override
    public void tickCommonPre() {
        boolean isEntityTrackerUpgradeInserted;
        int curRangeUpgrades;
        super.tickCommonPre();
        boolean destUpdateNeeded = false;
        if (this.gpsSlotChanged) {
            destUpdateNeeded = this.checkGPSSlot();
            this.gpsSlotChanged = false;
        }
        if ((curRangeUpgrades = Math.min(8, this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.RANGE.get())))) != this.oldRangeUpgrades) {
            this.oldRangeUpgrades = curRangeUpgrades;
            if (!this.externalControl) {
                destUpdateNeeded = true;
            }
        }
        boolean isDispenserUpgradeInserted = this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.DISPENSER.get())) > 0;
        boolean bl = isEntityTrackerUpgradeInserted = this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.ENTITY_TRACKER.get())) > 0;
        if (this.dispenserUpgradeInserted != isDispenserUpgradeInserted || this.entityUpgradeInserted != isEntityTrackerUpgradeInserted) {
            this.dispenserUpgradeInserted = isDispenserUpgradeInserted;
            this.entityUpgradeInserted = isEntityTrackerUpgradeInserted;
            destUpdateNeeded = true;
        }
        if (destUpdateNeeded) {
            this.updateDestination();
        }
        this.updateRotationAngles();
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.updateTrackedItems();
        this.updateTrackedTNT();
        this.airHandler.setSideLeaking(this.hasNoConnectedAirHandlers() ? this.getRotation() : null);
    }

    private void updateTrackedTNT() {
        Iterator<PrimedTnt> iter = this.trackedTNT.iterator();
        while (iter.hasNext()) {
            PrimedTnt e = iter.next();
            if (!e.m_6084_()) {
                iter.remove();
                continue;
            }
            if (e.f_19797_ <= 5 || !(e.m_20184_().m_82556_() < 0.01)) continue;
            e.m_32085_(0);
        }
    }

    private boolean checkGPSSlot() {
        List<BlockPos> posList;
        ItemStack gpsStack = this.itemHandler.getStackInSlot(1);
        if (gpsStack.m_41720_() instanceof IPositionProvider && !this.externalControl && !(posList = ((IPositionProvider)gpsStack.m_41720_()).getStoredPositions(null, gpsStack)).isEmpty() && posList.get(0) != null) {
            int destinationX = posList.get(0).m_123341_();
            int destinationY = posList.get(0).m_123342_();
            int destinationZ = posList.get(0).m_123343_();
            if (destinationX != this.gpsX || destinationY != this.gpsY || destinationZ != this.gpsZ) {
                this.gpsX = destinationX;
                this.gpsY = destinationY;
                this.gpsZ = destinationZ;
                return true;
            }
        }
        return false;
    }

    private void updateRotationAngles() {
        this.doneTurning = true;
        float speedMultiplier = this.getSpeedMultiplierFromUpgrades();
        if (this.rotationAngle < this.targetRotationAngle) {
            this.rotationAngle = this.rotationAngle < this.targetRotationAngle - 20.0f ? (this.rotationAngle += 3.0f * speedMultiplier) : (this.rotationAngle += 0.5f * speedMultiplier);
            if (this.rotationAngle > this.targetRotationAngle) {
                this.rotationAngle = this.targetRotationAngle;
            }
            this.doneTurning = false;
        }
        if (this.rotationAngle > this.targetRotationAngle) {
            this.rotationAngle = this.rotationAngle > this.targetRotationAngle + 20.0f ? (this.rotationAngle -= 3.0f * speedMultiplier) : (this.rotationAngle -= 0.5f * speedMultiplier);
            if (this.rotationAngle < this.targetRotationAngle) {
                this.rotationAngle = this.targetRotationAngle;
            }
            this.doneTurning = false;
        }
        if (this.heightAngle < this.targetHeightAngle) {
            this.heightAngle = this.heightAngle < this.targetHeightAngle - 20.0f ? (this.heightAngle += 3.0f * speedMultiplier) : (this.heightAngle += 0.5f * speedMultiplier);
            if (this.heightAngle > this.targetHeightAngle) {
                this.heightAngle = this.targetHeightAngle;
            }
            this.doneTurning = false;
        }
        if (this.heightAngle > this.targetHeightAngle) {
            this.heightAngle = this.heightAngle > this.targetHeightAngle + 20.0f ? (this.heightAngle -= 3.0f * speedMultiplier) : (this.heightAngle -= 0.5f * speedMultiplier);
            if (this.heightAngle < this.targetHeightAngle) {
                this.heightAngle = this.targetHeightAngle;
            }
            this.doneTurning = false;
        }
    }

    private void updateTrackedItems() {
        Level level;
        if (this.trackedItemIds != null && (level = this.f_58857_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.trackedItems.clear();
            serverLevel.m_142646_().m_142690_(EntityTypeTest.m_156916_(ItemEntity.class), itemEntity -> {
                if (this.trackedItemIds.contains(itemEntity.m_142081_())) {
                    this.trackedItems.add((ItemEntity)itemEntity);
                }
            });
            this.trackedItemIds = null;
        }
        Iterator<ItemEntity> iterator = this.trackedItems.iterator();
        block0: while (iterator.hasNext()) {
            ItemEntity item = iterator.next();
            if (item.f_19853_ != this.m_58904_() || !item.m_6084_()) {
                iterator.remove();
                continue;
            }
            HashMap<BlockPos, Direction> positions = new HashMap<BlockPos, Direction>();
            double range = 0.2;
            for (Direction d : Direction.values()) {
                double posX = item.m_20185_() + (double)d.m_122429_() * range;
                double posY = item.m_20186_() + (double)d.m_122430_() * range;
                double posZ = item.m_20189_() + (double)d.m_122431_() * range;
                positions.put(new BlockPos((int)Math.floor(posX), (int)Math.floor(posY), (int)Math.floor(posZ)), d.m_122424_());
            }
            for (Map.Entry entry : positions.entrySet()) {
                boolean inserted;
                BlockPos pos = (BlockPos)entry.getKey();
                BlockEntity te = this.m_58904_().m_7702_(pos);
                if (te == null || !(inserted = IOHelper.getInventoryForTE(te, (Direction)entry.getValue()).map(inv -> {
                    ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)item.m_32055_(), (boolean)false);
                    if (!remainder.m_41619_()) {
                        item.m_32045_(remainder);
                        this.insertingInventoryHasSpace = false;
                        return false;
                    }
                    item.m_146870_();
                    iterator.remove();
                    this.lastInsertingInventory = te.m_58899_();
                    this.lastInsertingInventorySide = (Direction)entry.getValue();
                    this.nonNullLevel().m_5594_(null, te.m_58899_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return true;
                }).orElse(false).booleanValue())) continue;
                continue block0;
            }
        }
    }

    private void updateDestination() {
        float calculatedRotationAngle;
        this.doneTurning = false;
        double payloadFrictionY = 0.98;
        double payloadFrictionX = 0.98;
        double payloadGravity = 0.04;
        if (this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.ENTITY_TRACKER.get())) > 0) {
            payloadFrictionX = 0.91;
            payloadGravity = 0.08;
        } else if (this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.DISPENSER.get())) > 0 && !this.itemHandler.getStackInSlot(0).m_41619_()) {
            Item item = this.itemHandler.getStackInSlot(0).m_41720_();
            if (item == Items.f_42589_ || item == Items.f_42612_ || item == Items.f_42521_ || item == Items.f_42452_) {
                payloadFrictionY = 0.99;
                payloadGravity = 0.03;
            } else if (item == Items.f_42412_) {
                payloadFrictionY = 0.99;
                payloadGravity = 0.05;
            } else if (item == Items.f_42449_ || item == Items.f_42519_ || item == Items.f_42694_ || item == Items.f_42693_ || item == Items.f_42520_) {
                payloadFrictionY = 0.95;
            } else if (item == Items.f_42613_) {
                payloadGravity = 0.0;
            }
            if (item == Items.f_42589_) {
                payloadGravity = 0.05;
            } else if (item == Items.f_42612_) {
                payloadGravity = 0.07;
            }
            payloadFrictionX = payloadFrictionY;
            if (item instanceof BoatItem) {
                payloadFrictionX = 0.99;
                payloadFrictionY = 0.95;
            }
            if (item instanceof SpawnEggItem) {
                payloadFrictionY = 0.98;
                payloadFrictionX = 0.91;
                payloadGravity = 0.08;
            }
        }
        double deltaX = this.gpsX - this.m_58899_().m_123341_();
        double deltaZ = this.gpsZ - this.m_58899_().m_123343_();
        double angleXZ = Math.atan(Math.abs(deltaX / deltaZ)) / Math.PI * 180.0;
        if (deltaX >= 0.0 && deltaZ < 0.0) {
            calculatedRotationAngle = (float)angleXZ;
        } else {
            double angleZX = Math.atan(Math.abs(deltaZ / deltaX)) / Math.PI * 180.0;
            calculatedRotationAngle = deltaX >= 0.0 ? (float)angleZX + 90.0f : (deltaZ >= 0.0 ? (float)angleXZ + 180.0f : (float)angleZX + 270.0f);
        }
        double distance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        double deltaY = this.gpsY - this.m_58899_().m_123342_();
        float calculatedHeightAngle = this.calculateBestHeightAngle(distance, deltaY, this.getForce(), payloadGravity, payloadFrictionX, payloadFrictionY);
        this.setTargetAngles(calculatedRotationAngle, calculatedHeightAngle);
    }

    private float calculateBestHeightAngle(double distance, double deltaY, float force, double payloadGravity, double payloadFrictionX, double payloadFrictionY) {
        double bestAngle = 0.0;
        double bestDistance = 3.4028234663852886E38;
        if (payloadGravity == 0.0) {
            return 90.0f - (float)(Math.atan(deltaY / distance) * 180.0 / Math.PI);
        }
        for (double i = 0.031415926535897934; i < 1.5707963267948966; i += 0.01) {
            double motionX = Mth.m_14089_((float)((float)i)) * force;
            double posX = 0.0;
            double posY = 0.0;
            for (double motionY = (double)(Mth.m_14031_((float)((float)i)) * force); posY > deltaY || motionY > 0.0; motionY *= payloadFrictionY) {
                posX += motionX;
                posY += motionY;
                motionY -= payloadGravity;
                motionX *= payloadFrictionX;
            }
            double distanceToTarget = Math.abs(distance - posX);
            if (!(distanceToTarget < bestDistance)) continue;
            bestDistance = distanceToTarget;
            bestAngle = i;
        }
        this.coordWithinReach = bestDistance < 1.5;
        return 90.0f - (float)(bestAngle * 180.0 / Math.PI);
    }

    private synchronized void setTargetAngles(float rotationAngle, float heightAngle) {
        this.targetRotationAngle = rotationAngle;
        this.targetHeightAngle = heightAngle;
    }

    private double[] getVelocityVector(float angleX, float angleZ, float force) {
        double[] velocities = new double[]{Mth.m_14031_((float)(angleZ / 180.0f * (float)Math.PI)), Mth.m_14089_((float)(angleX / 180.0f * (float)Math.PI)), Mth.m_14089_((float)(angleZ / 180.0f * (float)Math.PI)) * -1.0f};
        velocities[0] = velocities[0] * (double)Mth.m_14031_((float)(angleX / 180.0f * (float)Math.PI));
        velocities[2] = velocities[2] * (double)Mth.m_14031_((float)(angleX / 180.0f * (float)Math.PI));
        double vectorTotal = velocities[0] * velocities[0] + velocities[1] * velocities[1] + velocities[2] * velocities[2];
        vectorTotal = (double)force / vectorTotal;
        int i = 0;
        while (i < 3) {
            int n = i++;
            velocities[n] = velocities[n] * vectorTotal;
        }
        return velocities;
    }

    public boolean hasCoordinate() {
        return this.gpsX != 0 || this.gpsY != 0 || this.gpsZ != 0;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return this.getRotation() == side;
    }

    public float getForce() {
        return (0.5f + (float)this.oldRangeUpgrades / 2.0f) * (float)this.forceMult / 100.0f;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.targetRotationAngle = tag.m_128457_("targetRotationAngle");
        this.targetHeightAngle = tag.m_128457_("targetHeightAngle");
        this.rotationAngle = tag.m_128457_("rotationAngle");
        this.heightAngle = tag.m_128457_("heightAngle");
        this.gpsX = tag.m_128451_("gpsX");
        this.gpsY = tag.m_128451_("gpsY");
        this.gpsZ = tag.m_128451_("gpsZ");
        this.coordWithinReach = tag.m_128471_("targetWithinReach");
        this.itemHandler.deserializeNBT(tag.m_128469_("Items"));
        this.forceMult = tag.m_128451_("forceMult");
        this.trackedItemIds = new HashSet<UUID>();
        ListTag tagList = tag.m_128437_("trackedItems", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag t = tagList.m_128728_(i);
            this.trackedItemIds.add(new UUID(t.m_128454_("UUIDMost"), t.m_128454_("UUIDLeast")));
        }
        if (tag.m_128441_("inventoryX")) {
            this.lastInsertingInventory = new BlockPos(tag.m_128451_("inventoryX"), tag.m_128451_("inventoryY"), tag.m_128451_("inventoryZ"));
            this.lastInsertingInventorySide = Direction.m_122376_((int)tag.m_128445_("inventorySide"));
        } else {
            this.lastInsertingInventory = null;
            this.lastInsertingInventorySide = null;
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("targetRotationAngle", this.targetRotationAngle);
        tag.m_128350_("targetHeightAngle", this.targetHeightAngle);
        tag.m_128350_("rotationAngle", this.rotationAngle);
        tag.m_128350_("heightAngle", this.heightAngle);
        tag.m_128405_("gpsX", this.gpsX);
        tag.m_128405_("gpsY", this.gpsY);
        tag.m_128405_("gpsZ", this.gpsZ);
        tag.m_128379_("targetWithinReach", this.coordWithinReach);
        tag.m_128365_("Items", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("forceMult", this.forceMult);
        ListTag tagList = new ListTag();
        for (ItemEntity entity : this.trackedItems) {
            UUID uuid = entity.m_142081_();
            CompoundTag t = new CompoundTag();
            t.m_128356_("UUIDMost", uuid.getMostSignificantBits());
            t.m_128356_("UUIDLeast", uuid.getLeastSignificantBits());
            tagList.add((Object)t);
        }
        tag.m_128365_("trackedItems", (Tag)tagList);
        if (this.lastInsertingInventory != null) {
            tag.m_128405_("inventoryX", this.lastInsertingInventory.m_123341_());
            tag.m_128405_("inventoryY", this.lastInsertingInventory.m_123342_());
            tag.m_128405_("inventoryZ", this.lastInsertingInventory.m_123343_());
            tag.m_128344_("inventorySide", (byte)this.lastInsertingInventorySide.m_122411_());
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new AirCannonMenu(i, playerInventory, this.m_58899_());
    }

    @Override
    public RedstoneController<AirCannonBlockEntity> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayer player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            if (this.rsController.getCurrentMode() == 2 && this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.BLOCK_TRACKER.get())) == 0) {
                this.rsController.setCurrentMode(0);
            }
            return;
        }
        int oldForceMult = this.forceMult;
        switch (tag) {
            case "--": {
                this.forceMult = Math.max(this.forceMult - 10, 0);
                break;
            }
            case "-": {
                this.forceMult = Math.max(this.forceMult - 1, 0);
                break;
            }
            case "+": {
                this.forceMult = Math.min(this.forceMult + 1, 100);
                break;
            }
            case "++": {
                this.forceMult = Math.min(this.forceMult + 10, 100);
            }
        }
        if (this.forceMult != oldForceMult) {
            this.updateDestination();
        }
    }

    @Override
    public void onNeighborBlockUpdate(BlockPos fromPos) {
        boolean isPowered;
        boolean wasPowered = this.rsController.getCurrentRedstonePower() > 0;
        super.onNeighborBlockUpdate(fromPos);
        boolean bl = isPowered = this.rsController.getCurrentRedstonePower() > 0;
        if (isPowered && !wasPowered && this.rsController.shouldRun()) {
            this.fire();
        }
    }

    private boolean inventoryCanCarry() {
        this.insertingInventoryHasSpace = true;
        if (this.lastInsertingInventory == null) {
            return true;
        }
        if (this.itemHandler.getStackInSlot(0).m_41619_()) {
            return true;
        }
        BlockEntity te = this.nonNullLevel().m_7702_(this.lastInsertingInventory);
        return IOHelper.getInventoryForTE(te, this.lastInsertingInventorySide).map(inv -> {
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)inv, (ItemStack)this.itemHandler.getStackInSlot(0).m_41777_(), (boolean)true);
            this.insertingInventoryHasSpace = remainder.m_41619_();
            return this.insertingInventoryHasSpace;
        }).orElseGet(() -> {
            this.lastInsertingInventory = null;
            this.lastInsertingInventorySide = null;
            return true;
        });
    }

    private synchronized boolean fire() {
        Entity launchedEntity = this.getCloseEntityIfUpgraded();
        if (this.getPressure() >= 2.0f && (launchedEntity != null || !this.itemHandler.getStackInSlot(0).m_41619_())) {
            float force = this.getForce();
            double[] velocity = this.getVelocityVector(this.heightAngle, this.rotationAngle, force);
            this.addAir((int)(-500.0f * force));
            boolean shootingInventory = false;
            if (launchedEntity == null) {
                shootingInventory = true;
                launchedEntity = this.getPayloadEntity();
                if (launchedEntity instanceof PrimedTnt) {
                    PrimedTnt tnt = (PrimedTnt)launchedEntity;
                    tnt.m_32085_(400);
                    this.trackedTNT.add(tnt);
                }
                if (launchedEntity instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)launchedEntity;
                    this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
                    if (this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.BLOCK_TRACKER.get())) > 0) {
                        this.trackedItems.add(itemEntity);
                    }
                    itemEntity.m_32010_(20);
                } else if (!(launchedEntity instanceof MicromissileEntity)) {
                    this.itemHandler.extractItem(0, 1, false);
                }
            } else if (launchedEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)launchedEntity;
                if (serverPlayer.f_8906_.m_6198_().m_129536_()) {
                    serverPlayer.f_8927_ = true;
                    serverPlayer.m_6021_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.8, (double)this.m_58899_().m_123343_() + 0.5);
                }
            }
            ItemLaunching.launchEntity(launchedEntity, new Vec3((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.8, (double)this.m_58899_().m_123343_() + 0.5), new Vec3(velocity[0], velocity[1], velocity[2]), shootingInventory);
            return true;
        }
        return false;
    }

    private Entity getPayloadEntity() {
        Entity e = ItemLaunching.getEntityToLaunch(this.m_58904_(), this.itemHandler.getStackInSlot(0), this.getFakePlayer(), this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.DISPENSER.get())) > 0, false);
        if (e instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)e;
            itemEntity.f_31985_ = 4800;
            itemEntity.lifespan += Math.min(this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.ITEM_LIFE.get())) * 600, 4800);
        }
        return e;
    }

    private Player getFakePlayer() {
        if (this.fakePlayer == null) {
            this.fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.m_58904_()), (GameProfile)new GameProfile(FP_UUID, FP_NAME));
            this.fakePlayer.m_6034_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5);
        }
        return this.fakePlayer;
    }

    private Entity getCloseEntityIfUpgraded() {
        List entities;
        int entityUpgrades = Math.min(5, this.getUpgrades((PNCUpgrade)((Object)ModUpgrades.ENTITY_TRACKER.get())));
        if (entityUpgrades > 0 && !(entities = this.nonNullLevel().m_45976_(LivingEntity.class, new AABB(this.m_58899_()).m_82400_((double)entityUpgrades))).isEmpty()) {
            entities.sort(new EntityDistanceComparator(this.m_58899_()));
            return (Entity)entities.get(0);
        }
        return null;
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        super.addLuaMethods(registry);
        registry.registerLuaMethod(new LuaMethod("setTargetLocation"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 3, "x, y, z");
                AirCannonBlockEntity.this.gpsX = ((Double)args[0]).intValue();
                AirCannonBlockEntity.this.gpsY = ((Double)args[1]).intValue();
                AirCannonBlockEntity.this.gpsZ = ((Double)args[2]).intValue();
                AirCannonBlockEntity.this.updateDestination();
                return new Object[]{AirCannonBlockEntity.this.coordWithinReach};
            }
        });
        registry.registerLuaMethod(new LuaMethod("fire"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{AirCannonBlockEntity.this.fire()};
            }
        });
        registry.registerLuaMethod(new LuaMethod("isDoneTurning"){

            @Override
            public Object[] call(Object[] args) {
                this.requireNoArgs(args);
                return new Object[]{AirCannonBlockEntity.this.doneTurning};
            }
        });
        registry.registerLuaMethod(new LuaMethod("setRotationAngle"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "angle (in degrees, 0 = north)");
                AirCannonBlockEntity.this.setTargetAngles(((Double)args[0]).floatValue(), AirCannonBlockEntity.this.targetHeightAngle);
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setHeightAngle"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "angle (in degrees, 0 = horizontal)");
                AirCannonBlockEntity.this.setTargetAngles(AirCannonBlockEntity.this.targetRotationAngle, 90.0f - ((Double)args[0]).floatValue());
                return null;
            }
        });
        registry.registerLuaMethod(new LuaMethod("setExternalControl"){

            @Override
            public Object[] call(Object[] args) {
                this.requireArgs(args, 1, "true/false");
                AirCannonBlockEntity.this.externalControl = (Boolean)args[0];
                return null;
            }
        });
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventory;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Override
    public float getMinWorkingPressure() {
        return 2.0f;
    }

    @Override
    public MutableComponent getRedstoneTabTitle() {
        return PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.redstoneBehaviour.airCannon.fireUpon", new Object[0]);
    }

    private class AirCannonStackHandler
    extends BaseItemStackHandler {
        AirCannonStackHandler(BlockEntity te) {
            super(te, 2);
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            if (slot == 1) {
                return itemStack.m_41619_() || itemStack.m_41720_() instanceof IPositionProvider;
            }
            return true;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (slot == 1) {
                AirCannonBlockEntity.this.gpsSlotChanged = true;
            }
        }
    }
}

