/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class DroneAIPlace<W extends ProgWidgetAreaItemBase>
extends DroneAIBlockInteraction<W> {
    public DroneAIPlace(IDroneBase drone, W widget) {
        super(drone, widget);
    }

    @Override
    protected boolean respectClaims() {
        return true;
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        if (this.drone.world().m_8055_(pos).m_60767_().m_76336_()) {
            if (Vec3.m_82512_((Vec3i)pos).m_82557_(this.drone.getDronePos()) < 1.2) {
                return false;
            }
            boolean failedOnPlacement = false;
            for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
                ItemStack droneStack = this.drone.getInv().getStackInSlot(i);
                if (!(droneStack.m_41720_() instanceof BlockItem) || !this.progWidget.isItemValidForFilters(droneStack)) continue;
                BlockPos placerPos = this.findClearSide(pos);
                if (placerPos == null) {
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.place.debug.noClearSides", pos);
                    failedOnPlacement = true;
                    break;
                }
                Block placingBlock = ((BlockItem)droneStack.m_41720_()).m_40614_();
                BlockState state = placingBlock.m_5573_(this.getPlacementContext(placerPos, pos, droneStack));
                if (state == null) {
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.place.debug.cantPlaceBlock", pos);
                    failedOnPlacement = true;
                    continue;
                }
                if (this.worldCache.m_5450_(null, state.m_60808_((BlockGetter)this.drone.world(), pos))) {
                    if (state.m_60710_((LevelReader)this.drone.world(), pos)) {
                        return true;
                    }
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.place.debug.cantPlaceBlock", pos);
                    failedOnPlacement = true;
                    continue;
                }
                this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.place.debug.entityInWay", pos);
                failedOnPlacement = true;
            }
            if (!failedOnPlacement) {
                this.abort();
            }
        }
        return false;
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        if (squareDistToBlock < 4.0) {
            for (int slot = 0; slot < this.drone.getInv().getSlots(); ++slot) {
                InteractionResult res;
                ItemStack droneStack = this.drone.getInv().getStackInSlot(slot);
                Item item = droneStack.m_41720_();
                if (!(item instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)item;
                if (!this.progWidget.isItemValidForFilters(droneStack) || !this.worldCache.m_8055_(pos).m_60767_().m_76336_()) continue;
                BlockPlaceContext ctx = this.getPlacementContext(pos, pos, droneStack);
                if (!this.progWidget.getCachedAreaSet().contains(ctx.m_8083_()) || !(res = blockItem.m_40576_(ctx)).m_19077_()) continue;
                this.drone.addAirToDrone(-100);
                if (slot == 0 && this.drone.getInv().getStackInSlot(slot).m_41619_()) {
                    this.drone.getInv().setStackInSlot(slot, ItemStack.f_41583_);
                }
                return false;
            }
            return false;
        }
        return true;
    }

    private BlockPos findClearSide(BlockPos pos) {
        for (Direction side : DirectionUtil.VALUES) {
            BlockPos pos2 = pos.m_142300_(side);
            if (!this.drone.world().m_8055_(pos.m_142300_(side)).m_60647_((BlockGetter)this.drone.world(), pos2, PathComputationType.AIR)) continue;
            return pos2;
        }
        return null;
    }

    private BlockPlaceContext getPlacementContext(BlockPos placerPos, BlockPos targetPos, ItemStack droneStack) {
        BlockHitResult brtr = this.drone.world().m_45547_(new ClipContext(Vec3.m_82512_((Vec3i)placerPos), Vec3.m_82512_((Vec3i)targetPos), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.drone.getFakePlayer()));
        return new BlockPlaceContext((UseOnContext)new DroneBlockItemUseContext((Player)this.drone.getFakePlayer(), droneStack, brtr));
    }

    private static class DroneBlockItemUseContext
    extends UseOnContext {
        protected DroneBlockItemUseContext(Player droneFakePlayer, ItemStack heldItem, BlockHitResult rayTraceResultIn) {
            super(droneFakePlayer.f_19853_, droneFakePlayer, InteractionHand.MAIN_HAND, heldItem, rayTraceResultIn);
        }
    }
}

