/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.List;
import me.desht.pneumaticcraft.common.ai.DroneAIBlockInteraction;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import me.desht.pneumaticcraft.common.progwidgets.IToolUser;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;

public class DroneAIDig<W extends ProgWidgetAreaItemBase>
extends DroneAIBlockInteraction<W> {
    public DroneAIDig(IDroneBase drone, W widget) {
        super(drone, widget);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        BlockState blockState = this.worldCache.m_8055_(pos);
        if (!DroneAIDig.ignoreBlock(blockState) && !pos.equals((Object)this.drone.getControllerPos())) {
            List<ItemStack> drops = DroneAIDig.getDrops((BlockGetter)this.worldCache, pos, this.drone);
            if (drops.isEmpty()) {
                return this.progWidget.isItemValidForFilters(ItemStack.f_41583_, blockState) && (this.swapBestItemToFirstSlot(pos) || !((IToolUser)((Object)this.progWidget)).requiresTool());
            }
            for (ItemStack droppedStack : drops) {
                if (!this.progWidget.isItemValidForFilters(droppedStack, blockState)) continue;
                return this.swapBestItemToFirstSlot(pos) || !((IToolUser)((Object)this.progWidget)).requiresTool();
            }
        }
        return false;
    }

    @Override
    protected boolean respectClaims() {
        return true;
    }

    private boolean swapBestItemToFirstSlot(BlockPos pos) {
        ItemStack currentStackSaved = this.drone.getInv().getStackInSlot(0).m_41777_();
        this.drone.getInv().setStackInSlot(0, ItemStack.f_41583_);
        float baseSoftness = this.worldCache.m_8055_(pos).m_60625_((Player)this.drone.getFakePlayer(), (BlockGetter)this.drone.world(), pos);
        this.drone.getInv().setStackInSlot(0, currentStackSaved);
        boolean hasDiggingTool = false;
        int bestSlot = 0;
        float bestSoftness = Float.MIN_VALUE;
        BlockState state = this.worldCache.m_8055_(pos);
        for (int i = 0; i < this.drone.getInv().getSlots(); ++i) {
            this.drone.getInv().setStackInSlot(0, this.drone.getInv().getStackInSlot(i));
            float softness = state.m_60625_((Player)this.drone.getFakePlayer(), (BlockGetter)this.drone.world(), pos);
            if (!(softness > bestSoftness)) continue;
            bestSlot = i;
            bestSoftness = softness;
            if (!(softness > baseSoftness)) continue;
            hasDiggingTool = true;
        }
        this.drone.getInv().setStackInSlot(0, currentStackSaved);
        if (bestSlot != 0) {
            ItemStack bestItem = this.drone.getInv().getStackInSlot(bestSlot).m_41777_();
            this.drone.getInv().setStackInSlot(bestSlot, this.drone.getInv().getStackInSlot(0));
            this.drone.getInv().setStackInSlot(0, bestItem);
        }
        return hasDiggingTool || !state.m_60834_();
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        ServerPlayerGameMode manager = this.drone.getFakePlayer().f_8941_;
        if (!manager.f_9249_ || !manager.f_9253_) {
            BlockState blockState = this.worldCache.m_8055_(pos);
            if (!DroneAIDig.ignoreBlock(blockState) && DroneAIDig.isBlockValidForFilter((BlockGetter)this.worldCache, pos, this.drone, this.progWidget)) {
                if (blockState.m_60800_((BlockGetter)this.drone.world(), pos) < 0.0f) {
                    this.addToBlacklist(pos);
                    this.drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.dig.debug.cantDigBlock", pos);
                    this.drone.setDugBlock(null);
                    return false;
                }
                PlayerInteractEvent.LeftClickBlock event = new PlayerInteractEvent.LeftClickBlock((Player)this.drone.getFakePlayer(), pos, Direction.UP);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (!event.isCanceled()) {
                    int limit = this.drone.world().m_151558_();
                    manager.m_7391_(pos, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, Direction.DOWN, limit);
                    manager.m_7391_(pos, ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, Direction.DOWN, limit);
                    this.drone.setDugBlock(pos);
                    return true;
                }
            }
            this.drone.setDugBlock(null);
            return false;
        }
        return true;
    }

    public static boolean isBlockValidForFilter(BlockGetter worldCache, BlockPos pos, IDroneBase drone, ProgWidgetAreaItemBase widget) {
        BlockState blockState = worldCache.m_8055_(pos);
        if (!blockState.m_60795_()) {
            for (ItemStack droppedStack : DroneAIDig.getDrops(worldCache, pos, drone)) {
                if (!widget.isItemValidForFilters(droppedStack, blockState)) continue;
                return true;
            }
            return widget.isItemValidForFilters(ItemStack.f_41583_, blockState);
        }
        return false;
    }

    private static List<ItemStack> getDrops(BlockGetter worldCache, BlockPos pos, IDroneBase drone) {
        BlockState state = worldCache.m_8055_(pos);
        DroneEntity d = drone instanceof DroneEntity ? (DroneEntity)drone : null;
        return state.m_60724_(new LootContext.Builder((ServerLevel)drone.world()).m_78972_(LootContextParams.f_81461_, (Object)state).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)drone.getInv().getStackInSlot(0)).m_78984_(LootContextParams.f_81455_, (Object)d).m_78984_(LootContextParams.f_81462_, (Object)worldCache.m_7702_(pos)));
    }

    private static boolean ignoreBlock(BlockState state) {
        return state.m_60767_() == Material.f_76296_ || PneumaticCraftUtils.isBlockLiquid(state.m_60734_());
    }
}

