/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common;

import java.util.Objects;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.misc.IMiscHelpers;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.common.XPFluidManager;
import me.desht.pneumaticcraft.common.block.entity.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.SmartChestBlockEntity;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketNotifyBlockUpdate;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.util.PlayerFilter;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.Validate;

public enum MiscAPIHandler implements IMiscHelpers
{
    INSTANCE;


    public static MiscAPIHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public int getProtectingSecurityStations(Player player, BlockPos pos) {
        Validate.isTrue((!player.m_20193_().f_46443_ ? 1 : 0) != 0, (String)"This method can only be called from the server side!", (Object[])new Object[0]);
        return SecurityStationBlockEntity.getProtectingSecurityStations(player, pos, false);
    }

    @Override
    public void registerXPFluid(FluidIngredient tag, int liquidToPointRatio) {
        XPFluidManager.getInstance().registerXPFluid(tag, liquidToPointRatio);
    }

    @Override
    public void syncGlobalVariable(ServerPlayer player, String varName) {
        BlockPos pos = GlobalVariableHelper.getPos(player.m_142081_(), varName);
        NetworkHandler.sendToPlayer(new PacketSetGlobalVariable(varName, pos), player);
    }

    @Override
    public void registerPlayerMatcher(ResourceLocation id, IPlayerMatcher.MatcherFactory<?> factory) {
        PlayerFilter.registerMatcher(id.toString(), factory);
    }

    @Override
    public IItemHandler deserializeSmartChest(CompoundTag tag) {
        return SmartChestBlockEntity.deserializeSmartChest(tag);
    }

    @Override
    public void forceClientShapeRecalculation(Level world, BlockPos pos) {
        if (!world.f_46443_) {
            NetworkHandler.sendToAllTracking(new PacketNotifyBlockUpdate(pos), world, pos);
        }
    }

    @Override
    public void playMachineBreakEffect(BlockEntity blockEntity) {
        Level level = Objects.requireNonNull(blockEntity.m_58904_());
        BlockPos pos = blockEntity.m_58899_();
        blockEntity.getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(handler -> {
            if (handler.getAir() > 0) {
                NetworkHandler.sendToAllTracking(new PacketSpawnParticle(AirParticleData.DENSE, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 0.0, 0.0, 0.0, (int)(5.0f * handler.getPressure()), 1.0, 1.0, 1.0), level, pos);
                level.m_5594_(null, pos, (SoundEvent)ModSounds.SHORT_HISS.get(), SoundSource.BLOCKS, 0.3f, 0.8f);
            }
        });
    }

    @Override
    public ParticleOptions airParticle() {
        return AirParticleData.DENSE;
    }
}

