/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pressure_gauge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;

public class PressureGaugeRenderer3D {
    private static final float RADIUS = 19.0f;
    private static final float PI_F = (float)Math.PI;
    private static final float START_ANGLE = 4.1887903f;
    private static final float STOP_ANGLE = -1.0471976f;
    private static final int CIRCLE_POINTS = 180;
    private static final int GAUGE_POINTS = 150;
    private static final float[][] GAUGE_SURROUND = new float[181][2];

    public static void drawPressureGauge(PoseStack matrixStack, MultiBufferSource buffer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos) {
        PressureGaugeRenderer3D.drawPressureGauge(matrixStack, buffer, minPressure, maxPressure, dangerPressure, minWorkingPressure, currentPressure, xPos, yPos, -16777216);
    }

    public static void drawPressureGauge(PoseStack matrixStack, MultiBufferSource buffer, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, float currentPressure, int xPos, int yPos, int fgColor) {
        Matrix3f normal = matrixStack.m_85850_().m_85864_();
        RenderUtils.renderWithType(matrixStack, buffer, ModRenderTypes.TRIANGLE_FAN, (posMat, builder) -> PressureGaugeRenderer3D.drawGaugeBackground(posMat, builder, minPressure, maxPressure, dangerPressure, minWorkingPressure, xPos, yPos));
        RenderUtils.renderWithType(matrixStack, buffer, (RenderType)RenderType.f_173152_, (posMat, builder) -> PressureGaugeRenderer3D.drawGaugeSurround(posMat, normal, builder, xPos, yPos, fgColor));
        int currentScale = (int)maxPressure;
        ArrayList<PressureGaugeRenderer2D.TextScaler> textScalers = new ArrayList<PressureGaugeRenderer2D.TextScaler>();
        RenderUtils.renderWithType(matrixStack, buffer, (RenderType)RenderType.f_110371_, (posMat, builder) -> PressureGaugeRenderer3D.drawScale(posMat, normal, builder, minPressure, maxPressure, xPos, yPos, currentScale, textScalers));
        RenderUtils.renderWithType(matrixStack, buffer, (RenderType)RenderType.f_173152_, (posMat, builder) -> {
            float angleIndicator = 150 - (int)((currentPressure - minPressure) / (maxPressure - minPressure) * 150.0f);
            angleIndicator = -angleIndicator / 180.0f * 2.0f * (float)Math.PI - -1.0471976f;
            PressureGaugeRenderer3D.drawNeedle(posMat, normal, builder, xPos, yPos, angleIndicator, fgColor);
        });
        PressureGaugeRenderer3D.drawText(matrixStack, buffer, xPos, yPos, fgColor, textScalers);
    }

    private static void drawGaugeBackground(Matrix4f posMat, VertexConsumer builder, float minPressure, float maxPressure, float dangerPressure, float minWorkingPressure, int xPos, int yPos) {
        float[] color = PressureGaugeRenderer2D.RED;
        builder.m_85982_(posMat, (float)xPos, (float)yPos, 0.0f).m_85950_(0.5f, 0.5f, 0.1f, 1.0f).m_5752_();
        int explodeBoundary = 150 - (int)((dangerPressure - minPressure) / (maxPressure - minPressure) * 150.0f);
        int workingBoundary = 150 - (int)((minWorkingPressure - minPressure) / (maxPressure - minPressure) * 150.0f);
        boolean changedColorGreen = false;
        boolean changedColorYellow = false;
        for (int i = 0; i < 150; ++i) {
            if (i == explodeBoundary && !changedColorGreen) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? PressureGaugeRenderer2D.YELLOW : PressureGaugeRenderer2D.GREEN;
                builder.m_85982_(posMat, (float)xPos, (float)yPos, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_5752_();
                --i;
                changedColorGreen = true;
            }
            if (i == workingBoundary && !changedColorYellow) {
                color = minWorkingPressure < 0.0f && minWorkingPressure >= -1.0f ? PressureGaugeRenderer2D.GREEN : PressureGaugeRenderer2D.YELLOW;
                builder.m_85982_(posMat, (float)xPos, (float)yPos, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_5752_();
                --i;
                changedColorYellow = true;
            }
            float angle = (float)(-i) / 180.0f * 2.0f * (float)Math.PI - -1.0471976f;
            builder.m_85982_(posMat, Mth.m_14089_((float)angle) * 19.0f + (float)xPos, Mth.m_14031_((float)angle) * 19.0f + (float)yPos, 0.0f).m_85950_(color[0], color[1], color[2], color[3]).m_5752_();
        }
    }

    private static void drawGaugeSurround(Matrix4f posMat, Matrix3f normal, VertexConsumer builder, int xPos, int yPos, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        for (int i = 0; i < 180; ++i) {
            RenderUtils.normalLine(builder, posMat, normal, GAUGE_SURROUND[i][0] + (float)xPos, GAUGE_SURROUND[i][1] + (float)yPos, 0.0f, GAUGE_SURROUND[i + 1][0] + (float)xPos, GAUGE_SURROUND[i + 1][1] + (float)yPos, 0.0f, cols[0], cols[1], cols[2], cols[3], true);
        }
    }

    private static void drawScale(Matrix4f posMat, Matrix3f normal, VertexConsumer builder, float minPressure, float maxPressure, int xPos, int yPos, int currentScale, List<PressureGaugeRenderer2D.TextScaler> textScalers) {
        for (int i = 0; i <= 150; ++i) {
            float angle = (float)(-i) / 180.0f * 2.0f * (float)Math.PI - -1.0471976f;
            if (i != 150 - (int)(((float)currentScale - minPressure) / (maxPressure - minPressure) * 150.0f)) continue;
            float x = Mth.m_14089_((float)angle);
            float y = Mth.m_14031_((float)angle);
            textScalers.add(new PressureGaugeRenderer2D.TextScaler(currentScale, (int)(x * 19.0f * 1.3f), (int)(y * 19.0f * 1.3f)));
            --currentScale;
            float r1 = maxPressure > 12.0f && textScalers.size() % 5 == 1 ? 0.8f : 0.92f;
            float r2 = maxPressure > 12.0f && textScalers.size() % 5 == 1 ? 1.15f : 1.08f;
            float x1 = x * 19.0f * r1 + (float)xPos;
            float y1 = y * 19.0f * r1 + (float)yPos;
            float x2 = x * 19.0f * r2 + (float)xPos;
            float y2 = y * 19.0f * r2 + (float)yPos;
            RenderUtils.normalLine(builder, posMat, normal, x1, y1, 0.0f, x2, y2, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, false);
        }
    }

    private static void drawNeedle(Matrix4f posMat, Matrix3f normal, VertexConsumer builder, int xPos, int yPos, float angle, int fgColor) {
        float[] cols = RenderUtils.decomposeColorF(fgColor);
        float x1 = Mth.m_14089_((float)(angle + 2.7960174f)) * 19.0f * 0.3f + (float)xPos;
        float y1 = Mth.m_14031_((float)(angle + 2.7960174f)) * 19.0f * 0.3f + (float)yPos;
        float x2 = Mth.m_14089_((float)(angle + 3.487168f)) * 19.0f * 0.3f + (float)xPos;
        float y2 = Mth.m_14031_((float)(angle + 3.487168f)) * 19.0f * 0.3f + (float)yPos;
        float x3 = Mth.m_14089_((float)angle) * 19.0f * 0.8f + (float)xPos;
        float y3 = Mth.m_14031_((float)angle) * 19.0f * 0.8f + (float)yPos;
        RenderUtils.normalLine(builder, posMat, normal, x1, y1, 0.0f, x2, y2, 0.0f, cols[0], cols[1], cols[2], cols[3], true);
        RenderUtils.normalLine(builder, posMat, normal, x2, y2, 0.0f, x3, y3, 0.0f, cols[0], cols[1], cols[2], cols[3], true);
        RenderUtils.normalLine(builder, posMat, normal, x3, y3, 0.0f, x1, y1, 0.0f, cols[0], cols[1], cols[2], cols[3], true);
        RenderUtils.normalLine(builder, posMat, normal, x1, y1, 0.0f, x2, y2, 0.0f, cols[0], cols[1], cols[2], cols[3], true);
    }

    private static void drawText(PoseStack matrixStack, MultiBufferSource buffer, int xPos, int yPos, int fgColor, List<PressureGaugeRenderer2D.TextScaler> textScalers) {
        for (int i = 0; i < textScalers.size(); ++i) {
            if (textScalers.size() > 14 && i % 5 != 0) continue;
            PressureGaugeRenderer2D.TextScaler scaler = textScalers.get(i);
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(xPos + scaler.x()) - 1.5, (double)(yPos + scaler.y()) - 1.5, 0.0);
            matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
            RenderUtils.renderString3d((Component)new TextComponent(Integer.toString(scaler.pressure())), 0.0f, 0.0f, fgColor, matrixStack, buffer, false, false);
            matrixStack.m_85849_();
        }
    }

    static {
        for (int i = 0; i <= 180; ++i) {
            float angle = (float)i / 180.0f * 2.0f * (float)Math.PI;
            PressureGaugeRenderer3D.GAUGE_SURROUND[i][0] = Mth.m_14089_((float)angle) * 19.0f;
            PressureGaugeRenderer3D.GAUGE_SURROUND[i][1] = Mth.m_14031_((float)angle) * 19.0f;
        }
    }
}

