/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.area;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.area.AreaRenderer;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.CoordTrackClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.DroneDebugClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.CamoApplicatorItem;
import me.desht.pneumaticcraft.common.item.GPSAreaToolItem;
import me.desht.pneumaticcraft.common.item.JackHammerItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.CoordTrackerHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public enum AreaRenderManager {
    INSTANCE;

    private static final int MAX_DISPLAYED_POS = 15000;
    private final Map<BlockPos, AreaRenderer> showHandlers = new HashMap<BlockPos, AreaRenderer>();
    private Level level;
    private DroneDebugClientHandler droneDebugger;
    private List<AreaRenderer> cachedPositionProviderShowers;
    private AreaRenderer camoPositionShower;
    private AreaRenderer jackhammerPositionShower;
    private LastJackhammerDetails lastJackhammerDetails = new LastJackhammerDetails(BlockPos.f_121853_, null, null);
    private BlockPos lastPlayerPos;
    private int lastItemHashCode = 0;

    public static AreaRenderManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void renderWorldLastEvent(RenderLevelLastEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        Player player = ClientUtils.getClientPlayer();
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        PoseStack matrixStack = event.getPoseStack();
        matrixStack.m_85836_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        matrixStack.m_85837_(-projectedView.f_82479_, -projectedView.f_82480_, -projectedView.f_82481_);
        for (AreaRenderer handler : this.showHandlers.values()) {
            handler.render(matrixStack, (MultiBufferSource)buffer);
        }
        this.maybeRenderPositionProvider(matrixStack, buffer, player);
        this.maybeRenderCamo(matrixStack, buffer, player);
        this.maybeRenderDroneDebug(matrixStack, buffer, player);
        this.maybeRenderAreaTool(matrixStack, buffer, player);
        this.maybeRenderJackhammer(matrixStack, buffer, player);
        this.maybeRenderCoordinateTracker(matrixStack, buffer, player, event.getPartialTick());
        matrixStack.m_85849_();
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            if (player.f_19853_ != this.level) {
                this.level = player.f_19853_;
                this.showHandlers.clear();
            } else if (event.phase == TickEvent.Phase.END) {
                this.showHandlers.keySet().removeIf(arg_0 -> this.lambda$tickEnd$0((Player)player, arg_0));
            }
        }
    }

    private void maybeRenderCoordinateTracker(PoseStack matrixStack, MultiBufferSource.BufferSource buffer, Player player, float partialTicks) {
        BlockPos pos;
        CoordTrackerHandler handler = CommonUpgradeHandlers.coordTrackerHandler;
        if (CommonArmorHandler.getHandlerForPlayer().upgradeUsable(handler, true) && (pos = ArmorUpgradeClientRegistry.getInstance().getClientHandler(handler, CoordTrackClientHandler.class).getTrackedPos()) != null) {
            float progress = ((float)(player.f_19853_.m_46467_() % 20L) + partialTicks) / 20.0f;
            float g = progress < 0.5f ? progress + 0.5f : 1.5f - progress;
            int col = 0xA00000FF | (int)(g * 255.0f) << 8;
            Vec3 targetVec = Vec3.m_82512_((Vec3i)pos);
            float size = ClientUtils.calculateViewScaling(targetVec);
            float textSize = size * 0.02f;
            AreaRenderer.builder().withColor(col).xray().withSize(size / 2.0f).build(pos).render(matrixStack, (MultiBufferSource)buffer);
            matrixStack.m_85836_();
            matrixStack.m_85837_(targetVec.m_7096_(), targetVec.m_7098_(), targetVec.m_7094_());
            matrixStack.m_85841_(textSize, textSize, textSize);
            RenderUtils.rotateToPlayerFacing(matrixStack);
            RenderUtils.renderString3d((Component)new TextComponent(PneumaticCraftUtils.posToString(pos)), 0.0f, 0.0f, -1, matrixStack, (MultiBufferSource)buffer, true, true);
            matrixStack.m_85849_();
        }
    }

    private void maybeRenderAreaTool(PoseStack matrixStack, MultiBufferSource.BufferSource buffer, Player player) {
        ItemStack curItem = this.getHeldPositionProvider(player);
        if (curItem.m_41720_() instanceof GPSAreaToolItem) {
            GPSAreaToolItem.getGPSLocation(player, curItem, 0).ifPresent(pos -> AreaRenderer.builder().withColor(-2130747296).xray().build((BlockPos)pos).render(matrixStack, (MultiBufferSource)buffer));
            GPSAreaToolItem.getGPSLocation(player, curItem, 1).ifPresent(pos -> AreaRenderer.builder().withColor(-2141126816).xray().build((BlockPos)pos).render(matrixStack, (MultiBufferSource)buffer));
        }
    }

    private void maybeRenderDroneDebug(PoseStack matrixStack, MultiBufferSource.BufferSource buffer, Player player) {
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        if (helmet.m_41720_() == ModItems.PNEUMATIC_HELMET.get()) {
            if (this.droneDebugger == null) {
                this.droneDebugger = ArmorUpgradeClientRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.droneDebugHandler, DroneDebugClientHandler.class);
            }
            Set<BlockPos> posSet = this.droneDebugger.getShowingPositions();
            Set<BlockPos> areaSet = this.droneDebugger.getShownArea();
            AreaRenderer.builder().withColor(-1862336512).xray().build(posSet).render(matrixStack, (MultiBufferSource)buffer);
            AreaRenderer.builder().withColor(1078001568).xray().build(areaSet).render(matrixStack, (MultiBufferSource)buffer);
        }
    }

    private ItemStack getHeldPositionProvider(Player player) {
        if (player.m_21205_().m_41720_() instanceof IPositionProvider) {
            return player.m_21205_();
        }
        if (player.m_21206_().m_41720_() instanceof IPositionProvider) {
            return player.m_21206_();
        }
        return ItemStack.f_41583_;
    }

    private void maybeRenderPositionProvider(PoseStack matrixStack, MultiBufferSource.BufferSource buffer, Player player) {
        ItemStack curItem = this.getHeldPositionProvider(player);
        Item item = curItem.m_41720_();
        if (item instanceof IPositionProvider) {
            IPositionProvider positionProvider = (IPositionProvider)item;
            if (curItem.m_41782_()) {
                int thisHash = Objects.requireNonNull(curItem.m_41783_()).hashCode();
                if (thisHash != this.lastItemHashCode) {
                    this.lastItemHashCode = thisHash;
                    List<BlockPos> posList = positionProvider.getStoredPositions(player.m_142081_(), curItem);
                    if (posList.size() > 15000) {
                        posList.sort(Comparator.comparingDouble(blockPos -> blockPos.m_123331_((Vec3i)player.m_142538_())));
                        player.m_5661_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.gps_tool.culledRenderArea", posList.size()).m_130940_(ChatFormatting.GOLD), false);
                    }
                    Int2ObjectOpenHashMap colorsToPositions = new Int2ObjectOpenHashMap();
                    int n = Math.min(posList.size(), 15000);
                    for (int i = 0; i < n; ++i) {
                        int renderColor = positionProvider.getRenderColor(i);
                        if (posList.get(i) == null || renderColor == 0) continue;
                        ((Set)colorsToPositions.computeIfAbsent(renderColor, k -> new HashSet())).add(posList.get(i));
                    }
                    this.cachedPositionProviderShowers = new ArrayList<AreaRenderer>(colorsToPositions.size());
                    colorsToPositions.int2ObjectEntrySet().forEach(entry -> {
                        AreaRenderer.Builder builder = AreaRenderer.builder().withColor(entry.getIntKey());
                        if (positionProvider.disableDepthTest()) {
                            builder.xray();
                        }
                        this.cachedPositionProviderShowers.add(builder.build((Set)entry.getValue()));
                    });
                }
                this.cachedPositionProviderShowers.forEach(renderer -> renderer.render(matrixStack, (MultiBufferSource)buffer));
            }
        }
    }

    private void maybeRenderCamo(PoseStack matrixStack, MultiBufferSource.BufferSource buffer, Player player) {
        if (!(player.m_21205_().m_41720_() instanceof CamoApplicatorItem)) {
            return;
        }
        if (this.lastPlayerPos == null || this.camoPositionShower == null || player.m_20275_((double)this.lastPlayerPos.m_123341_(), (double)this.lastPlayerPos.m_123342_(), (double)this.lastPlayerPos.m_123343_()) > 9.0) {
            this.lastPlayerPos = player.m_142538_();
            Set<BlockPos> s = this.getNearbyBlockEntities().stream().filter(te -> te instanceof CamouflageableBlockEntity && te.m_58899_().m_123331_((Vec3i)this.lastPlayerPos) < 144.0).map(BlockEntity::m_58899_).collect(Collectors.toSet());
            this.camoPositionShower = AreaRenderer.builder().withColor(1082163455).withSize(0.75f).xray().drawShapes().build(s);
        }
        if (this.camoPositionShower != null) {
            this.camoPositionShower.render(matrixStack, (MultiBufferSource)buffer);
        }
    }

    private Collection<BlockEntity> getNearbyBlockEntities() {
        ArrayList<BlockEntity> res = new ArrayList<BlockEntity>();
        BlockPos pos = ClientUtils.getClientPlayer().m_142538_();
        for (int x = pos.m_123341_() - 16; x <= pos.m_123341_() + 16; x += 16) {
            for (int z = pos.m_123343_() - 16; z <= pos.m_123343_() + 16; z += 16) {
                ChunkPos cp = new ChunkPos(pos);
                res.addAll(ClientUtils.getClientLevel().m_6325_(cp.f_45578_, cp.f_45579_).m_62954_().values());
            }
        }
        return res;
    }

    private void maybeRenderJackhammer(PoseStack matrixStack, MultiBufferSource.BufferSource buffer, Player player) {
        if (this.level == null || !(player.m_21205_().m_41720_() instanceof JackHammerItem) || !(Minecraft.m_91087_().f_91077_ instanceof BlockHitResult)) {
            return;
        }
        JackHammerItem.DigMode digMode = JackHammerItem.getDigMode(player.m_21205_());
        if (digMode == JackHammerItem.DigMode.MODE_1X1) {
            return;
        }
        BlockHitResult brtr = (BlockHitResult)Minecraft.m_91087_().f_91077_;
        if (!this.level.m_46749_(brtr.m_82425_()) || this.level.m_8055_(brtr.m_82425_()).m_60795_()) {
            return;
        }
        if (!this.lastJackhammerDetails.matches(brtr.m_82425_(), brtr.m_82434_(), digMode)) {
            Set<BlockPos> posSet;
            BlockState state = this.level.m_8055_(brtr.m_82425_());
            Set<BlockPos> set = posSet = this.level.m_7702_(brtr.m_82425_()) == null && !(state.m_60734_() instanceof LiquidBlock) ? JackHammerItem.getBreakPositions(this.level, brtr.m_82425_(), brtr.m_82434_(), player.m_6350_(), digMode) : Collections.emptySet();
            if (!posSet.isEmpty()) {
                posSet.add(brtr.m_82425_());
            }
            AreaRenderer.Builder b = AreaRenderer.builder().withColor(0x20FFFFFF).withSize(1.01f).disableWriteMask();
            if (state.m_60808_((BlockGetter)this.level, brtr.m_82425_()) != Shapes.m_83144_()) {
                b = b.drawShapes();
            }
            this.jackhammerPositionShower = b.build(posSet);
            this.lastJackhammerDetails = new LastJackhammerDetails(brtr.m_82425_(), brtr.m_82434_(), digMode);
        }
        this.jackhammerPositionShower.render(matrixStack, (MultiBufferSource)buffer);
    }

    public AreaRenderer showArea(BlockPos[] area, int color, BlockEntity areaShower) {
        return this.showArea(new HashSet<BlockPos>(Arrays.asList(area)), color, areaShower);
    }

    public AreaRenderer showArea(Set<BlockPos> area, int color, BlockEntity areaShower, boolean depth) {
        if (areaShower == null) {
            return null;
        }
        this.removeHandlers(areaShower);
        AreaRenderer.Builder builder = AreaRenderer.builder().withColor(color);
        if (depth) {
            builder.xray();
        }
        AreaRenderer handler = builder.build(area);
        this.showHandlers.put(new BlockPos(areaShower.m_58899_().m_123341_(), areaShower.m_58899_().m_123342_(), areaShower.m_58899_().m_123343_()), handler);
        return handler;
    }

    public AreaRenderer showArea(Set<BlockPos> area, int color, BlockEntity areaShower) {
        return this.showArea(area, color, areaShower, true);
    }

    public boolean isShowing(BlockEntity te) {
        return this.showHandlers.containsKey(new BlockPos(te.m_58899_().m_123341_(), te.m_58899_().m_123342_(), te.m_58899_().m_123343_()));
    }

    public void removeHandlers(BlockEntity te) {
        this.showHandlers.remove(new BlockPos(te.m_58899_().m_123341_(), te.m_58899_().m_123342_(), te.m_58899_().m_123343_()));
    }

    public void clearPosProviderCache() {
        this.lastItemHashCode = 0;
    }

    private /* synthetic */ boolean lambda$tickEnd$0(Player player, BlockPos pos) {
        return PneumaticCraftUtils.distBetweenSq(pos, player.m_142538_()) < 1024.0 && this.level.m_46859_(pos);
    }

    private record LastJackhammerDetails(BlockPos pos, Direction face, JackHammerItem.DigMode digMode) {
        private boolean matches(BlockPos pos, Direction face, JackHammerItem.DigMode digMode) {
            return face == this.face && digMode == this.digMode && pos.equals((Object)this.pos);
        }
    }
}

