/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import me.desht.pneumaticcraft.client.gui.widget.ICanRender3d;
import me.desht.pneumaticcraft.client.render.ModRenderTypes;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.Validate;

public class WidgetVerticalScrollbar
extends AbstractWidget
implements ICanRender3d {
    public float currentScroll;
    private int states;
    private boolean listening;
    private boolean dragging;

    public WidgetVerticalScrollbar(int x, int y, int height) {
        super(x, y, 14, height, TextComponent.f_131282_);
    }

    public WidgetVerticalScrollbar setStates(int states) {
        this.states = states;
        return this;
    }

    public WidgetVerticalScrollbar setCurrentState(int state) {
        Validate.isTrue((state >= 0 && state <= this.states ? 1 : 0) != 0, (String)("State " + state + " out of range! Valid range [1 - " + this.states + "] inclusive"), (Object[])new Object[0]);
        this.currentScroll = (float)state / (float)this.states;
        return this;
    }

    public boolean m_6050_(double x, double y, double dir) {
        if (this.f_93623_ && this.listening) {
            double wheel = Mth.m_14008_((double)(-dir), (double)-1.0, (double)1.0);
            this.currentScroll = Mth.m_14036_((float)(this.currentScroll + (float)wheel / (float)this.states), (float)0.0f, (float)1.0f);
            return true;
        }
        return false;
    }

    public void m_5716_(double x, double y) {
        this.currentScroll = (float)(y - 7.0 - (double)this.f_93621_) / (float)(this.f_93619_ - 17);
        this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
        this.dragging = true;
    }

    public void m_7691_(double x, double y) {
        this.dragging = false;
    }

    protected void m_7212_(double x, double y, double dx, double dy) {
        this.dragging = true;
        this.currentScroll = (float)(y - 7.0 - (double)this.f_93621_) / (float)(this.f_93619_ - 17);
        this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
    }

    public WidgetVerticalScrollbar setListening(boolean listening) {
        this.listening = listening;
        return this;
    }

    public int getState() {
        float scroll = this.currentScroll;
        return Mth.m_14045_((int)((int)((scroll += 0.5f / (float)this.states) * (float)this.states)), (int)0, (int)this.states);
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTick) {
        if (this.f_93624_) {
            GuiUtils.bindTexture(Textures.WIDGET_VERTICAL_SCROLLBAR);
            WidgetVerticalScrollbar.m_93133_((PoseStack)matrixStack, (int)this.f_93620_, (int)this.f_93621_, (float)12.0f, (float)0.0f, (int)this.f_93618_, (int)1, (int)26, (int)15);
            for (int i = 0; i < this.f_93619_ - 2; ++i) {
                WidgetVerticalScrollbar.m_93133_((PoseStack)matrixStack, (int)this.f_93620_, (int)(this.f_93621_ + 1 + i), (float)12.0f, (float)1.0f, (int)this.f_93618_, (int)1, (int)26, (int)15);
            }
            WidgetVerticalScrollbar.m_93133_((PoseStack)matrixStack, (int)this.f_93620_, (int)(this.f_93621_ + this.f_93619_ - 1), (float)12.0f, (float)14.0f, (int)this.f_93618_, (int)1, (int)26, (int)15);
            if (!this.f_93623_) {
                RenderSystem.m_157429_((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
            }
            WidgetVerticalScrollbar.m_93133_((PoseStack)matrixStack, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1 + (int)((float)(this.f_93619_ - 17) * this.currentScroll)), (float)0.0f, (float)0.0f, (int)12, (int)15, (int)26, (int)15);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void render3d(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
        if (this.f_93624_) {
            RenderUtils.renderWithTypeAndFinish(matrixStack, buffer, ModRenderTypes.getTextureRenderColored(Textures.WIDGET_VERTICAL_SCROLLBAR, true), (posMat, builder) -> {
                this.blit3d((VertexConsumer)builder, (Matrix4f)posMat, this.f_93620_, this.f_93621_, 12, 0, this.f_93618_, 1, 26, 15);
                for (int i = 0; i < this.f_93619_ - 2; ++i) {
                    this.blit3d((VertexConsumer)builder, (Matrix4f)posMat, this.f_93620_, this.f_93621_ + 1 + i, 12, 1, this.f_93618_, 1, 26, 15);
                }
                this.blit3d((VertexConsumer)builder, (Matrix4f)posMat, this.f_93620_, this.f_93621_ + this.f_93619_ - 1, 12, 14, this.f_93618_, 1, 26, 15);
                this.blit3d((VertexConsumer)builder, (Matrix4f)posMat, this.f_93620_ + 1, this.f_93621_ + 1 + (int)((float)(this.f_93619_ - 17) * this.currentScroll), 0, 0, 12, 15, 26, 15);
            });
        }
    }

    private void blit3d(VertexConsumer builder, Matrix4f posMat, int x, int y, int textureX, int textureY, int width, int height, int textureWidth, int textureHeight) {
        float u1 = (float)textureX / (float)textureWidth;
        float u2 = (float)(textureX + width) / (float)textureWidth;
        float v1 = (float)textureY / (float)textureHeight;
        float v2 = (float)(textureY + height) / (float)textureHeight;
        RenderUtils.posF(builder, posMat, x, y + height, 0.0).m_6122_(255, 255, 255, 255).m_7421_(u1, v2).m_85969_(0xF000F0).m_5752_();
        RenderUtils.posF(builder, posMat, x + width, y + height, 0.0).m_6122_(255, 255, 255, 255).m_7421_(u2, v2).m_85969_(0xF000F0).m_5752_();
        RenderUtils.posF(builder, posMat, x + width, y, 0.0).m_6122_(255, 255, 255, 255).m_7421_(u2, v1).m_85969_(0xF000F0).m_5752_();
        RenderUtils.posF(builder, posMat, x, y, 0.0).m_6122_(255, 255, 255, 255).m_7421_(u1, v1).m_85969_(0xF000F0).m_5752_();
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

