/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.widget;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.ICheckboxWidget;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.gui.widget.ITooltipProvider;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.pneumatic_armor.ArmorUpgradeClientRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.CoreComponentsClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorFeatureStatus;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeatureBulk;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.KeyBindingMap;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class WidgetKeybindCheckBox
extends WidgetCheckBox
implements ITooltipProvider {
    private static final Map<ResourceLocation, WidgetKeybindCheckBox> id2checkBox = new HashMap<ResourceLocation, WidgetKeybindCheckBox>();
    private static WidgetKeybindCheckBox coreComponents;
    private final ResourceLocation upgradeID;
    private ResourceLocation ownerUpgradeID = null;
    private boolean isListeningForBinding;
    private Component oldCheckboxText = this.m_6035_();

    private WidgetKeybindCheckBox(ResourceLocation upgradeID, int x, int y, int color, Consumer<ICheckboxWidget> pressable) {
        super(x, y, color, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.enableModule", PneumaticCraftUtils.xlate(IArmorUpgradeHandler.getStringKey(upgradeID), new Object[0])), pressable);
        this.upgradeID = upgradeID;
    }

    public static WidgetKeybindCheckBox getOrCreate(ResourceLocation upgradeID, int x, int y, int color, Consumer<ICheckboxWidget> pressable) {
        return id2checkBox.computeIfAbsent(upgradeID, id -> {
            WidgetKeybindCheckBox newCheckBox = new WidgetKeybindCheckBox((ResourceLocation)id, x, y, color, pressable);
            newCheckBox.checked = ArmorFeatureStatus.INSTANCE.isUpgradeEnabled((ResourceLocation)id);
            KeyMapping keyBinding = ArmorUpgradeClientRegistry.getInstance().getKeybindingForUpgrade((ResourceLocation)id);
            if (keyBinding != null) {
                KeyDispatcher.desc2checkbox.put(keyBinding.m_90860_(), newCheckBox);
            }
            if (id.equals((Object)CommonUpgradeHandlers.coreComponentsHandler.getID())) {
                coreComponents = newCheckBox;
            }
            return newCheckBox;
        });
    }

    public static WidgetKeybindCheckBox get(ResourceLocation upgradeID) {
        return id2checkBox.get(upgradeID);
    }

    public static WidgetKeybindCheckBox forUpgrade(IArmorUpgradeHandler<?> handler) {
        return WidgetKeybindCheckBox.get(handler.getID());
    }

    public static WidgetKeybindCheckBox forUpgrade(IArmorUpgradeClientHandler<?> handler) {
        return WidgetKeybindCheckBox.get(handler.getID());
    }

    public static WidgetKeybindCheckBox getCoreComponents() {
        return coreComponents;
    }

    @Override
    public ICheckboxWidget withOwnerUpgradeID(ResourceLocation ownerUpgradeID) {
        this.ownerUpgradeID = ownerUpgradeID;
        return this;
    }

    public static boolean isHandlerEnabled(IArmorUpgradeHandler<?> handler) {
        return WidgetKeybindCheckBox.forUpgrade(handler).checked;
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.m_93680_(x, y)) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            if (this.handleClick(x, y, button)) {
                return true;
            }
            if (this.isListeningForBinding) {
                InputConstants.Key input = InputConstants.Type.MOUSE.m_84895_(button);
                this.updateBinding(input);
                return true;
            }
        }
        return false;
    }

    private boolean handleClick(double mouseX, double mouseY, int button) {
        if (button == 0) {
            byte idx;
            EquipmentSlot slot;
            if (!WidgetKeybindCheckBox.coreComponents.checked && this != coreComponents) {
                Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)ModSounds.MINIGUN_STOP.get(), 1.0f, 2.0f);
                return true;
            }
            CommonArmorHandler commonArmorHandler = CommonArmorHandler.getHandlerForPlayer();
            IArmorUpgradeHandler<?> entry = ArmorUpgradeRegistry.getInstance().getUpgradeEntry(this.upgradeID);
            IArmorUpgradeHandler<?> ownerEntry = ArmorUpgradeRegistry.getInstance().getUpgradeEntry(this.ownerUpgradeID);
            if (!this.checked && (entry != null ? this != coreComponents && !commonArmorHandler.isArmorReady(entry.getEquipmentSlot()) : ownerEntry != null && !commonArmorHandler.isArmorReady(ownerEntry.getEquipmentSlot()))) {
                return true;
            }
            super.m_5716_(mouseX, mouseY);
            ArmorFeatureStatus.INSTANCE.setUpgradeEnabled(this.upgradeID, this.checked);
            ArmorFeatureStatus.INSTANCE.tryWriteToFile();
            if (entry != null && commonArmorHandler.isUpgradeInserted(slot = entry.getEquipmentSlot(), idx = (byte)entry.getIndex())) {
                this.toggleUpgrade(commonArmorHandler, slot, idx);
            }
            if (this == coreComponents) {
                this.toggleAllUpgrades(commonArmorHandler);
            }
            return true;
        }
        if (button == 1) {
            if (Screen.m_96638_()) {
                this.updateBinding(InputConstants.f_84822_);
            } else {
                boolean bl = this.isListeningForBinding = !this.isListeningForBinding;
                if (this.isListeningForBinding) {
                    this.oldCheckboxText = this.m_6035_();
                    this.m_93666_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.setKeybind", new Object[0]).m_130940_(ChatFormatting.YELLOW));
                } else {
                    this.m_93666_(this.oldCheckboxText);
                }
            }
            return true;
        }
        return false;
    }

    private void toggleUpgrade(CommonArmorHandler commonArmorHandler, EquipmentSlot slot, byte idx) {
        NetworkHandler.sendToServer(new PacketToggleArmorFeature(slot, idx, WidgetKeybindCheckBox.coreComponents.checked && this.checked));
        commonArmorHandler.setUpgradeEnabled(slot, idx, WidgetKeybindCheckBox.coreComponents.checked && this.checked);
        HUDHandler.getInstance().addFeatureToggleMessage(IArmorUpgradeHandler.getStringKey(this.upgradeID), this.checked);
    }

    private void toggleAllUpgrades(CommonArmorHandler commonArmorHandler) {
        ArrayList<PacketToggleArmorFeatureBulk.FeatureSetting> features = new ArrayList<PacketToggleArmorFeatureBulk.FeatureSetting>();
        ArmorUpgradeRegistry.getInstance().entries().forEach(entry -> {
            boolean state = WidgetKeybindCheckBox.coreComponents.checked && WidgetKeybindCheckBox.forUpgrade(entry).checked;
            byte idx = (byte)entry.getIndex();
            features.add(new PacketToggleArmorFeatureBulk.FeatureSetting(entry.getEquipmentSlot(), idx, state));
            commonArmorHandler.setUpgradeEnabled(entry.getEquipmentSlot(), idx, state);
        });
        NetworkHandler.sendToServer(new PacketToggleArmorFeatureBulk(features));
        if (this.checked) {
            ArmorUpgradeClientRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.coreComponentsHandler, CoreComponentsClientHandler.class).onResolutionChanged();
        } else {
            Minecraft.m_91087_().f_91074_.m_5496_((SoundEvent)ModSounds.MINIGUN_STOP.get(), 1.0f, 0.5f);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.isListeningForBinding) {
            InputConstants.Key input = InputConstants.Type.KEYSYM.m_84895_(keyCode);
            if (!KeyModifier.isKeyCodeModifier((InputConstants.Key)input)) {
                this.updateBinding(input);
            }
            return true;
        }
        return false;
    }

    @Override
    public void addTooltip(double mouseX, double mouseY, List<Component> curTooltip, boolean shiftPressed) {
        KeyMapping keyBinding = ArmorUpgradeClientRegistry.getInstance().getKeybindingForUpgrade(this.upgradeID);
        String k = IArmorUpgradeHandler.getStringKey(this.upgradeID) + ".desc";
        if (I18n.m_118936_((String)k)) {
            curTooltip.addAll(GuiUtils.xlateAndSplit(k, new Object[0]));
        }
        if (keyBinding != null) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindBoundKey", ClientUtils.translateKeyBind(keyBinding)).m_130940_(ChatFormatting.GOLD));
            if (!this.isListeningForBinding) {
                curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindRightClickToSet", new Object[0]).m_130940_(ChatFormatting.GRAY));
                if (keyBinding.getKey().m_84873_() != -1) {
                    curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.keybindShiftRightClickToClear", new Object[0]).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
    }

    private void updateBinding(InputConstants.Key input) {
        this.isListeningForBinding = false;
        KeyMapping keyBinding = ArmorUpgradeClientRegistry.getInstance().getKeybindingForUpgrade(this.upgradeID);
        if (keyBinding != null) {
            KeyModifier mod = input == InputConstants.f_84822_ ? KeyModifier.NONE : KeyModifier.getActiveModifier();
            keyBinding.setKeyModifierAndCode(mod, input);
            Minecraft.m_91087_().f_91066_.m_92159_(keyBinding, input);
            KeyMapping.m_90854_();
            Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_12211_, 1.0f, input == InputConstants.f_84822_ ? 0.5f : 1.0f);
        }
        this.m_93666_(this.oldCheckboxText);
    }

    @Override
    public ResourceLocation getUpgradeId() {
        return this.upgradeID;
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT})
    public static class KeyDispatcher {
        private static final Map<String, WidgetKeybindCheckBox> desc2checkbox = new HashMap<String, WidgetKeybindCheckBox>();
        private static final KeyBindingMap KEY_BINDING_MAP = new KeyBindingMap();

        @SubscribeEvent
        public static void onKeyPress(InputEvent.KeyInputEvent event) {
            KeyMapping binding;
            if (Minecraft.m_91087_().f_91080_ == null && event.getAction() == 1 && (binding = KEY_BINDING_MAP.lookupActive(InputConstants.Type.KEYSYM.m_84895_(event.getKey()))) != null) {
                KeyDispatcher.getBoundWidget(binding.m_90860_()).ifPresent(w -> w.handleClick(0.0, 0.0, 0));
            }
        }

        @SubscribeEvent
        public static void onMouseClick(InputEvent.MouseInputEvent event) {
            KeyMapping binding;
            if (Minecraft.m_91087_().f_91080_ == null && event.getAction() == 1 && (binding = KEY_BINDING_MAP.lookupActive(InputConstants.Type.MOUSE.m_84895_(event.getButton()))) != null) {
                KeyDispatcher.getBoundWidget(binding.m_90860_()).ifPresent(w -> w.handleClick(0.0, 0.0, 0));
            }
        }

        private static Optional<WidgetKeybindCheckBox> getBoundWidget(String key) {
            return Optional.ofNullable(desc2checkbox.get(key));
        }
    }
}

