/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.drone.ProgWidgetType;
import me.desht.pneumaticcraft.api.item.IPositionProvider;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.PastebinScreen;
import me.desht.pneumaticcraft.client.gui.ProgrammerWidgetAreaRenderer;
import me.desht.pneumaticcraft.client.gui.programmer.AbstractProgWidgetScreen;
import me.desht.pneumaticcraft.client.gui.programmer.ProgWidgetGuiManager;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetRadioButton;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextField;
import me.desht.pneumaticcraft.client.render.ProgWidgetRenderer;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModProgWidgets;
import me.desht.pneumaticcraft.common.inventory.ProgrammerMenu;
import me.desht.pneumaticcraft.common.item.GPSAreaToolItem;
import me.desht.pneumaticcraft.common.item.GPSToolItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.network.PacketProgrammerUpdate;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetArea;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinate;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetCoordinateOperator;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetStart;
import me.desht.pneumaticcraft.common.thirdparty.ThirdPartyManager;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ProgrammerScreen
extends AbstractPneumaticCraftContainerScreen<ProgrammerMenu, ProgrammerBlockEntity> {
    private PastebinScreen pastebinGui;
    private WidgetButtonExtended importButton;
    private WidgetButtonExtended exportButton;
    private WidgetButtonExtended allWidgetsButton;
    private WidgetCheckBox showInfo;
    private WidgetCheckBox showFlow;
    private WidgetTextField nameField;
    private WidgetTextField filterField;
    private WidgetButtonExtended undoButton;
    private WidgetButtonExtended redoButton;
    private WidgetButtonExtended convertToRelativeButton;
    private WidgetButtonExtended rotateCoordsButton;
    private final List<IProgWidget> visibleSpawnWidgets = new ArrayList<IProgWidget>();
    private final List<RemovingWidget> removingWidgets = new ArrayList<RemovingWidget>();
    private BitSet filteredSpawnWidgets;
    private ProgrammerWidgetAreaRenderer programmerUnit;
    private IProgWidget draggingWidget;
    private int lastMouseX;
    private int lastMouseY;
    private double dragMouseStartX;
    private double dragMouseStartY;
    private double dragWidgetStartX;
    private double dragWidgetStartY;
    private boolean draggingBG;
    private static final int FAULT_MARGIN = 4;
    private int widgetPage;
    private int maxPage;
    private boolean showingAllWidgets;
    private int showingWidgetProgress;
    private int oldShowingWidgetProgress;
    private static final Rect2i PROGRAMMER_STD_RES = new Rect2i(5, 17, 294, 154);
    private static final Rect2i PROGRAMMER_HI_RES = new Rect2i(5, 17, 644, 410);
    private static final int WIDGET_X_SPACING = 22;
    private final boolean hiRes;
    private IProgWidget.WidgetDifficulty programmerDifficulty;
    private static final Component TDR = new TextComponent("\u25e2");
    private static final Component TUL = new TextComponent("\u25e4");

    public ProgrammerScreen(ProgrammerMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.hiRes = container.isHiRes();
        this.f_97726_ = this.hiRes ? 700 : 350;
        this.f_97727_ = this.hiRes ? 512 : 256;
        this.programmerDifficulty = (IProgWidget.WidgetDifficulty)((Object)ConfigHelper.client().general.programmerDifficulty.get());
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        if (this.pastebinGui != null && this.pastebinGui.outputTag != null) {
            if (this.pastebinGui.shouldMerge) {
                List<IProgWidget> newWidgets = ((ProgrammerBlockEntity)this.te).mergeWidgetsFromNBT(this.pastebinGui.outputTag);
                ProgrammerBlockEntity.updatePuzzleConnections(newWidgets);
                ((ProgrammerBlockEntity)this.te).setProgWidgets(newWidgets, ClientUtils.getClientPlayer());
            } else {
                ((ProgrammerBlockEntity)this.te).readProgWidgetsFromNBT(this.pastebinGui.outputTag);
            }
            this.pastebinGui = null;
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((ProgrammerBlockEntity)this.te));
            ((ProgrammerBlockEntity)this.te).recentreStartPiece = true;
        }
        if (this.programmerUnit != null) {
            ((ProgrammerBlockEntity)this.te).translatedX = this.programmerUnit.getTranslatedX();
            ((ProgrammerBlockEntity)this.te).translatedY = this.programmerUnit.getTranslatedY();
            ((ProgrammerBlockEntity)this.te).zoomState = this.programmerUnit.getLastZoom();
        }
        Rect2i bounds = this.getProgrammerBounds();
        this.programmerUnit = new ProgrammerWidgetAreaRenderer((Screen)this, ((ProgrammerBlockEntity)this.te).progWidgets, this.f_97735_, this.f_97736_, bounds, ((ProgrammerBlockEntity)this.te).translatedX, ((ProgrammerBlockEntity)this.te).translatedY, ((ProgrammerBlockEntity)this.te).zoomState);
        this.m_142416_((GuiEventListener)this.programmerUnit.getScrollBar());
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        int xRight = this.getProgrammerBounds().m_110085_() + this.getProgrammerBounds().m_110090_();
        int yBottom = this.getProgrammerBounds().m_110086_() + this.getProgrammerBounds().m_110091_() + 3;
        this.importButton = new WidgetButtonExtended(xStart + xRight + 2, yStart + 3, 20, 15, "\u27f5").withTag("import").setTooltipKey("pneumaticcraft.gui.programmer.button.import", new Object[0]);
        this.m_142416_((GuiEventListener)this.importButton);
        this.exportButton = new WidgetButtonExtended(xStart + xRight + 2, yStart + 20, 20, 15, "\u27f6").withTag("export");
        this.m_142416_((GuiEventListener)this.exportButton);
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(xStart + xRight - 3, yStart + yBottom, 13, 10, "\u25c0", b -> this.adjustPage(-1)));
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(xStart + xRight + 34, yStart + yBottom, 13, 10, "\u25b6", b -> this.adjustPage(1)));
        this.allWidgetsButton = new WidgetButtonExtended(xStart + xRight + 22, yStart + yBottom - 16, 10, 10, "\u25e4", b -> this.toggleShowWidgets());
        this.allWidgetsButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.openPanel.tooltip", new Object[0]));
        this.m_142416_((GuiEventListener)this.allWidgetsButton);
        WidgetRadioButton.Builder<DifficultyButton> rbb = WidgetRadioButton.Builder.create();
        for (IProgWidget.WidgetDifficulty wd : IProgWidget.WidgetDifficulty.values()) {
            DifficultyButton dButton = new DifficultyButton(xStart + xRight - 36, yStart + yBottom + 29 + wd.ordinal() * 12, -12566464, wd, b -> this.updateDifficulty(wd));
            dButton.setTooltip((Component)PneumaticCraftUtils.xlate(wd.getTooltipTranslationKey(), new Object[0]));
            rbb.addRadioButton(dButton, wd == this.programmerDifficulty);
        }
        rbb.build(x$0 -> {
            DifficultyButton cfr_ignored_0 = (DifficultyButton)this.m_142416_((GuiEventListener)x$0);
        });
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(xStart + 5, yStart + yBottom + 4, 87, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.showStart", new Object[0]), b -> this.gotoStart()).setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.showStart.tooltip", new Object[0])));
        this.m_142416_((GuiEventListener)new WidgetButtonExtended(xStart + 5, yStart + yBottom + 26, 87, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.showLatest", new Object[0]), b -> this.gotoLatest()).setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.showLatest.tooltip", new Object[0])));
        this.showInfo = new WidgetCheckBox(xStart + 5, yStart + yBottom + 49, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.checkbox.showInfo", new Object[0])).setChecked(((ProgrammerBlockEntity)this.te).showInfo);
        this.m_142416_((GuiEventListener)this.showInfo);
        this.showFlow = new WidgetCheckBox(xStart + 5, yStart + yBottom + 61, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.checkbox.showFlow", new Object[0])).setChecked(((ProgrammerBlockEntity)this.te).showFlow);
        this.m_142416_((GuiEventListener)this.showFlow);
        WidgetButtonExtended pastebinButton = new WidgetButtonExtended(this.f_97735_ - 24, this.f_97736_ + 44, 20, 20, "", b -> this.pastebin());
        pastebinButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.remote.button.pastebinButton", new Object[0]));
        pastebinButton.setRenderedIcon(Textures.GUI_PASTEBIN_ICON_LOCATION);
        this.m_142416_((GuiEventListener)pastebinButton);
        this.undoButton = new WidgetButtonExtended(this.f_97735_ - 24, this.f_97736_ + 2, 20, 20, "").withTag("undo");
        this.redoButton = new WidgetButtonExtended(this.f_97735_ - 24, this.f_97736_ + 23, 20, 20, "").withTag("redo");
        WidgetButtonExtended clearAllButton = new WidgetButtonExtended(this.f_97735_ - 24, this.f_97736_ + 65, 20, 20, TextComponent.f_131282_, b -> this.clear());
        this.convertToRelativeButton = new WidgetButtonExtended(this.f_97735_ - 24, this.f_97736_ + 86, 20, 20, "R", b -> this.convertToRelative());
        this.rotateCoordsButton = new WidgetButtonExtended(this.f_97735_ - 24, this.f_97736_ + 107, 20, 20, "90", b -> this.rotateCoords90()).setTooltipText(GuiUtils.xlateAndSplit("pneumaticcraft.gui.programmer.button.rotate90button.tooltip", new Object[0]));
        this.undoButton.setRenderedIcon(Textures.GUI_UNDO_ICON_LOCATION);
        this.redoButton.setRenderedIcon(Textures.GUI_REDO_ICON_LOCATION);
        clearAllButton.setRenderedIcon(Textures.GUI_DELETE_ICON_LOCATION);
        this.undoButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.undoButton.tooltip", new Object[0]));
        this.redoButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.redoButton.tooltip", new Object[0]));
        clearAllButton.setTooltipText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.clearAllButton.tooltip", new Object[0]));
        this.m_142416_((GuiEventListener)this.undoButton);
        this.m_142416_((GuiEventListener)this.redoButton);
        this.m_142416_((GuiEventListener)clearAllButton);
        this.m_142416_((GuiEventListener)this.convertToRelativeButton);
        this.m_142416_((GuiEventListener)this.rotateCoordsButton);
        this.addLabel(this.f_96539_, this.f_97735_ + 7, this.f_97736_ + 5, -12566464);
        Objects.requireNonNull(this.f_96547_);
        this.nameField = new WidgetTextField(this.f_96547_, this.f_97735_ + xRight - 99, this.f_97736_ + 5, 98, 9);
        this.nameField.m_94151_(s -> this.updateDroneName());
        this.m_142416_((GuiEventListener)this.nameField);
        Objects.requireNonNull(this.f_96547_);
        this.filterField = new FilterTextField(this.f_96547_, this.f_97735_ + 78, this.f_97736_ + 26, 100, 9);
        this.filterField.m_94151_(s -> this.filterSpawnWidgets());
        this.m_142416_((GuiEventListener)this.filterField);
        TranslatableComponent name = PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.name", new Object[0]);
        this.addLabel((Component)name, this.f_97735_ + xRight - 102 - this.f_96547_.m_92852_((FormattedText)name), this.f_97736_ + 5, -12566464);
        this.updateVisibleProgWidgets();
        for (IProgWidget widget : ((ProgrammerBlockEntity)this.te).progWidgets) {
            if (this.programmerUnit.isOutsideProgrammingArea(widget)) continue;
            return;
        }
        this.programmerUnit.gotoPiece(ProgrammerScreen.findWidget(((ProgrammerBlockEntity)this.te).progWidgets, ProgWidgetStart.class));
    }

    public boolean m_7043_() {
        return (Boolean)ConfigHelper.client().general.programmerGuiPauses.get();
    }

    public static void onCloseFromContainer() {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ProgrammerScreen) {
            ProgrammerScreen p = (ProgrammerScreen)screen;
            p.m_7861_();
        }
    }

    public Rect2i getProgrammerBounds() {
        return this.hiRes ? PROGRAMMER_HI_RES : PROGRAMMER_STD_RES;
    }

    private int getWidgetTrayRight() {
        return this.hiRes ? 672 : 322;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return this.hiRes ? Textures.GUI_PROGRAMMER_LARGE : Textures.GUI_PROGRAMMER_STD;
    }

    private void updateVisibleProgWidgets() {
        this.updateVisibleProgWidgets(this.programmerDifficulty);
    }

    private void updateVisibleProgWidgets(IProgWidget.WidgetDifficulty difficulty) {
        int y = 0;
        int page = 0;
        int x = this.getWidgetTrayRight() - this.maxPage * 22;
        boolean showAllWidgets = this.showingWidgetProgress == 22 * this.maxPage && this.showingAllWidgets;
        this.filterField.m_94194_(showAllWidgets);
        this.maxPage = 0;
        this.visibleSpawnWidgets.clear();
        int idx = 0;
        int nWidgets = ModProgWidgets.PROG_WIDGETS.get().getValues().size();
        for (ProgWidgetType type : ModProgWidgets.PROG_WIDGETS.get().getValues()) {
            IProgWidget widget = IProgWidget.create(type);
            if (widget.isAvailable() && widget.isDifficultyOK(difficulty)) {
                widget.setY(y + 40);
                widget.setX(showAllWidgets ? x : this.getWidgetTrayRight());
                int widgetHeight = widget.getHeight() / 2 + (widget.hasStepOutput() ? 5 : 0) + 1;
                y += widgetHeight;
                if (showAllWidgets || page == this.widgetPage) {
                    this.visibleSpawnWidgets.add(widget);
                }
                if (y > this.f_97727_ - (this.hiRes ? 260 : 160)) {
                    y = 0;
                    x += 22;
                    ++page;
                    if (idx < nWidgets - 1) {
                        ++this.maxPage;
                    }
                }
            }
            ++idx;
        }
        ++this.maxPage;
        this.filterField.f_93620_ = Math.min(this.f_97735_ + this.getWidgetTrayRight() - 25 - this.filterField.m_5711_(), this.f_97735_ + this.getWidgetTrayRight() - this.maxPage * 22 - 2);
        this.filterSpawnWidgets();
        if (this.widgetPage >= this.maxPage) {
            this.widgetPage = this.maxPage - 1;
            this.updateVisibleProgWidgets();
        }
    }

    private void filterSpawnWidgets() {
        String filterText = this.filterField.m_94155_().trim();
        if (!this.visibleSpawnWidgets.isEmpty() && !filterText.isEmpty()) {
            this.filteredSpawnWidgets = new BitSet(this.visibleSpawnWidgets.size());
            for (int i = 0; i < this.visibleSpawnWidgets.size(); ++i) {
                IProgWidget widget = this.visibleSpawnWidgets.get(i);
                String widgetName = I18n.m_118938_((String)widget.getTranslationKey(), (Object[])new Object[0]);
                this.filteredSpawnWidgets.set(i, widgetName.toLowerCase().contains(filterText.toLowerCase()));
            }
        } else {
            this.filteredSpawnWidgets = null;
        }
    }

    @Override
    protected boolean shouldAddInfoTab() {
        return false;
    }

    private void updateDroneName() {
        ItemStack stack = ((ProgrammerBlockEntity)this.te).getItemInProgrammingSlot();
        if (stack != ItemStack.f_41583_ && !stack.m_41786_().m_6111_().equals(this.nameField.m_94155_())) {
            stack.m_41714_((Component)new TextComponent(this.nameField.m_94155_()));
            this.sendDelayed(5);
        }
    }

    @Override
    protected void doDelayedAction() {
        NetworkHandler.sendToServer(new PacketUpdateTextfield(this.te, 0));
    }

    private void adjustPage(int dir) {
        this.widgetPage += dir;
        if (this.widgetPage < 0) {
            this.widgetPage = this.maxPage - 1;
        } else if (this.widgetPage >= this.maxPage) {
            this.widgetPage = 0;
        }
        this.updateVisibleProgWidgets();
    }

    private void toggleShowWidgets() {
        this.showingAllWidgets = !this.showingAllWidgets;
        this.allWidgetsButton.m_93666_(this.showingAllWidgets ? TDR : TUL);
        this.updateVisibleProgWidgets();
        this.filterField.m_94178_(this.showingAllWidgets);
    }

    private void updateDifficulty(IProgWidget.WidgetDifficulty difficulty) {
        this.programmerDifficulty = difficulty;
        ConfigHelper.setProgrammerDifficulty(difficulty);
        if (this.showingAllWidgets) {
            this.toggleShowWidgets();
        }
        this.updateVisibleProgWidgets(difficulty);
    }

    private void gotoLatest() {
        if (((ProgrammerBlockEntity)this.te).progWidgets.size() > 0) {
            this.programmerUnit.gotoPiece(((ProgrammerBlockEntity)this.te).progWidgets.get(((ProgrammerBlockEntity)this.te).progWidgets.size() - 1));
        }
    }

    private void gotoStart() {
        this.programmerUnit.gotoPiece(ProgrammerScreen.findWidget(((ProgrammerBlockEntity)this.te).progWidgets, ProgWidgetStart.class));
    }

    private void pastebin() {
        CompoundTag mainTag = ((ProgrammerBlockEntity)this.te).writeProgWidgetsToNBT(new CompoundTag());
        this.pastebinGui = new PastebinScreen((Screen)this, mainTag);
        this.f_96541_.m_91152_((Screen)this.pastebinGui);
    }

    private void clear() {
        ((ProgrammerBlockEntity)this.te).progWidgets.forEach(w -> this.removingWidgets.add(new RemovingWidget((IProgWidget)w)));
        ((ProgrammerBlockEntity)this.te).progWidgets.clear();
        NetworkHandler.sendToServer(new PacketProgrammerUpdate((ProgrammerBlockEntity)this.te));
    }

    private void convertToRelative() {
        for (IProgWidget widget : ((ProgrammerBlockEntity)this.te).progWidgets) {
            if (!(widget instanceof ProgWidgetStart)) continue;
            this.generateRelativeOperators((ProgWidgetCoordinateOperator)widget.getOutputWidget(), null, false);
            break;
        }
    }

    @Override
    protected PointXY getInvNameOffset() {
        return null;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        super.m_7027_(matrixStack, x, y);
        int xRight = this.getProgrammerBounds().m_110085_() + this.getProgrammerBounds().m_110090_();
        int yBottom = this.getProgrammerBounds().m_110086_() + this.getProgrammerBounds().m_110091_();
        String str = this.widgetPage + 1 + "/" + this.maxPage;
        this.f_96547_.m_92883_(matrixStack, str, (float)(xRight + 22) - (float)this.f_96547_.m_92895_(str) / 2.0f, (float)(yBottom + 4), 0x404040);
        this.f_96547_.m_92877_(matrixStack, PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.difficulty", new Object[0]).m_7532_(), (float)(xRight - 36), (float)(yBottom + 20), 0x404040);
        if (this.showingWidgetProgress == 0) {
            this.programmerUnit.renderForeground(matrixStack, x, y, this.draggingWidget, this.f_96547_);
        }
        for (int i = 0; i < this.visibleSpawnWidgets.size(); ++i) {
            IProgWidget widget = this.visibleSpawnWidgets.get(i);
            if (widget == this.draggingWidget || x - this.f_97735_ < widget.getX() || y - this.f_97736_ < widget.getY() || x - this.f_97735_ > widget.getX() + widget.getWidth() / 2 || y - this.f_97736_ > widget.getY() + widget.getHeight() / 2 || this.showingAllWidgets && this.filteredSpawnWidgets != null && !this.filteredSpawnWidgets.get(i)) continue;
            ArrayList<Component> tooltip = new ArrayList<Component>();
            widget.getTooltip(tooltip);
            ThirdPartyManager.instance().getDocsProvider().addTooltip(tooltip, this.showingAllWidgets);
            if (Minecraft.m_91087_().f_91066_.f_92125_) {
                tooltip.add((Component)new TextComponent(widget.getType().getRegistryName().toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
            if (tooltip.isEmpty()) continue;
            this.renderComponentTooltip(matrixStack, tooltip, x - this.f_97735_, y - this.f_97736_, this.f_96547_);
        }
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.m_7333_(matrixStack);
        this.bindGuiTexture();
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        ProgrammerScreen.m_93133_((PoseStack)matrixStack, (int)xStart, (int)yStart, (float)0.0f, (float)0.0f, (int)this.f_97726_, (int)this.f_97727_, (int)this.f_97726_, (int)this.f_97727_);
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.programmerUnit.render(matrixStack, mouseX, mouseY, this.showFlow.checked, this.showInfo.checked && this.showingWidgetProgress == 0);
        if (this.showingWidgetProgress > 0) {
            int xRight = this.getProgrammerBounds().m_110085_() + this.getProgrammerBounds().m_110090_();
            int yBottom = this.getProgrammerBounds().m_110086_() + this.getProgrammerBounds().m_110091_();
            this.bindGuiTexture();
            int width = (int)Mth.m_14179_((float)partialTicks, (float)this.oldShowingWidgetProgress, (float)this.showingWidgetProgress);
            for (int i = 0; i < width; ++i) {
                ProgrammerScreen.m_93133_((PoseStack)matrixStack, (int)(xStart + xRight + 21 - i), (int)(yStart + 36), (float)(xRight + 24), (float)36.0f, (int)1, (int)(yBottom - 35), (int)this.f_97726_, (int)this.f_97727_);
            }
            ProgrammerScreen.m_93133_((PoseStack)matrixStack, (int)(xStart + xRight + 20 - width), (int)(yStart + 36), (float)(xRight + 20), (float)36.0f, (int)2, (int)(yBottom - 35), (int)this.f_97726_, (int)this.f_97727_);
            if (this.showingAllWidgets && this.draggingWidget != null) {
                this.toggleShowWidgets();
            }
        }
        RenderSystem.m_69493_();
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        for (int i = 0; i < this.visibleSpawnWidgets.size(); ++i) {
            IProgWidget widget = this.visibleSpawnWidgets.get(i);
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(widget.getX() + this.f_97735_), (double)(widget.getY() + this.f_97736_), 0.0);
            matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
            if (this.showingAllWidgets && this.filteredSpawnWidgets != null && !this.filteredSpawnWidgets.get(i)) {
                ProgWidgetRenderer.renderProgWidget2d(matrixStack, widget, 48);
            } else {
                ProgWidgetRenderer.renderProgWidget2d(matrixStack, widget);
            }
            matrixStack.m_85849_();
        }
        float scale = this.programmerUnit.getScale();
        matrixStack.m_85836_();
        matrixStack.m_85837_(this.programmerUnit.getTranslatedX(), this.programmerUnit.getTranslatedY(), 0.0);
        matrixStack.m_85841_(scale, scale, 1.0f);
        if (this.draggingWidget != null) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(this.draggingWidget.getX() + this.f_97735_), (double)(this.draggingWidget.getY() + this.f_97736_), 0.0);
            matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
            ProgWidgetRenderer.renderProgWidget2d(matrixStack, this.draggingWidget);
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
        RenderSystem.m_69461_();
        if (!this.removingWidgets.isEmpty()) {
            this.drawRemovingWidgets(matrixStack);
        }
    }

    private void drawRemovingWidgets(PoseStack matrixStack) {
        Iterator<RemovingWidget> iter = this.removingWidgets.iterator();
        int h = this.f_96541_.m_91268_().m_85446_();
        float scale = this.programmerUnit.getScale();
        matrixStack.m_85836_();
        matrixStack.m_85837_(this.programmerUnit.getTranslatedX(), this.programmerUnit.getTranslatedY(), 0.0);
        matrixStack.m_85841_(scale, scale, 1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        while (iter.hasNext()) {
            RemovingWidget rw = iter.next();
            IProgWidget w = rw.widget;
            if ((double)w.getY() + rw.ty > (double)((float)h / scale)) {
                iter.remove();
                continue;
            }
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)w.getX() + rw.tx + (double)this.f_97735_, (double)w.getY() + rw.ty + (double)this.f_97736_, 0.0);
            matrixStack.m_85841_(0.5f, 0.5f, 1.0f);
            ProgWidgetRenderer.renderProgWidget2d(matrixStack, w);
            matrixStack.m_85849_();
            rw.tick();
        }
        RenderSystem.m_69461_();
        matrixStack.m_85849_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        if (this.nameField.m_93696_()) {
            return this.nameField.m_7933_(keyCode, scanCode, modifiers);
        }
        if (this.filterField.m_93696_() && keyCode != 258) {
            return this.filterField.m_7933_(keyCode, scanCode, modifiers);
        }
        switch (keyCode) {
            case 73: {
                return this.showWidgetDocs();
            }
            case 82: {
                if (this.exportButton.m_198029_()) {
                    NetworkHandler.sendToServer(new PacketGuiButton("program_when"));
                }
                return true;
            }
            case 258: {
                this.toggleShowWidgets();
                return true;
            }
            case 261: {
                if (ClientUtils.hasShiftDown()) {
                    this.clear();
                } else {
                    IProgWidget widget = this.programmerUnit.getHoveredWidget(this.lastMouseX, this.lastMouseY);
                    if (widget != null) {
                        this.removingWidgets.add(new RemovingWidget(widget));
                        ((ProgrammerBlockEntity)this.te).progWidgets.remove(widget);
                        NetworkHandler.sendToServer(new PacketProgrammerUpdate((ProgrammerBlockEntity)this.te));
                    }
                }
                return true;
            }
            case 90: {
                NetworkHandler.sendToServer(new PacketGuiButton("undo"));
                return true;
            }
            case 89: {
                NetworkHandler.sendToServer(new PacketGuiButton("redo"));
                return true;
            }
            case 268: {
                this.gotoStart();
                break;
            }
            case 269: {
                this.gotoLatest();
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private boolean showWidgetDocs() {
        int x = this.lastMouseX;
        int y = this.lastMouseY;
        IProgWidget hoveredWidget = this.programmerUnit.getHoveredWidget(x, y);
        if (hoveredWidget != null) {
            ThirdPartyManager.instance().getDocsProvider().showWidgetDocs(this.getWidgetId(hoveredWidget));
            return true;
        }
        for (IProgWidget widget : this.visibleSpawnWidgets) {
            if (widget == this.draggingWidget || x - this.f_97735_ < widget.getX() || y - this.f_97736_ < widget.getY() || x - this.f_97735_ > widget.getX() + widget.getWidth() / 2 || y - this.f_97736_ > widget.getY() + widget.getHeight() / 2) continue;
            ThirdPartyManager.instance().getDocsProvider().showWidgetDocs(this.getWidgetId(widget));
            return true;
        }
        return false;
    }

    private String getWidgetId(IProgWidget w) {
        return w == null ? null : w.getTypeID().m_135815_();
    }

    @Override
    protected boolean shouldDrawBackground() {
        return false;
    }

    private boolean isValidPlaced(IProgWidget widget1) {
        IProgWidget iProgWidget;
        Rect2i draggingRect = new Rect2i(widget1.getX(), widget1.getY(), widget1.getWidth() / 2, widget1.getHeight() / 2);
        for (IProgWidget iProgWidget2 : ((ProgrammerBlockEntity)this.te).progWidgets) {
            if (iProgWidget2 == widget1 || !ClientUtils.intersects(draggingRect, iProgWidget2.getX(), iProgWidget2.getY(), (double)iProgWidget2.getWidth() / 2.0, (double)iProgWidget2.getHeight() / 2.0)) continue;
            return false;
        }
        IProgWidget[] parameters = widget1.getConnectedParameters();
        if (parameters != null) {
            for (IProgWidget widget : parameters) {
                if (widget == null || this.isValidPlaced(widget)) continue;
                return false;
            }
        }
        return (iProgWidget = widget1.getOutputWidget()) == null || this.isValidPlaced(iProgWidget);
    }

    private void handlePuzzleMargins() {
        List<ProgWidgetType<?>> parameters;
        ProgWidgetType<?> returnValue = this.draggingWidget.returnType();
        if (returnValue != null) {
            for (IProgWidget widget : ((ProgrammerBlockEntity)this.te).progWidgets) {
                if (widget == this.draggingWidget || Math.abs(widget.getX() + widget.getWidth() / 2 - this.draggingWidget.getX()) > 4) continue;
                List<ProgWidgetType<?>> parameters2 = widget.getParameters();
                for (int i = 0; i < parameters2.size(); ++i) {
                    if (!widget.canSetParameter(i) || parameters2.get(i) != returnValue || Math.abs(widget.getY() + i * 11 - this.draggingWidget.getY()) > 4) continue;
                    this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() + widget.getWidth() / 2, widget.getY() + i * 11);
                    return;
                }
            }
        }
        if (!(parameters = this.draggingWidget.getParameters()).isEmpty()) {
            for (IProgWidget widget : ((ProgrammerBlockEntity)this.te).progWidgets) {
                IProgWidget outerPiece = this.draggingWidget;
                if (outerPiece.returnType() != null) {
                    while (outerPiece.getConnectedParameters()[0] != null) {
                        outerPiece = outerPiece.getConnectedParameters()[0];
                    }
                }
                if (widget == this.draggingWidget || Math.abs(outerPiece.getX() + outerPiece.getWidth() / 2 - widget.getX()) > 4) continue;
                if (widget.returnType() != null) {
                    for (int i = 0; i < parameters.size(); ++i) {
                        if (!this.draggingWidget.canSetParameter(i) || parameters.get(i) != widget.returnType() || Math.abs(this.draggingWidget.getY() + i * 11 - widget.getY()) > 4) continue;
                        this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() - this.draggingWidget.getWidth() / 2 - (outerPiece.getX() - this.draggingWidget.getX()), widget.getY() - i * 11);
                    }
                    continue;
                }
                List<ProgWidgetType<?>> checkingPieceParms = widget.getParameters();
                for (int i = 0; i < checkingPieceParms.size(); ++i) {
                    if (!widget.canSetParameter(i + parameters.size()) || checkingPieceParms.get(i) != parameters.get(0) || Math.abs(widget.getY() + i * 11 - this.draggingWidget.getY()) > 4) continue;
                    this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX() - this.draggingWidget.getWidth() / 2 - (outerPiece.getX() - this.draggingWidget.getX()), widget.getY() + i * 11);
                }
            }
        }
        if (this.draggingWidget.hasStepInput()) {
            for (IProgWidget widget : ((ProgrammerBlockEntity)this.te).progWidgets) {
                if (!widget.hasStepOutput() || Math.abs(widget.getX() - this.draggingWidget.getX()) > 4 || Math.abs(widget.getY() + widget.getHeight() / 2 - this.draggingWidget.getY()) > 4) continue;
                this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX(), widget.getY() + widget.getHeight() / 2);
            }
        }
        if (this.draggingWidget.hasStepOutput()) {
            for (IProgWidget widget : ((ProgrammerBlockEntity)this.te).progWidgets) {
                if (!widget.hasStepInput() || Math.abs(widget.getX() - this.draggingWidget.getX()) > 4 || Math.abs(widget.getY() - this.draggingWidget.getY() - this.draggingWidget.getHeight() / 2) > 4) continue;
                this.setConnectingWidgetsToXY(this.draggingWidget, widget.getX(), widget.getY() - this.draggingWidget.getHeight() / 2);
            }
        }
    }

    private void setConnectingWidgetsToXY(IProgWidget widget, int x, int y) {
        IProgWidget outputWidget;
        widget.setX(x);
        widget.setY(y);
        IProgWidget[] connectingWidgets = widget.getConnectedParameters();
        if (connectingWidgets != null) {
            for (int i = 0; i < connectingWidgets.length; ++i) {
                if (connectingWidgets[i] == null) continue;
                if (i < connectingWidgets.length / 2) {
                    this.setConnectingWidgetsToXY(connectingWidgets[i], x + widget.getWidth() / 2, y + i * 11);
                    continue;
                }
                int totalWidth = 0;
                IProgWidget branch = connectingWidgets[i];
                while (branch != null) {
                    totalWidth += branch.getWidth() / 2;
                    branch = branch.getConnectedParameters()[0];
                }
                this.setConnectingWidgetsToXY(connectingWidgets[i], x - totalWidth, y + (i - connectingWidgets.length / 2) * 11);
            }
        }
        if ((outputWidget = widget.getOutputWidget()) != null) {
            this.setConnectingWidgetsToXY(outputWidget, x, y + widget.getHeight() / 2);
        }
    }

    private void copyAndConnectConnectingWidgets(IProgWidget original, IProgWidget copy) {
        IProgWidget outputWidget;
        IProgWidget c;
        IProgWidget[] connectingWidgets = original.getConnectedParameters();
        if (connectingWidgets != null) {
            for (int i = 0; i < connectingWidgets.length; ++i) {
                if (connectingWidgets[i] == null) continue;
                c = connectingWidgets[i].copy();
                ((ProgrammerBlockEntity)this.te).progWidgets.add(c);
                copy.setParameter(i, c);
                this.copyAndConnectConnectingWidgets(connectingWidgets[i], c);
            }
        }
        if ((outputWidget = original.getOutputWidget()) != null) {
            c = outputWidget.copy();
            ((ProgrammerBlockEntity)this.te).progWidgets.add(c);
            copy.setOutputWidget(c);
            this.copyAndConnectConnectingWidgets(outputWidget, c);
        }
    }

    private void deleteConnectingWidgets(IProgWidget widget) {
        IProgWidget outputWidget;
        ((ProgrammerBlockEntity)this.te).progWidgets.remove(widget);
        this.removingWidgets.add(new RemovingWidget(widget));
        IProgWidget[] connectingWidgets = widget.getConnectedParameters();
        if (connectingWidgets != null) {
            for (IProgWidget widg : connectingWidgets) {
                if (widg == null) continue;
                this.deleteConnectingWidgets(widg);
            }
        }
        if ((outputWidget = widget.getOutputWidget()) != null) {
            this.deleteConnectingWidgets(outputWidget);
        }
    }

    @Override
    public void m_181908_() {
        ItemStack programmedItem;
        boolean isDeviceInserted;
        super.m_181908_();
        this.programmerUnit.tick();
        if (((ProgrammerBlockEntity)this.te).recentreStartPiece) {
            this.programmerUnit.gotoPiece(ProgrammerScreen.findWidget(((ProgrammerBlockEntity)this.te).progWidgets, ProgWidgetStart.class));
            ((ProgrammerBlockEntity)this.te).recentreStartPiece = false;
        }
        boolean bl = this.programmerUnit.getScrollBar().f_93624_ = this.showingWidgetProgress == 0;
        if (this.showingWidgetProgress > 0) {
            this.programmerUnit.getScrollBar().setCurrentState(this.programmerUnit.getLastZoom());
        }
        this.undoButton.f_93623_ = ((ProgrammerBlockEntity)this.te).canUndo;
        this.redoButton.f_93623_ = ((ProgrammerBlockEntity)this.te).canRedo;
        this.updateConvertRelativeState();
        this.oldShowingWidgetProgress = this.showingWidgetProgress;
        int maxProgress = this.maxPage * 22;
        if (this.showingAllWidgets) {
            if (this.showingWidgetProgress < maxProgress) {
                this.showingWidgetProgress += maxProgress / 5;
                if (this.showingWidgetProgress >= maxProgress) {
                    this.showingWidgetProgress = maxProgress;
                    this.updateVisibleProgWidgets();
                }
            } else {
                this.m_7522_((GuiEventListener)this.filterField);
            }
        } else {
            this.showingWidgetProgress -= maxProgress / 5;
            if (this.showingWidgetProgress < 0) {
                this.showingWidgetProgress = 0;
            }
        }
        this.importButton.f_93623_ = isDeviceInserted = !(programmedItem = ((ProgrammerBlockEntity)this.te).getItemInProgrammingSlot()).m_41619_();
        this.exportButton.f_93623_ = isDeviceInserted && this.programmerUnit.getTotalErrors() == 0;
        this.updateExportButtonTooltip(programmedItem);
        if (!programmedItem.m_41619_()) {
            this.nameField.m_94186_(true);
            if (!this.nameField.m_94155_().equals(programmedItem.m_41786_().m_6111_())) {
                this.nameField.m_94144_(programmedItem.m_41786_().getString());
            }
        } else {
            this.nameField.m_94186_(false);
            this.nameField.m_94144_("");
        }
    }

    private void updateExportButtonTooltip(ItemStack programmedItem) {
        ArrayList<Component> exportButtonTooltip = new ArrayList<Component>();
        exportButtonTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.export", new Object[0]));
        exportButtonTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.export.programmingWhen", PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.export." + (((ProgrammerBlockEntity)this.te).programOnInsert ? "onItemInsert" : "pressingButton"), new Object[0])).m_130940_(ChatFormatting.AQUA));
        exportButtonTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.export.pressRToChange", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        if (!programmedItem.m_41619_()) {
            int required = ((ProgrammerBlockEntity)this.te).getRequiredPuzzleCount();
            if (required != 0) {
                exportButtonTooltip.add(TextComponent.f_131282_);
            }
            int effectiveRequired = ClientUtils.getClientPlayer().m_7500_() ? 0 : required;
            int available = ((ProgrammerBlockEntity)this.te).availablePuzzlePieces + this.countPlayerPuzzlePieces();
            boolean bl = this.exportButton.f_93623_ = this.exportButton.f_93623_ && effectiveRequired <= available;
            if (required > 0) {
                exportButtonTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.programmable.requiredPieces", effectiveRequired).m_130940_(ChatFormatting.YELLOW));
                exportButtonTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.programmable.availablePieces", available).m_130940_(ChatFormatting.YELLOW));
            } else if (required < 0) {
                exportButtonTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.programmable.returnedPieces", -effectiveRequired).m_130940_(ChatFormatting.GREEN));
            }
            if (required != 0 && ClientUtils.getClientPlayer().m_7500_()) {
                exportButtonTooltip.add((Component)new TextComponent("(Creative mode)").m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
            if (effectiveRequired > available) {
                exportButtonTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.programmable.notEnoughPieces", new Object[0]).m_130940_(ChatFormatting.RED));
            }
        } else {
            exportButtonTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.export.noProgrammableItem", new Object[0]).m_130940_(ChatFormatting.GOLD));
        }
        if (this.programmerUnit.getTotalErrors() > 0) {
            exportButtonTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.errorCount", this.programmerUnit.getTotalErrors()).m_130940_(ChatFormatting.RED));
        }
        if (this.programmerUnit.getTotalWarnings() > 0) {
            exportButtonTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.warningCount", this.programmerUnit.getTotalWarnings()).m_130940_(ChatFormatting.YELLOW));
        }
        this.exportButton.setTooltipText(exportButtonTooltip);
    }

    private int countPlayerPuzzlePieces() {
        int count = 0;
        for (ItemStack stack : ClientUtils.getClientPlayer().m_150109_().f_35974_) {
            if (stack.m_41720_() != ModItems.PROGRAMMING_PUZZLE.get()) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    private void updateConvertRelativeState() {
        ArrayList<Component> tooltip;
        block8: {
            this.convertToRelativeButton.f_93624_ = this.programmerDifficulty == IProgWidget.WidgetDifficulty.ADVANCED;
            boolean bl = this.rotateCoordsButton.f_93624_ = this.programmerDifficulty == IProgWidget.WidgetDifficulty.ADVANCED;
            if (this.programmerDifficulty != IProgWidget.WidgetDifficulty.ADVANCED) {
                return;
            }
            this.convertToRelativeButton.f_93623_ = false;
            this.rotateCoordsButton.f_93623_ = false;
            tooltip = new ArrayList<Component>();
            tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.desc", new Object[0]));
            IProgWidget startWidget = ProgrammerScreen.findWidget(((ProgrammerBlockEntity)this.te).progWidgets, ProgWidgetStart.class);
            if (startWidget == null) {
                tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.noStartPiece", new Object[0]).m_130940_(ChatFormatting.RED));
                return;
            }
            IProgWidget widget = startWidget.getOutputWidget();
            if (widget instanceof ProgWidgetCoordinateOperator) {
                ProgWidgetCoordinateOperator operatorWidget = (ProgWidgetCoordinateOperator)widget;
                if (operatorWidget.getVariable().isEmpty()) {
                    tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.noVariableName", new Object[0]).m_130940_(ChatFormatting.RED));
                    return;
                }
                try {
                    this.rotateCoordsButton.f_93623_ = true;
                    if (this.generateRelativeOperators(operatorWidget, tooltip, true)) {
                        this.convertToRelativeButton.f_93623_ = true;
                        break block8;
                    }
                    tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.notEnoughRoom", new Object[0]).m_130940_(ChatFormatting.RED));
                }
                catch (NullPointerException e) {
                    tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.cantHaveVariables", new Object[0]).m_130940_(ChatFormatting.RED));
                }
            } else {
                tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.noBaseCoordinate", new Object[0]).m_130940_(ChatFormatting.RED));
            }
        }
        this.convertToRelativeButton.setTooltipText(tooltip);
    }

    private boolean generateRelativeOperators(ProgWidgetCoordinateOperator baseWidget, List<Component> tooltip, boolean simulate) {
        BlockPos baseCoord = ProgWidgetCoordinateOperator.calculateCoordinate(baseWidget, 0, baseWidget.getOperator());
        HashMap<BlockPos, String> offsetToVariableNames = new HashMap<BlockPos, String>();
        for (IProgWidget widget : ((ProgrammerBlockEntity)this.te).progWidgets) {
            if (widget instanceof ProgWidgetArea) {
                ProgWidgetArea area = (ProgWidgetArea)widget;
                if (area.getVarName(0).isEmpty()) {
                    area.getPos(0).ifPresent(pos -> {
                        BlockPos offset = pos.m_141950_((Vec3i)baseCoord);
                        String var = this.makeOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
                        if (!simulate) {
                            area.setVarName(0, var);
                        }
                    });
                }
                if (!area.getVarName(1).isEmpty()) continue;
                area.getPos(1).ifPresent(pos -> {
                    BlockPos offset = pos.m_141950_((Vec3i)baseCoord);
                    String var = this.makeOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
                    if (!simulate) {
                        area.setVarName(1, var);
                    }
                });
                continue;
            }
            if (!(widget instanceof ProgWidgetCoordinate)) continue;
            ProgWidgetCoordinate coordinate = (ProgWidgetCoordinate)widget;
            if (baseWidget.getConnectedParameters()[0] == widget || coordinate.isUsingVariable()) continue;
            BlockPos coord = coordinate.getCoordinate().orElse(BlockPos.f_121853_);
            String coordStr = PneumaticCraftUtils.posToString(coord);
            if (PneumaticCraftUtils.distBetweenSq((Vec3i)coord, 0.0, 0.0, 0.0) < 4096.0) {
                if (tooltip == null) continue;
                tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.coordIsNotChangedWarning", coordStr).m_130940_(ChatFormatting.YELLOW));
                continue;
            }
            if (tooltip != null) {
                tooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.programmer.button.convertToRelative.coordIsChangedWarning", coordStr).m_130940_(ChatFormatting.YELLOW));
            }
            if (simulate) continue;
            BlockPos offset = coord.m_141950_((Vec3i)baseCoord);
            String var = this.makeOffsetVariable(offsetToVariableNames, baseWidget.getVariable(), offset);
            coordinate.setVariable(var);
            coordinate.setUsingVariable(true);
        }
        if (!offsetToVariableNames.isEmpty()) {
            ProgWidgetCoordinateOperator firstOperator = null;
            ProgWidgetCoordinateOperator prevOperator = baseWidget;
            int x = baseWidget.getX();
            for (Map.Entry entry : offsetToVariableNames.entrySet()) {
                ProgWidgetCoordinateOperator operator = new ProgWidgetCoordinateOperator();
                operator.setVariable((String)entry.getValue());
                int y = prevOperator.getY() + prevOperator.getHeight() / 2;
                operator.setX(x);
                operator.setY(y);
                if (!this.isValidPlaced(operator)) {
                    return false;
                }
                ProgWidgetCoordinate coordinatePiece1 = new ProgWidgetCoordinate();
                coordinatePiece1.setX(x + prevOperator.getWidth() / 2);
                coordinatePiece1.setY(y);
                coordinatePiece1.setVariable(baseWidget.getVariable());
                coordinatePiece1.setUsingVariable(true);
                if (!this.isValidPlaced(coordinatePiece1)) {
                    return false;
                }
                ProgWidgetCoordinate coordinatePiece2 = new ProgWidgetCoordinate();
                coordinatePiece2.setX(x + prevOperator.getWidth() / 2 + coordinatePiece1.getWidth() / 2);
                coordinatePiece2.setY(y);
                coordinatePiece2.setCoordinate((BlockPos)entry.getKey());
                if (!this.isValidPlaced(coordinatePiece2)) {
                    return false;
                }
                if (!simulate) {
                    ((ProgrammerBlockEntity)this.te).progWidgets.add(operator);
                    ((ProgrammerBlockEntity)this.te).progWidgets.add(coordinatePiece1);
                    ((ProgrammerBlockEntity)this.te).progWidgets.add(coordinatePiece2);
                }
                if (firstOperator == null) {
                    firstOperator = operator;
                }
                prevOperator = operator;
            }
            if (!simulate) {
                NetworkHandler.sendToServer(new PacketProgrammerUpdate((ProgrammerBlockEntity)this.te));
                ProgrammerBlockEntity.updatePuzzleConnections(((ProgrammerBlockEntity)this.te).progWidgets);
            }
        }
        return true;
    }

    private void rotateCoords90() {
        ProgWidgetCoordinateOperator baseWidget;
        IProgWidget startWidget = ProgrammerScreen.findWidget(((ProgrammerBlockEntity)this.te).progWidgets, ProgWidgetStart.class);
        if (startWidget == null) {
            return;
        }
        boolean changed = false;
        IProgWidget iProgWidget = startWidget.getOutputWidget();
        if (iProgWidget instanceof ProgWidgetCoordinateOperator && !(baseWidget = (ProgWidgetCoordinateOperator)iProgWidget).getVariable().isEmpty()) {
            String varName = baseWidget.getVariable();
            for (IProgWidget widget : ((ProgrammerBlockEntity)this.te).progWidgets) {
                IProgWidget iProgWidget2;
                ProgWidgetCoordinate c1;
                IProgWidget iProgWidget3;
                ProgWidgetCoordinateOperator oper;
                if (!(widget instanceof ProgWidgetCoordinateOperator) || (oper = (ProgWidgetCoordinateOperator)widget).getOperator() != ProgWidgetCoordinateOperator.EnumOperator.PLUS_MINUS || !((iProgWidget3 = oper.getConnectedParameters()[0]) instanceof ProgWidgetCoordinate) || !(c1 = (ProgWidgetCoordinate)iProgWidget3).isUsingVariable() || !varName.equals(c1.getVariable()) || !(c1.getConnectedParameters()[0] instanceof ProgWidgetCoordinate)) continue;
                while ((iProgWidget2 = c1.getConnectedParameters()[0]) instanceof ProgWidgetCoordinate) {
                    ProgWidgetCoordinate c2 = (ProgWidgetCoordinate)iProgWidget2;
                    BlockPos pos = c2.getCoordinate().orElse(BlockPos.f_121853_);
                    c2.setCoordinate(new BlockPos(pos.m_123343_(), pos.m_123342_(), -pos.m_123341_()));
                    c1 = c2;
                }
                changed = true;
            }
        }
        if (changed) {
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((ProgrammerBlockEntity)this.te));
        }
    }

    private String makeOffsetVariable(Map<BlockPos, String> offsetToVariableNames, String baseVariable, BlockPos offset) {
        if (offset.equals((Object)BlockPos.f_121853_)) {
            return baseVariable;
        }
        return offsetToVariableNames.computeIfAbsent(offset, k -> "var" + (offsetToVariableNames.size() + 1));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        IProgWidget widget;
        double origX = mouseX;
        double origY = mouseY;
        float scale = this.programmerUnit.getScale();
        mouseX = (mouseX - this.programmerUnit.getTranslatedX()) / (double)scale;
        mouseY = (mouseY - this.programmerUnit.getTranslatedY()) / (double)scale;
        if (button == 0) {
            IProgWidget hovered = this.programmerUnit.getHoveredWidget((int)origX, (int)origY);
            ItemStack heldItem = ClientUtils.getClientPlayer().f_36096_.m_142621_();
            if (heldItem.m_41720_() instanceof IPositionProvider) {
                return this.mouseClickedWithPosProvider(mouseX, mouseY, hovered, heldItem);
            }
            if (!heldItem.m_41619_()) {
                return this.mouseClickedWithItem(mouseX, mouseY, hovered, heldItem);
            }
            if (!this.mouseClickedEmpty(mouseX, mouseY, origX, origY, scale, hovered)) return super.m_6375_(origX, origY, button);
            return true;
        }
        if (button == 2) {
            if (this.showingWidgetProgress != 0) return this.showWidgetDocs();
            IProgWidget widget2 = this.programmerUnit.getHoveredWidget((int)origX, (int)origY);
            if (widget2 == null) return super.m_6375_(origX, origY, button);
            this.draggingWidget = widget2.copy();
            ((ProgrammerBlockEntity)this.te).progWidgets.add(this.draggingWidget);
            this.dragMouseStartX = mouseX - (double)this.f_97735_;
            this.dragMouseStartY = mouseY - (double)this.f_97736_;
            this.dragWidgetStartX = widget2.getX();
            this.dragWidgetStartY = widget2.getY();
            if (!Screen.m_96638_()) return true;
            this.copyAndConnectConnectingWidgets(widget2, this.draggingWidget);
            return true;
        }
        if (button != 1 || this.showingWidgetProgress != 0 || (widget = this.programmerUnit.getHoveredWidget((int)origX, (int)origY)) == null) return super.m_6375_(origX, origY, button);
        AbstractProgWidgetScreen<IProgWidget> gui = ProgWidgetGuiManager.getGui(widget, this);
        if (gui == null) return true;
        this.f_96541_.m_91152_(gui);
        return true;
    }

    private boolean mouseClickedWithPosProvider(double mouseX, double mouseY, IProgWidget hovered, ItemStack heldItem) {
        ProgWidgetArea areaToolWidget;
        ProgWidgetArea progWidgetArea = areaToolWidget = heldItem.m_41720_() instanceof GPSAreaToolItem ? GPSAreaToolItem.getArea((Player)this.f_96541_.f_91074_, heldItem) : null;
        if (hovered != null) {
            if (areaToolWidget != null && hovered instanceof ProgWidgetArea) {
                CompoundTag tag = new CompoundTag();
                areaToolWidget.writeToNBT(tag);
                tag.m_128405_("x", hovered.getX());
                tag.m_128405_("y", hovered.getY());
                hovered.readFromNBT(tag);
                NetworkHandler.sendToServer(new PacketProgrammerUpdate((ProgrammerBlockEntity)this.te));
            } else if (heldItem.m_41720_() == ModItems.GPS_TOOL.get()) {
                if (hovered instanceof ProgWidgetCoordinate) {
                    ((ProgWidgetCoordinate)hovered).loadFromGPSTool(heldItem);
                } else if (hovered instanceof ProgWidgetArea) {
                    ProgWidgetArea areaHovered = (ProgWidgetArea)hovered;
                    GPSToolItem.getGPSLocation(ClientUtils.getClientPlayer().m_142081_(), heldItem).ifPresent(gpsPos -> {
                        areaHovered.setPos(0, (BlockPos)gpsPos);
                        areaHovered.setPos(1, (BlockPos)gpsPos);
                    });
                    areaHovered.setVarName(0, GPSToolItem.getVariable(heldItem));
                    areaHovered.setVarName(1, GPSToolItem.getVariable(heldItem));
                }
                NetworkHandler.sendToServer(new PacketProgrammerUpdate((ProgrammerBlockEntity)this.te));
            }
        } else {
            ArrayList<ProgWidget> toCreate = new ArrayList<ProgWidget>();
            if (areaToolWidget != null) {
                if (Screen.m_96638_()) {
                    toCreate.add(ProgWidgetCoordinate.fromPos(areaToolWidget.getPos(0).orElse(BlockPos.f_121853_)));
                    areaToolWidget.getPos(1).ifPresent(pos -> toCreate.add(ProgWidgetCoordinate.fromPos(pos)));
                } else {
                    toCreate.add(areaToolWidget);
                }
            } else if (heldItem.m_41720_() == ModItems.GPS_TOOL.get()) {
                if (Screen.m_96638_()) {
                    ProgWidgetArea areaWidget = ProgWidgetArea.fromPosition(GPSToolItem.getGPSLocation(heldItem).orElse(BlockPos.f_121853_));
                    String var = GPSToolItem.getVariable(heldItem);
                    if (!var.isEmpty()) {
                        areaWidget.setVarName(0, var);
                    }
                    toCreate.add(areaWidget);
                } else {
                    toCreate.add(ProgWidgetCoordinate.fromGPSTool(heldItem));
                }
            }
            int n = ((ProgrammerBlockEntity)this.te).progWidgets.size();
            for (int i = 0; i < toCreate.size(); ++i) {
                IProgWidget p = (IProgWidget)toCreate.get(i);
                p.setX((int)(mouseX - (double)this.f_97735_ - (double)p.getWidth() / 3.0));
                p.setY((int)(mouseY - (double)this.f_97736_ - (double)p.getHeight() / 4.0) + i * p.getHeight());
                if (this.programmerUnit.isOutsideProgrammingArea(p) || !this.isValidPlaced(p)) continue;
                ((ProgrammerBlockEntity)this.te).progWidgets.add(p);
            }
            if (((ProgrammerBlockEntity)this.te).progWidgets.size() > n) {
                NetworkHandler.sendToServer(new PacketProgrammerUpdate((ProgrammerBlockEntity)this.te));
            }
        }
        return true;
    }

    private boolean mouseClickedWithItem(double mouseX, double mouseY, IProgWidget hovered, ItemStack heldItem) {
        if (hovered == null) {
            ProgWidgetItemFilter p = new ProgWidgetItemFilter();
            p.setFilter(heldItem.m_41777_());
            p.setX((int)(mouseX - (double)this.f_97735_ - (double)p.getWidth() / 3.0));
            p.setY((int)(mouseY - (double)this.f_97736_ - (double)p.getHeight() / 4.0));
            if (!this.programmerUnit.isOutsideProgrammingArea(p)) {
                ((ProgrammerBlockEntity)this.te).progWidgets.add(p);
            }
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((ProgrammerBlockEntity)this.te));
            return true;
        }
        if (hovered instanceof ProgWidgetItemFilter) {
            ProgWidgetItemFilter p = (ProgWidgetItemFilter)hovered;
            p.setFilter(heldItem.m_41777_());
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((ProgrammerBlockEntity)this.te));
            return true;
        }
        return false;
    }

    private boolean mouseClickedEmpty(double mouseX, double mouseY, double origX, double origY, float scale, IProgWidget hovered) {
        if (this.showingAllWidgets || origX > (double)(this.f_97735_ + this.getProgrammerBounds().m_110085_() + this.getProgrammerBounds().m_110090_())) {
            for (IProgWidget widget : this.visibleSpawnWidgets) {
                if (!(origX >= (double)(widget.getX() + this.f_97735_)) || !(origY >= (double)(widget.getY() + this.f_97736_)) || !(origX <= (double)((float)(widget.getX() + this.f_97735_) + (float)widget.getWidth() / 2.0f)) || !(origY <= (double)((float)(widget.getY() + this.f_97736_) + (float)widget.getHeight() / 2.0f))) continue;
                this.draggingWidget = widget.copy();
                ((ProgrammerBlockEntity)this.te).progWidgets.add(this.draggingWidget);
                this.dragMouseStartX = mouseX - (double)((int)((float)this.f_97735_ / scale));
                this.dragMouseStartY = mouseY - (double)((int)((float)this.f_97736_ / scale));
                this.dragWidgetStartX = (int)(((double)widget.getX() - this.programmerUnit.getTranslatedX()) / (double)scale);
                this.dragWidgetStartY = (int)(((double)widget.getY() - this.programmerUnit.getTranslatedY()) / (double)scale);
                return true;
            }
        }
        if (hovered != null) {
            this.draggingWidget = hovered;
            this.dragMouseStartX = mouseX - (double)this.f_97735_;
            this.dragMouseStartY = mouseY - (double)this.f_97736_;
            this.dragWidgetStartX = hovered.getX();
            this.dragWidgetStartY = hovered.getY();
            return true;
        }
        if (this.getProgrammerBounds().m_110087_((int)origX - this.f_97735_, (int)origY - this.f_97736_)) {
            this.draggingBG = true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.draggingBG = false;
        if (this.draggingWidget != null) {
            if (this.programmerUnit.isOutsideProgrammingArea(this.draggingWidget)) {
                this.deleteConnectingWidgets(this.draggingWidget);
            } else {
                this.handlePuzzleMargins();
                if (!this.isValidPlaced(this.draggingWidget)) {
                    this.setConnectingWidgetsToXY(this.draggingWidget, (int)this.dragWidgetStartX, (int)this.dragWidgetStartY);
                    if (this.programmerUnit.isOutsideProgrammingArea(this.draggingWidget) || !this.isValidPlaced(this.draggingWidget)) {
                        this.deleteConnectingWidgets(this.draggingWidget);
                    }
                }
            }
            NetworkHandler.sendToServer(new PacketProgrammerUpdate((ProgrammerBlockEntity)this.te));
            ProgrammerBlockEntity.updatePuzzleConnections(((ProgrammerBlockEntity)this.te).progWidgets);
            this.draggingWidget = null;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        return this.programmerUnit.mouseScrolled(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int mouseButton, double dragX, double dragY) {
        if (this.draggingWidget != null) {
            mouseX = (mouseX - this.programmerUnit.getTranslatedX()) / (double)this.programmerUnit.getScale();
            mouseY = (mouseY - this.programmerUnit.getTranslatedY()) / (double)this.programmerUnit.getScale();
            this.setConnectingWidgetsToXY(this.draggingWidget, (int)(mouseX - this.dragMouseStartX + this.dragWidgetStartX - (double)this.f_97735_), (int)(mouseY - this.dragMouseStartY + this.dragWidgetStartY - (double)this.f_97736_));
            return true;
        }
        if (this.draggingBG) {
            return this.programmerUnit.mouseDragged(mouseX, mouseY, mouseButton, dragX, dragY);
        }
        return false;
    }

    @Override
    public void m_7861_() {
        ((ProgrammerBlockEntity)this.te).translatedX = this.programmerUnit.getTranslatedX();
        ((ProgrammerBlockEntity)this.te).translatedY = this.programmerUnit.getTranslatedY();
        ((ProgrammerBlockEntity)this.te).zoomState = this.programmerUnit.getLastZoom();
        ((ProgrammerBlockEntity)this.te).showFlow = this.showFlow.checked;
        ((ProgrammerBlockEntity)this.te).showInfo = this.showInfo.checked;
    }

    public static IProgWidget findWidget(List<IProgWidget> widgets, Class<? extends IProgWidget> cls) {
        return widgets.stream().filter(w -> cls.isAssignableFrom(w.getClass())).findFirst().orElse(null);
    }

    public PointXY mouseToWidgetCoords(double mouseX, double mouseY, ProgWidgetItemFilter p) {
        float scale = this.programmerUnit.getScale();
        mouseX = (mouseX - this.programmerUnit.getTranslatedX()) / (double)scale;
        mouseY = (mouseY - this.programmerUnit.getTranslatedY()) / (double)scale;
        return new PointXY((int)(mouseX - (double)this.f_97735_ - (double)p.getWidth() / 3.0), (int)(mouseY - (double)this.f_97736_ - (double)p.getHeight() / 4.0));
    }

    public boolean isVisible(IProgWidget w) {
        return !this.programmerUnit.isOutsideProgrammingArea(w);
    }

    private static class DifficultyButton
    extends WidgetRadioButton {
        final IProgWidget.WidgetDifficulty difficulty;

        DifficultyButton(int x, int y, int color, IProgWidget.WidgetDifficulty difficulty, Consumer<WidgetRadioButton> pressable) {
            super(x, y, color, (Component)PneumaticCraftUtils.xlate(difficulty.getTranslationKey(), new Object[0]), pressable);
            this.difficulty = difficulty;
        }
    }

    private static class FilterTextField
    extends WidgetTextField {
        FilterTextField(Font font, int x, int y, int width, int height) {
            super(font, x, y, width, height);
        }

        @Override
        public void m_6303_(PoseStack matrixStack, int x, int y, float partialTicks) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.0, 300.0);
            super.m_6303_(matrixStack, x, y, partialTicks);
            matrixStack.m_85849_();
        }
    }

    private static class RemovingWidget {
        final IProgWidget widget;
        double ty = 0.0;
        double tx = 0.0;
        final double velX;
        double velY;

        private RemovingWidget(IProgWidget widget) {
            this.velX = (ClientUtils.getClientLevel().f_46441_.nextDouble() - 0.5) * 3.0;
            this.velY = -4.0;
            this.widget = widget;
        }

        public void tick() {
            this.ty += this.velY;
            this.tx += this.velX;
            this.velY += 0.35;
        }
    }
}

