/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.block.entity.PressureChamberInterfaceBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.PressureChamberInterfaceMenu;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PressureChamberInterfaceScreen
extends AbstractPneumaticCraftContainerScreen<PressureChamberInterfaceMenu, PressureChamberInterfaceBlockEntity> {
    private WidgetAnimatedStat statusStat;
    private WidgetButtonExtended exportAnyButton;
    private WidgetLabel exportTypeLabel;
    private boolean hasEnoughPressure = true;

    public PressureChamberInterfaceScreen(PressureChamberInterfaceMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.statusStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pressureChamberInterface.status", new Object[0]), new ItemStack((ItemLike)ModBlocks.PRESSURE_CHAMBER_INTERFACE.get()), -22016, false);
        this.exportAnyButton = (WidgetButtonExtended)this.m_142416_((GuiEventListener)new WidgetButtonExtended(this.f_97735_ + 100, this.f_97736_ + 32, 60, 20, TextComponent.f_131282_).withTag("export_mode"));
        this.exportTypeLabel = (WidgetLabel)this.m_142416_((GuiEventListener)new WidgetLabel(this.f_97735_ + 100, this.f_97736_ + 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.pressureChamberInterface.exportLabel", new Object[0])));
        this.setupExportButtonVisibility();
    }

    private void setupExportButtonVisibility() {
        boolean exporting = ((PressureChamberInterfaceBlockEntity)this.te).interfaceMode == PressureChamberInterfaceBlockEntity.InterfaceDirection.EXPORT;
        this.exportAnyButton.setVisible(exporting);
        this.exportAnyButton.f_93624_ = exporting;
        this.exportTypeLabel.f_93624_ = exporting;
        if (exporting) {
            String textKey = "pneumaticcraft.gui.pressureChamberInterface.export." + (((PressureChamberInterfaceBlockEntity)this.te).exportAny ? "any" : "valid");
            this.exportAnyButton.m_93666_((Component)PneumaticCraftUtils.xlate(textKey, new Object[0]));
            this.exportAnyButton.setTooltipKey(textKey + ".tooltip", new Object[0]);
        }
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        super.m_7027_(matrixStack, x, y);
        int inputShift = (int)((1.0f - Mth.m_14089_((float)(((PressureChamberInterfaceBlockEntity)this.te).inputProgress / 125.663704f))) * 11.0f);
        int outputShift = (int)((1.0f - Mth.m_14089_((float)(((PressureChamberInterfaceBlockEntity)this.te).outputProgress / 125.663704f))) * 11.0f);
        PressureChamberInterfaceScreen.m_93172_((PoseStack)matrixStack, (int)(63 + inputShift), (int)30, (int)(87 + inputShift), (int)32, (int)-10853633);
        PressureChamberInterfaceScreen.m_93172_((PoseStack)matrixStack, (int)(63 + outputShift), (int)54, (int)(87 + outputShift), (int)56, (int)-22528);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_PRESSURE_CHAMBER_INTERFACE;
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        this.setupExportButtonVisibility();
        if (((PressureChamberInterfaceBlockEntity)this.te).interfaceMode != PressureChamberInterfaceBlockEntity.InterfaceDirection.NONE) {
            this.statusStat.setText((Component)PneumaticCraftUtils.xlate(((PressureChamberInterfaceBlockEntity)this.te).interfaceMode.getTranslationKey(), new Object[0]).m_130940_(ChatFormatting.BLACK));
        } else {
            this.statusStat.setText(Collections.emptyList());
        }
        if (this.hasEnoughPressure && !((PressureChamberInterfaceBlockEntity)this.te).hasEnoughPressure()) {
            this.hasEnoughPressure = false;
            this.problemTab.openStat();
        } else if (((PressureChamberInterfaceBlockEntity)this.te).hasEnoughPressure()) {
            this.hasEnoughPressure = true;
        }
    }

    @Override
    protected void addProblems(List<Component> curInfo) {
        super.addProblems(curInfo);
        if (((PressureChamberInterfaceBlockEntity)this.te).interfaceMode == PressureChamberInterfaceBlockEntity.InterfaceDirection.NONE) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.pressure_chamber_interface.not_formed", new Object[0]));
        } else if (!((PressureChamberInterfaceBlockEntity)this.te).hasEnoughPressure()) {
            curInfo.addAll(GuiUtils.xlateAndSplit("pneumaticcraft.gui.tab.problems.pressure_chamber_interface.not_enough_pressure", new Object[0]));
        }
    }
}

