/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.event;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IFOVModifierItem;
import me.desht.pneumaticcraft.api.item.ICustomDurabilityBar;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.IExtraGuiHandling;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.ArmorMainScreen;
import me.desht.pneumaticcraft.client.gui.widget.IDrawAfterRender;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.RenderUtils;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.config.subconfig.AuxConfigHandler;
import me.desht.pneumaticcraft.common.item.IShiftScrollable;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketShiftScrollWheel;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.FogType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pneumaticcraft", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    private static float currentScreenRoll = 0.0f;
    private static final int Z_LEVEL = 233;

    @SubscribeEvent
    public static void screenTilt(EntityViewRenderEvent.CameraSetup event) {
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (PneumaticArmorItem.isPneumaticArmorPiece(player, EquipmentSlot.FEET) && !player.m_20096_()) {
                float targetRoll;
                float div = 50.0f;
                JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getClientTracker().getJetBootsState(player);
                if (jbState.isActive() && !jbState.isBuilderMode()) {
                    float roll = player.f_20885_ - player.f_20886_;
                    if ((double)Math.abs(roll) < 1.0E-4) {
                        targetRoll = 0.0f;
                    } else {
                        targetRoll = Math.signum(roll) * (float)((Integer)ConfigHelper.client().armor.maxJetBootsFlightRoll.get()).intValue();
                        div = Math.abs(100.0f / roll);
                    }
                } else {
                    targetRoll = 0.0f;
                }
                currentScreenRoll += (targetRoll - currentScreenRoll) / div;
                event.setRoll(currentScreenRoll);
            } else {
                currentScreenRoll = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public static void playerPreRotateEvent(RenderPlayerEvent.Pre event) {
        JetBootsStateTracker.JetBootsState state;
        Player player = event.getPlayer();
        if (!player.m_21255_() && (state = JetBootsStateTracker.getClientTracker().getJetBootsState(player)) != null && state.shouldRotatePlayer()) {
            player.f_20924_ = 0.0f;
            player.f_20925_ = 0.0f;
        }
    }

    @SubscribeEvent
    public static void adjustFOVEvent(FOVModifierEvent event) {
        float modifier = 1.0f;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = event.getEntity().m_6844_(slot);
            Item item = stack.m_41720_();
            if (!(item instanceof IFOVModifierItem)) continue;
            IFOVModifierItem fovModifier = (IFOVModifierItem)item;
            modifier *= fovModifier.getFOVModifier(stack, event.getEntity(), slot);
        }
        event.setNewfov(event.getNewfov() * modifier);
    }

    @SubscribeEvent
    public static void fogDensityEvent(EntityViewRenderEvent.RenderFogEvent event) {
        CommonArmorHandler handler;
        if (event.getCamera().m_167685_() == FogType.WATER && event.getCamera().m_90592_() instanceof Player && (handler = CommonArmorHandler.getHandlerForPlayer()).upgradeUsable(CommonUpgradeHandlers.scubaHandler, true)) {
            event.setNearPlaneDistance(20.0f);
            event.setNearPlaneDistance(50.0f);
            event.setFogShape(FogShape.SPHERE);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void guiContainerForeground(ContainerScreenEvent.DrawForeground event) {
        AbstractContainerScreen abstractContainerScreen = event.getContainerScreen();
        if (abstractContainerScreen instanceof IExtraGuiHandling) {
            IExtraGuiHandling e = (IExtraGuiHandling)abstractContainerScreen;
            e.drawExtras(event);
        }
        RenderSystem.m_69472_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        BufferBuilder bb = Tesselator.m_85913_().m_85915_();
        AbstractContainerScreen container = event.getContainerScreen();
        PoseStack matrixStack = event.getPoseStack();
        for (Slot s : container.m_6262_().f_38839_) {
            int yOff;
            ICustomDurabilityBar custom;
            Item item = s.m_7993_().m_41720_();
            if (!(item instanceof ICustomDurabilityBar) || !(custom = (ICustomDurabilityBar)item).shouldShowCustomDurabilityBar(s.m_7993_())) continue;
            int x = s.f_40220_;
            int y = s.f_40221_;
            float width = custom.getCustomDurability(s.m_7993_()) * 13.0f;
            int[] cols = RenderUtils.decomposeColor(custom.getCustomDurabilityColour(s.m_7993_()));
            int n = yOff = custom.isShowingOtherBar(s.m_7993_()) ? 0 : 1;
            if (yOff == 1) {
                GuiUtils.drawUntexturedQuad(matrixStack, bb, x + 2, y + 14, 233.0f, width, 1.0f, 40, 40, 40, 255);
            }
            GuiUtils.drawUntexturedQuad(matrixStack, bb, x + 2, y + 12 + yOff, 233.0f, 13.0f, 1.0f, 0, 0, 0, 255);
            GuiUtils.drawUntexturedQuad(matrixStack, bb, x + 2, y + 12 + yOff, 233.0f, width, 1.0f, cols[1], cols[2], cols[3], 255);
        }
        RenderSystem.m_69493_();
    }

    @SubscribeEvent
    public static void onGuiDrawPost(ScreenEvent.DrawScreenEvent.Post event) {
        List<IDrawAfterRender> toDraw;
        if ((event.getScreen() instanceof AbstractPneumaticCraftContainerScreen || event.getScreen() instanceof AbstractPneumaticCraftScreen) && !(toDraw = event.getScreen().m_6702_().stream().filter(l -> l instanceof IDrawAfterRender).map(l -> (IDrawAfterRender)l).toList()).isEmpty()) {
            event.getPoseStack().m_85836_();
            event.getPoseStack().m_85837_(0.0, 0.0, 500.0);
            toDraw.forEach(d -> d.renderAfterEverythingElse(event.getPoseStack(), event.getMouseX(), event.getMouseY(), event.getPartialTicks()));
            event.getPoseStack().m_85849_();
        }
    }

    @SubscribeEvent
    public static void onShiftScroll(InputEvent.MouseScrollEvent event) {
        if (ClientUtils.getClientPlayer().m_6047_() && !ClientEventHandler.tryHand(event, InteractionHand.MAIN_HAND)) {
            ClientEventHandler.tryHand(event, InteractionHand.OFF_HAND);
        }
    }

    private static boolean tryHand(InputEvent.MouseScrollEvent event, InteractionHand hand) {
        ItemStack stack = ClientUtils.getClientPlayer().m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof IShiftScrollable) {
            IShiftScrollable s = (IShiftScrollable)item;
            NetworkHandler.sendToServer(new PacketShiftScrollWheel(event.getScrollDelta() > 0.0, InteractionHand.MAIN_HAND));
            s.onShiftScrolled(ClientUtils.getClientPlayer(), event.getScrollDelta() > 0.0, InteractionHand.MAIN_HAND);
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onClientConnect(ClientPlayerNetworkEvent.LoggedInEvent event) {
        AuxConfigHandler.postInit();
        ArmorMainScreen.initHelmetCoreComponents();
    }
}

