/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.api;

import me.desht.pneumaticcraft.api.client.IClientRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.api.crafting.IPneumaticRecipeRegistry;
import me.desht.pneumaticcraft.api.crafting.ingredient.FluidIngredient;
import me.desht.pneumaticcraft.api.drone.IDroneRegistry;
import me.desht.pneumaticcraft.api.fuel.IFuelRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatRegistry;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IUpgradeRegistry;
import me.desht.pneumaticcraft.api.misc.IMiscHelpers;
import me.desht.pneumaticcraft.api.misc.IPlayerMatcher;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorRegistry;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachineFactory;
import me.desht.pneumaticcraft.api.universal_sensor.ISensorRegistry;
import me.desht.pneumaticcraft.api.wrench.IWrenchRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.items.IItemHandler;

public final class PneumaticRegistry {
    public static final String MOD_ID = "pneumaticcraft";
    private static IPneumaticCraftInterface instance;

    public static IPneumaticCraftInterface getInstance() {
        return instance;
    }

    public static void init(IPneumaticCraftInterface inter) {
        if (instance != null || !ModLoadingContext.get().getActiveContainer().getModId().equals(MOD_ID)) {
            throw new IllegalStateException("Only pneumaticcraft is allowed to call this method!");
        }
        instance = inter;
    }

    public static ResourceLocation RL(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static interface IPneumaticCraftInterface {
        public IPneumaticRecipeRegistry getRecipeRegistry();

        public IAirHandlerMachineFactory getAirHandlerMachineFactory();

        public IPneumaticHelmetRegistry getHelmetRegistry();

        public ICommonArmorRegistry getCommonArmorRegistry();

        public IDroneRegistry getDroneRegistry();

        public IHeatRegistry getHeatRegistry();

        public IClientRegistry getClientRegistry();

        public ISensorRegistry getSensorRegistry();

        public IItemRegistry getItemRegistry();

        public IUpgradeRegistry getUpgradeRegistry();

        public IFuelRegistry getFuelRegistry();

        public IWrenchRegistry getWrenchRegistry();

        public IMiscHelpers getMiscHelpers();

        @Deprecated(forRemoval=true)
        public int getProtectingSecurityStations(Player var1, BlockPos var2);

        @Deprecated(forRemoval=true)
        public void registerXPFluid(FluidIngredient var1, int var2);

        @Deprecated(forRemoval=true)
        public void syncGlobalVariable(ServerPlayer var1, String var2);

        @Deprecated(forRemoval=true)
        public void registerPlayerMatcher(ResourceLocation var1, IPlayerMatcher.MatcherFactory<?> var2);

        @Deprecated(forRemoval=true)
        public IItemHandler deserializeSmartChest(CompoundTag var1);

        @Deprecated(forRemoval=true)
        public void forceClientShapeRecalculation(Level var1, BlockPos var2);
    }
}

