/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.digital_adapter;

import com.mrh0.createaddition.CreateAddition;
import com.mrh0.createaddition.blocks.digital_adapter.ISpeedControllerAdapter;
import com.mrh0.createaddition.compat.computercraft.DigitalAdapterPeripheral;
import com.mrh0.createaddition.compat.computercraft.Peripherals;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.simibubi.create.content.contraptions.elevator.ElevatorPulleyBlockEntity;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlockEntity;
import com.simibubi.create.content.contraptions.pulley.PulleyBlockEntity;
import com.simibubi.create.content.fluids.hosePulley.HosePulleyBlockEntity;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.simibubi.create.content.kinetics.speedController.SpeedControllerBlockEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class DigitalAdapterBlockEntity
extends BlockEntity {
    public final List<MutableComponent> textLines = new ArrayList<MutableComponent>();
    public static final int MAX_LINES = 16;
    public static final MutableComponent EMPTY_LINE = new TextComponent("");
    protected LazyOptional<DigitalAdapterPeripheral> peripheral;
    private int line = 1;

    public DigitalAdapterBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        for (int i = 0; i < 16; ++i) {
            this.textLines.add(EMPTY_LINE);
        }
        if (CreateAddition.CC_ACTIVE) {
            this.peripheral = LazyOptional.of(() -> Peripherals.createDigitalAdapterPeripheral(this));
        }
    }

    public void incrementLine() {
        this.line = Math.min(this.line + 1, 16);
    }

    public void setTextLine(int ln, MutableComponent text) {
        if (ln < 1 || ln > 16) {
            return;
        }
        this.textLines.set(ln - 1, text);
    }

    public MutableComponent getTextLine(int ln) {
        if (ln < 1 || ln > 16) {
            return EMPTY_LINE;
        }
        return this.textLines.get(ln - 1);
    }

    public void clearLine(int ln) {
        this.setTextLine(ln, EMPTY_LINE);
    }

    public void clearAll() {
        for (int i = 1; i < 17; ++i) {
            this.clearLine(i);
        }
    }

    public void append(int ln, MutableComponent text) {
        this.setTextLine(ln, this.getTextLine(ln).m_7220_((Component)text));
    }

    public int getLine() {
        return this.line;
    }

    public int setLine(int ln) {
        this.line = ln < 1 || ln > 16 ? this.line : ln;
        return this.line;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (CreateAddition.CC_ACTIVE && Peripherals.isPeripheral(cap)) {
            return this.peripheral.cast();
        }
        return super.getCapability(cap, side);
    }

    public SpeedControllerBlockEntity getSpeedController(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_142300_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof SpeedControllerBlockEntity) {
            SpeedControllerBlockEntity scte = (SpeedControllerBlockEntity)be;
            return scte;
        }
        return null;
    }

    public PulleyBlockEntity getRopePulley(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_142300_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof PulleyBlockEntity) {
            PulleyBlockEntity pte = (PulleyBlockEntity)be;
            return pte;
        }
        return null;
    }

    public HosePulleyBlockEntity getHosePulley(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_142300_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof HosePulleyBlockEntity) {
            HosePulleyBlockEntity pte = (HosePulleyBlockEntity)be;
            return pte;
        }
        return null;
    }

    public ElevatorPulleyBlockEntity getElevatorPulley(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_142300_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof ElevatorPulleyBlockEntity) {
            ElevatorPulleyBlockEntity epbe = (ElevatorPulleyBlockEntity)be;
            return epbe;
        }
        return null;
    }

    public MechanicalPistonBlockEntity getMechanicalPiston(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_142300_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof MechanicalPistonBlockEntity) {
            MechanicalPistonBlockEntity mpte = (MechanicalPistonBlockEntity)be;
            return mpte;
        }
        return null;
    }

    public MechanicalBearingBlockEntity getMechanicalBearing(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_142300_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof MechanicalBearingBlockEntity) {
            MechanicalBearingBlockEntity mpte = (MechanicalBearingBlockEntity)be;
            return mpte;
        }
        return null;
    }

    public StressGaugeBlockEntity getStressGauge(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_142300_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof StressGaugeBlockEntity) {
            StressGaugeBlockEntity sgte = (StressGaugeBlockEntity)be;
            return sgte;
        }
        return null;
    }

    public SpeedGaugeBlockEntity getSpeedGauge(Direction dir) {
        BlockEntity be = this.f_58857_.m_7702_(this.m_58899_().m_142300_(dir));
        if (be == null) {
            return null;
        }
        if (be instanceof SpeedGaugeBlockEntity) {
            SpeedGaugeBlockEntity sgte = (SpeedGaugeBlockEntity)be;
            return sgte;
        }
        return null;
    }

    public void setTargetSpeed(Direction dir, int speed) {
        SpeedControllerBlockEntity scte = this.getSpeedController(dir);
        if (scte == null) {
            return;
        }
        ISpeedControllerAdapter sts = (ISpeedControllerAdapter)scte;
        sts.setTargetSpeed(speed);
    }

    public int getTargetSpeed(Direction dir) {
        SpeedControllerBlockEntity scte = this.getSpeedController(dir);
        if (scte == null) {
            return 0;
        }
        ISpeedControllerAdapter sts = (ISpeedControllerAdapter)scte;
        return sts.getTargetSpeed();
    }
}

