/*
 * Decompiled with CFR 0.152.
 */
package github.shrekshellraiser.cctech.server;

import github.shrekshellraiser.cctech.CCTech;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class FileManager {
    public static int POINTER_SIZE = 4;

    private static void checkDir(String folder) {
        File folderFile;
        File world = new File(ServerLifecycleHooks.getCurrentServer().m_129843_(new LevelResource("cctech")).toString());
        if (!world.isDirectory()) {
            world.mkdir();
        }
        if (!(folderFile = new File(world, folder)).isDirectory()) {
            folderFile.mkdir();
        }
    }

    public static void deleteDevice(String folder, String UUID) {
        FileManager.checkDir(folder);
        CCTech.LOGGER.debug("Deleting data at " + folder + " " + UUID);
        Path path = Paths.get(ServerLifecycleHooks.getCurrentServer().m_129843_(new LevelResource("cctech")).toString(), folder, UUID);
        if (!path.toFile().delete()) {
            CCTech.LOGGER.warn("Unable to delete data at " + folder + " " + UUID);
        }
    }

    public static byte[] getData(String folder, String UUID) {
        FileManager.checkDir(folder);
        CCTech.LOGGER.debug("Getting data for " + folder + " " + UUID);
        Path path = Paths.get(ServerLifecycleHooks.getCurrentServer().m_129843_(new LevelResource("cctech")).toString(), folder, UUID);
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            CCTech.LOGGER.error((Object)e);
            byte[] data = new byte[POINTER_SIZE];
            FileManager.saveData(data, folder, UUID);
            return data;
        }
    }

    public static byte[] getData(String folder, String UUID, int targetLength) {
        byte[] data = FileManager.getData(folder, UUID);
        if (data.length < targetLength) {
            CCTech.LOGGER.warn("Loaded data is smaller than target size, adjusting..");
            byte[] newData = new byte[targetLength];
            System.arraycopy(data, 0, newData, 0, data.length);
            data = newData;
        }
        return data;
    }

    public static void saveData(byte[] data, String folder, String UUID) {
        FileManager.checkDir(folder);
        CCTech.LOGGER.debug("Saving data for " + folder + " " + UUID);
        Path path = Paths.get(ServerLifecycleHooks.getCurrentServer().m_129843_(new LevelResource("cctech")).toString(), folder, UUID);
        try (FileOutputStream fos = new FileOutputStream(path.toString());){
            fos.write(data);
        }
        catch (IOException e) {
            CCTech.LOGGER.error((Object)e);
        }
    }

    public static void saveData(byte[] data, int pointer, String folder, String UUID) {
        FileManager.setPointer(data, pointer);
        FileManager.saveData(data, folder, UUID);
    }

    public static int getPointer(byte @NotNull [] data) {
        return data[0] + (data[1] << 8) + (data[2] << 16) + (data[3] << 24);
    }

    public static void setPointer(byte @NotNull [] data, int pointer) {
        data[0] = (byte)(pointer & 0xFF);
        data[1] = (byte)(pointer >> 8 & 0xFF);
        data[2] = (byte)(pointer >> 16 & 0xFF);
        data[3] = (byte)(pointer >> 24 & 0xFF);
    }
}

