/*
 * Decompiled with CFR 0.152.
 */
package github.shrekshellraiser.cctech.common.peripheral.cards;

import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import github.shrekshellraiser.cctech.common.peripheral.cards.MagCardBlockEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public class MagCardPeripheral
implements IPeripheral {
    private final List<IComputerAccess> connectedComputers = new ArrayList<IComputerAccess>();
    protected final MagCardBlockEntity tileEntity;

    public MagCardPeripheral(MagCardBlockEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.connectedComputers.remove(computer);
    }

    @NotNull
    public String getType() {
        return "magnetic_card_reader";
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.connectedComputers.add(computer);
    }

    public void cardScanned(String writerUUID, String contents) {
        for (IComputerAccess computerAccess : this.connectedComputers) {
            computerAccess.queueEvent("magnetic_card_scanned", new Object[]{writerUUID, contents});
        }
    }
}

