/*
 * Decompiled with CFR 0.152.
 */
package github.shrekshellraiser.cctech.common.peripheral.cards;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import github.shrekshellraiser.cctech.common.peripheral.cards.CardWriterBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import org.jetbrains.annotations.NotNull;

public class CardWriterPeripheral
implements IPeripheral {
    private final List<IComputerAccess> connectedComputers = new ArrayList<IComputerAccess>();
    protected final CardWriterBlockEntity tileEntity;

    public CardWriterPeripheral(CardWriterBlockEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public void detach(@Nonnull IComputerAccess computer) {
        this.connectedComputers.remove(computer);
    }

    @NotNull
    public String getType() {
        return "magnetic_card_reader";
    }

    public void attach(@Nonnull IComputerAccess computer) {
        this.connectedComputers.add(computer);
    }

    @LuaFunction
    public final void writeCard(String data) throws LuaException {
        this.tileEntity.writeCard(data);
    }

    @LuaFunction
    public final void setLabel(String label) throws LuaException {
        this.tileEntity.setLabel(label);
    }

    @LuaFunction
    public final String getLabel() throws LuaException {
        return this.tileEntity.getLabel();
    }

    @LuaFunction
    public final boolean clearLabel() throws LuaException {
        return this.tileEntity.clearLabel();
    }

    @LuaFunction
    public final HashMap<String, String> readCard() throws LuaException {
        return this.tileEntity.readCard();
    }

    @LuaFunction
    public final String getUUID() {
        return this.tileEntity.getUUID();
    }
}

