/*
 * Decompiled with CFR 0.152.
 */
package github.shrekshellraiser.cctech.common.peripheral;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.Capabilities;
import github.shrekshellraiser.cctech.common.item.StorageItem;
import github.shrekshellraiser.cctech.common.item.tape.CassetteItem;
import github.shrekshellraiser.cctech.common.item.tape.TapeItem;
import github.shrekshellraiser.cctech.common.network.ModMessages;
import github.shrekshellraiser.cctech.common.network.packet.ItemStackSyncS2CPacket;
import github.shrekshellraiser.cctech.server.FileManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class StorageBlockEntity
extends BlockEntity {
    protected byte[] data = new byte[2];
    protected String uuid;
    protected boolean deviceInserted = false;
    protected boolean dataChanged = false;
    protected String deviceDir;
    protected IPeripheral peripheral;
    protected LazyOptional<IPeripheral> peripheralCap;
    protected LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    protected final ItemStackHandler itemHandler = this.createItemHandler();

    public StorageBlockEntity(BlockEntityType<?> pType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pType, pWorldPosition, pBlockState);
        this.deviceDir = CassetteItem.getDeviceDir();
    }

    public abstract AbstractContainerMenu createMenu(int var1, @NotNull Inventory var2, @NotNull Player var3);

    public Item getItem() {
        return this.itemHandler.getStackInSlot(0).m_41720_();
    }

    public ItemStack getRenderStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    protected ItemStackHandler createItemHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                StorageBlockEntity.this.m_6596_();
                assert (StorageBlockEntity.this.f_58857_ != null);
                if (!StorageBlockEntity.this.f_58857_.m_5776_()) {
                    ItemStack item = this.getStackInSlot(slot);
                    if (item.m_41720_() instanceof StorageItem && !StorageBlockEntity.this.deviceInserted) {
                        StorageBlockEntity.this.itemInserted(item);
                    } else if (StorageBlockEntity.this.uuid != null && StorageBlockEntity.this.deviceInserted) {
                        StorageBlockEntity.this.itemRemoved(item);
                    }
                    ModMessages.sendToClients(new ItemStackSyncS2CPacket(this, StorageBlockEntity.this.f_58858_));
                }
            }
        };
    }

    protected void itemInserted(ItemStack item) {
        this.loadData(item);
        this.deviceInserted = true;
    }

    protected void itemRemoved(ItemStack item) {
        this.saveData(item);
        this.deviceInserted = false;
        this.uuid = null;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction direction) {
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.peripheralCap == null) {
                this.peripheralCap = LazyOptional.of(() -> this.peripheral);
            }
            return this.peripheralCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, direction);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        inventory.m_6836_(0, this.itemHandler.getStackInSlot(0));
        ItemStack cassette = this.itemHandler.getStackInSlot(0);
        if (cassette.m_41720_() instanceof StorageItem) {
            this.saveData(cassette);
            this.deviceInserted = false;
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        super.m_183515_(tag);
        ItemStack cassette = this.itemHandler.getStackInSlot(0);
        if (cassette.m_41720_() instanceof TapeItem) {
            this.saveData(cassette);
            this.deviceInserted = true;
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        ItemStack cassette = this.itemHandler.getStackInSlot(0);
        if (cassette.m_41720_() instanceof TapeItem) {
            this.loadData(cassette);
            this.deviceInserted = true;
        }
    }

    protected void loadData(ItemStack item) {
        this.uuid = ((StorageItem)item.m_41720_()).getUUID(item);
        this.data = FileManager.getData(this.deviceDir, this.uuid, ((StorageItem)item.m_41720_()).getSize(item));
    }

    protected void saveData(ItemStack item) {
        FileManager.saveData(this.data, this.deviceDir, this.uuid);
    }
}

