/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.client.model;

import com.mrcrayfish.framework.api.serialize.DataObject;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;

public class BakedOpenModel
extends BakedModelWrapper<BakedModel> {
    private final DataObject data;

    public BakedOpenModel(BakedModel originalModel, @Nullable DataObject data) {
        super(originalModel);
        this.data = data;
    }

    public static DataObject getData(ResourceLocation modelLocation) {
        DataObject dataObject;
        BakedModel model = Minecraft.m_91087_().m_91304_().getModel(modelLocation);
        if (model instanceof BakedOpenModel) {
            BakedOpenModel openModel = (BakedOpenModel)model;
            dataObject = openModel.data;
        } else {
            dataObject = DataObject.EMPTY;
        }
        return dataObject;
    }

    public static DataObject getData(BlockState state) {
        DataObject dataObject;
        BakedModel model = Minecraft.m_91087_().m_91304_().m_119430_().m_110893_(state);
        if (model instanceof BakedOpenModel) {
            BakedOpenModel openModel = (BakedOpenModel)model;
            dataObject = openModel.data;
        } else {
            dataObject = DataObject.EMPTY;
        }
        return dataObject;
    }

    public static DataObject getData(Item item) {
        DataObject dataObject;
        BakedModel model = Minecraft.m_91087_().m_91291_().m_115103_().m_109394_(item);
        if (model instanceof BakedOpenModel) {
            BakedOpenModel openModel = (BakedOpenModel)model;
            dataObject = openModel.data;
        } else {
            dataObject = DataObject.EMPTY;
        }
        return dataObject;
    }

    public static DataObject getData(ItemStack stack, @Nullable Level level, @Nullable LivingEntity entity, int seed) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_115103_().m_109394_(stack.m_41720_());
        if (model != null) {
            DataObject dataObject;
            ClientLevel clientLevel = level instanceof ClientLevel ? (ClientLevel)level : null;
            BakedModel overrideModel = model.m_7343_().m_173464_(model, stack, clientLevel, entity, seed);
            if (overrideModel instanceof BakedOpenModel) {
                BakedOpenModel openModel = (BakedOpenModel)overrideModel;
                dataObject = openModel.data;
            } else {
                dataObject = DataObject.EMPTY;
            }
            return dataObject;
        }
        return DataObject.EMPTY;
    }
}

