/*
 * Decompiled with CFR 0.152.
 */
package com.getitemfromblock.create_tweaked_controllers.packet;

import com.getitemfromblock.create_tweaked_controllers.block.TweakedLecternControllerBlockEntity;
import com.getitemfromblock.create_tweaked_controllers.controller.ControllerRedstoneOutput;
import com.getitemfromblock.create_tweaked_controllers.controller.TweakedLinkedControllerServerHandler;
import com.getitemfromblock.create_tweaked_controllers.item.TweakedLinkedControllerItem;
import com.getitemfromblock.create_tweaked_controllers.packet.TweakedLinkedControllerPacketBase;
import com.simibubi.create.content.redstone.link.RedstoneLinkNetworkHandler;
import com.simibubi.create.foundation.utility.Couple;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class TweakedLinkedControllerButtonPacket
extends TweakedLinkedControllerPacketBase {
    private short buttonStates = 0;

    public TweakedLinkedControllerButtonPacket(short buttons) {
        this(buttons, null);
    }

    public TweakedLinkedControllerButtonPacket(short button, BlockPos lecternPos) {
        super(lecternPos);
        this.buttonStates = button;
    }

    public TweakedLinkedControllerButtonPacket(FriendlyByteBuf buffer) {
        super(buffer);
        this.buttonStates = buffer.readShort();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeShort((int)this.buttonStates);
    }

    @Override
    protected void handleLectern(ServerPlayer player, TweakedLecternControllerBlockEntity lectern) {
        if (lectern.isUsedBy((Player)player)) {
            this.handleItem(player, lectern.getController());
            lectern.ReceiveButtonStates(this.buttonStates);
        }
    }

    @Override
    protected void handleItem(ServerPlayer player, ItemStack heldItem) {
        Level world = player.m_20193_();
        UUID uniqueID = player.m_142081_();
        BlockPos pos = player.m_142538_();
        if (player.m_5833_()) {
            return;
        }
        ControllerRedstoneOutput output = new ControllerRedstoneOutput();
        output.DecodeButtons(this.buttonStates);
        ArrayList<Couple<RedstoneLinkNetworkHandler.Frequency>> buttonCouples = new ArrayList<Couple<RedstoneLinkNetworkHandler.Frequency>>(15);
        ArrayList<Boolean> buttonValues = new ArrayList<Boolean>(15);
        for (int i = 0; i < 15; ++i) {
            buttonCouples.add(TweakedLinkedControllerItem.toFrequency(heldItem, i));
            buttonValues.add((this.buttonStates & 1 << i) != 0);
        }
        TweakedLinkedControllerServerHandler.ReceivePressed((LevelAccessor)world, pos, uniqueID, buttonCouples, buttonValues);
    }
}

