/*
 * Decompiled with CFR 0.152.
 */
package com.getitemfromblock.create_tweaked_controllers.input;

import com.getitemfromblock.create_tweaked_controllers.CreateTweakedControllers;
import com.getitemfromblock.create_tweaked_controllers.config.ModClientConfig;
import net.minecraft.network.chat.Component;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWGamepadState;

public class GamepadInputs {
    public static final boolean[] buttons = new boolean[15];
    public static final float[] axis = new float[6];
    protected static GLFWGamepadState state = null;
    protected static int selectedGamepad = -1;

    public static void GetControls() {
        GamepadInputs.CheckState();
        if (selectedGamepad < 0) {
            int uniqueGamepadID = -1;
            block0: for (int i = 0; i < 16 && selectedGamepad < 0; ++i) {
                if (!GLFW.glfwJoystickIsGamepad((int)i)) continue;
                if (uniqueGamepadID == -1) {
                    uniqueGamepadID = i;
                } else if (uniqueGamepadID >= 0) {
                    uniqueGamepadID = -2;
                }
                GLFW.glfwGetGamepadState((int)i, (GLFWGamepadState)state);
                for (int b = 0; b < 15; ++b) {
                    if (state.buttons(b) == 0) continue;
                    selectedGamepad = i;
                    continue block0;
                }
            }
            if (selectedGamepad < 0 && uniqueGamepadID >= 0) {
                selectedGamepad = uniqueGamepadID;
            }
        }
        if (selectedGamepad < 0 || !GLFW.glfwJoystickIsGamepad((int)selectedGamepad)) {
            GamepadInputs.Empty();
            selectedGamepad = -1;
        } else {
            GLFW.glfwGetGamepadState((int)selectedGamepad, (GLFWGamepadState)state);
            GamepadInputs.Fill();
        }
    }

    public static int GetGamepadIndex() {
        return selectedGamepad;
    }

    public static boolean HasGamepad() {
        return selectedGamepad >= 0;
    }

    public static void SearchGamepad() {
        selectedGamepad = -1;
    }

    public static boolean GetButton(int button) {
        return buttons[button];
    }

    public static float GetAxis(int axis) {
        return GamepadInputs.axis[axis];
    }

    private static void CheckState() {
        if (state == null) {
            state = GLFWGamepadState.create();
        }
    }

    public static void Empty() {
        int i;
        for (i = 0; i < buttons.length; ++i) {
            GamepadInputs.buttons[i] = false;
        }
        for (i = 0; i < axis.length; ++i) {
            GamepadInputs.axis[i] = i < 4 ? 0.0f : -1.0f;
        }
    }

    private static void Fill() {
        int i;
        for (i = 0; i < buttons.length; ++i) {
            GamepadInputs.buttons[i] = state.buttons(i) != 0;
        }
        for (i = 0; i < axis.length; ++i) {
            GamepadInputs.axis[i] = state.axes(i);
        }
    }

    public static final Component GetButtonName(int index) {
        if (index < 4) {
            switch ((ModClientConfig.ControllerLayoutType)((Object)ModClientConfig.CONTROLLER_LAYOUT_TYPE.get())) {
                case NINTENDO: {
                    return CreateTweakedControllers.translateDirect("gui_gamepad_button_" + (index ^ 1), new Object[0]);
                }
                case PLAYSTATION: {
                    return CreateTweakedControllers.translateDirect("gui_gamepad_button_playstation_" + index, new Object[0]);
                }
            }
            return CreateTweakedControllers.translateDirect("gui_gamepad_button_" + index, new Object[0]);
        }
        return CreateTweakedControllers.translateDirect("gui_gamepad_button_" + index, new Object[0]);
    }

    public static final Component GetAxisName(int index) {
        return CreateTweakedControllers.translateDirect("gui_gamepad_axis_" + index, new Object[0]);
    }
}

