/*
 * Decompiled with CFR 0.152.
 */
package com.getitemfromblock.create_tweaked_controllers.gui;

import com.getitemfromblock.create_tweaked_controllers.CreateTweakedControllers;
import com.getitemfromblock.create_tweaked_controllers.config.ModClientConfig;
import com.getitemfromblock.create_tweaked_controllers.controller.TweakedControlsUtil;
import com.getitemfromblock.create_tweaked_controllers.controller.TweakedLinkedControllerMenu;
import com.getitemfromblock.create_tweaked_controllers.gui.DigitIcon;
import com.getitemfromblock.create_tweaked_controllers.gui.DigitIconRenderer;
import com.getitemfromblock.create_tweaked_controllers.gui.JoystickIcon;
import com.getitemfromblock.create_tweaked_controllers.gui.ModGuiTextures;
import com.getitemfromblock.create_tweaked_controllers.gui.ModIcons;
import com.getitemfromblock.create_tweaked_controllers.input.GamepadInputs;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.ScreenElement;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;

public class TweakedLinkedControllerScreen
extends AbstractSimiContainerScreen<TweakedLinkedControllerMenu> {
    protected ModGuiTextures background0;
    protected ModGuiTextures background1;
    private List<Rect2i> extraAreas = Collections.emptyList();
    private IconButton resetButton;
    private IconButton confirmButton;
    private IconButton refreshButton;
    private IconButton firstTabButton;
    private IconButton secondTabButton;
    private JoystickIcon lStick;
    private JoystickIcon rStick;
    private DigitIcon[] controllerDigits;
    private DigitIcon[] axisDigits;
    private boolean isSecondPage = false;
    private static final int[] axisDigitPositions = new int[]{19, 54, 19, 64, 19, 117, 19, 127, 162, 53, 162, 116};

    public TweakedLinkedControllerScreen(TweakedLinkedControllerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.background0 = ModGuiTextures.TWEAKED_LINKED_CONTROLLER_0;
        this.background1 = ModGuiTextures.TWEAKED_LINKED_CONTROLLER_1;
    }

    protected void m_7856_() {
        int i;
        this.setWindowSize(this.background0.width, this.background0.height + 4 + AllGuiTextures.PLAYER_INVENTORY.height);
        this.setWindowOffset(1, 0);
        super.m_7856_();
        int x = this.f_97735_;
        int y = this.f_97736_;
        this.resetButton = new IconButton(x + this.background0.width - 62, y + this.background0.height - 24, (ScreenElement)AllIcons.I_TRASH);
        this.resetButton.withCallback(() -> {
            ((TweakedLinkedControllerMenu)this.f_97732_).clearContents();
            ((TweakedLinkedControllerMenu)this.f_97732_).sendClearPacket();
        });
        this.confirmButton = new IconButton(x + this.background0.width - 33, y + this.background0.height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.f_96541_.f_91074_.m_6915_());
        this.refreshButton = new IconButton(x + this.background0.width - 91, y + this.background0.height - 24, (ScreenElement)AllIcons.I_REFRESH);
        this.refreshButton.withCallback(() -> GamepadInputs.SearchGamepad());
        this.refreshButton.setToolTip((Component)CreateTweakedControllers.translateDirect("gui_button_refresh", new Object[0]));
        this.firstTabButton = new IconButton(x + 17, y + this.background0.height - 27, (ScreenElement)ModIcons.I_BUTTON);
        this.firstTabButton.withCallback(() -> {
            this.isSecondPage = false;
            ((TweakedLinkedControllerMenu)this.f_97732_).SetPage(this.isSecondPage);
        });
        this.firstTabButton.setToolTip((Component)CreateTweakedControllers.translateDirect("gui_tab_button", new Object[0]));
        this.secondTabButton = new IconButton(x + 42, y + this.background0.height - 27, (ScreenElement)ModIcons.I_AXES);
        this.secondTabButton.withCallback(() -> {
            this.isSecondPage = true;
            ((TweakedLinkedControllerMenu)this.f_97732_).SetPage(this.isSecondPage);
        });
        this.secondTabButton.setToolTip((Component)CreateTweakedControllers.translateDirect("gui_tab_axis", new Object[0]));
        this.lStick = new JoystickIcon(x + 16, y + 26, ModIcons.I_LEFT_JOYSTICK);
        this.rStick = new JoystickIcon(x + 16, y + 89, ModIcons.I_RIGHT_JOYSTICK);
        this.controllerDigits = new DigitIcon[2];
        for (i = 0; i < this.controllerDigits.length; ++i) {
            this.controllerDigits[i] = new DigitIcon(x + 107 + i * 6, y + 151, DigitIconRenderer.D_DASH, new Vector3f(1.0f, 0.0f, 0.0f));
            this.m_169394_((Widget)this.controllerDigits[i]);
        }
        this.axisDigits = new DigitIcon[18];
        for (i = 0; i < this.axisDigits.length; ++i) {
            this.axisDigits[i] = new DigitIcon(x + axisDigitPositions[i / 3 * 2] + i % 3 * 6, y + axisDigitPositions[i / 3 * 2 + 1], DigitIconRenderer.D_DASH, new Vector3f(1.0f, 0.0f, 0.0f));
            this.m_169394_((Widget)this.axisDigits[i]);
        }
        this.m_142416_((GuiEventListener)this.resetButton);
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.m_142416_((GuiEventListener)this.refreshButton);
        this.m_142416_((GuiEventListener)this.firstTabButton);
        this.m_142416_((GuiEventListener)this.secondTabButton);
        this.m_169394_((Widget)this.lStick);
        this.m_169394_((Widget)this.rStick);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(x + this.background0.width + 4, y + this.background0.height - 44, 64, 56));
    }

    protected void m_7286_(PoseStack ms, float partialTicks, int mouseX, int mouseY) {
        MutableComponent text;
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width);
        int invY = this.f_97736_ + this.background0.height + 4;
        this.renderPlayerInventory(ms, invX, invY);
        int x = this.f_97735_;
        int y = this.f_97736_;
        TweakedControlsUtil.Update();
        if (this.isSecondPage) {
            this.background1.render(ms, x, y, (GuiComponent)this);
            Vec2 v = new Vec2(GamepadInputs.axis[0], GamepadInputs.axis[1]);
            if (v.m_165912_() > 1.0f) {
                v = v.m_165902_();
            }
            this.lStick.move((int)(v.f_82470_ * 10.0f), (int)(v.f_82471_ * 10.0f));
            v = new Vec2(GamepadInputs.axis[2], GamepadInputs.axis[3]);
            if (v.m_165912_() > 1.0f) {
                v = v.m_165902_();
            }
            this.rStick.move((int)(v.f_82470_ * 10.0f), (int)(v.f_82471_ * 10.0f));
            this.lStick.f_93624_ = true;
            this.rStick.f_93624_ = true;
            for (int i = 0; i < 6; ++i) {
                float value;
                float f = value = i < 4 ? Math.abs(GamepadInputs.axis[i]) : (GamepadInputs.axis[i] + 1.0f) / 2.0f;
                if (value < 0.0f) {
                    value = 0.0f;
                }
                if (value > 1.0f) {
                    value = 1.0f;
                }
                int index = Math.round(value * 15.0f);
                if (i < 4 && GamepadInputs.axis[i] < 0.0f && index != 0) {
                    this.axisDigits[i * 3].setIcon(DigitIconRenderer.D_DASH);
                } else {
                    this.axisDigits[i * 3].setIcon(DigitIconRenderer.D_EMPTY);
                }
                this.axisDigits[i * 3 + 1].setIcon(DigitIconRenderer.D_NUMBERS[index / 10]);
                this.axisDigits[i * 3 + 2].setIcon(DigitIconRenderer.D_NUMBERS[index % 10]);
                for (int j = 0; j < 3; ++j) {
                    this.axisDigits[i * 3 + j].f_93624_ = true;
                }
            }
        } else {
            this.background0.render(ms, x, y, (GuiComponent)this);
            this.lStick.f_93624_ = false;
            this.rStick.f_93624_ = false;
            for (int i = 0; i < this.axisDigits.length; ++i) {
                this.axisDigits[i].f_93624_ = false;
            }
        }
        int index = GamepadInputs.GetGamepadIndex();
        if (((Boolean)ModClientConfig.USE_CUSTOM_MAPPINGS.get()).booleanValue()) {
            text = CreateTweakedControllers.translateDirect("gui_gamepad_custom", new Object[0]);
            this.controllerDigits[0].setIcon(DigitIconRenderer.D_NUMBERS[0]);
            this.controllerDigits[1].setIcon(DigitIconRenderer.D_NUMBERS[0]);
        } else if (index < 0) {
            text = CreateTweakedControllers.translateDirect("gui_gamepad_unavailable", new Object[0]);
            this.controllerDigits[0].setIcon(DigitIconRenderer.D_DASH);
            this.controllerDigits[1].setIcon(DigitIconRenderer.D_DASH);
        } else {
            text = CreateTweakedControllers.translateDirect("gui_gamepad_selected", "" + index);
            this.controllerDigits[0].setIcon(DigitIconRenderer.D_NUMBERS[index / 10]);
            this.controllerDigits[1].setIcon(DigitIconRenderer.D_NUMBERS[index % 10]);
        }
        this.controllerDigits[0].setToolTip((Component)text);
        this.controllerDigits[1].setToolTip((Component)text);
        this.f_96547_.m_92889_(ms, this.f_96539_, (float)(x + 15), (float)(y + 4), 0xFFFFFF);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((ItemStack)((ItemStack)((TweakedLinkedControllerMenu)this.f_97732_).contentHolder)).at((float)(x + this.background0.width - 4), (float)(y + this.background0.height - 56), -200.0f)).scale(5.0).render(ms);
    }

    protected void m_181908_() {
        if (!((TweakedLinkedControllerMenu)this.f_97732_).player.m_21205_().equals((ItemStack)((TweakedLinkedControllerMenu)this.f_97732_).contentHolder, false)) {
            ((TweakedLinkedControllerMenu)this.f_97732_).player.m_6915_();
        }
        super.m_181908_();
    }

    protected void m_7025_(PoseStack ms, int x, int y) {
        if (!((TweakedLinkedControllerMenu)this.f_97732_).m_142621_().m_41619_() || this.f_97734_ == null || this.f_97734_.m_6657_() || this.f_97734_.f_40218_ == ((TweakedLinkedControllerMenu)this.f_97732_).playerInventory) {
            super.m_7025_(ms, x, y);
            return;
        }
        this.renderComponentTooltip(ms, this.addToTooltip(new LinkedList<Component>(), this.f_97734_.getSlotIndex()), x, y, this.f_96547_);
    }

    public List<Component> m_96555_(ItemStack stack) {
        List<Component> list = super.m_96555_(stack);
        if (this.f_97734_.f_40218_ == ((TweakedLinkedControllerMenu)this.f_97732_).playerInventory) {
            return list;
        }
        return this.f_97734_ != null ? this.addToTooltip(list, this.f_97734_.getSlotIndex()) : list;
    }

    private List<Component> addToTooltip(List<Component> list, int slot) {
        if (slot < 0 || slot >= 50) {
            return list;
        }
        if (slot >= 30) {
            list.add((Component)CreateTweakedControllers.translateDirect("tweaked_linked_controller.frequency_slot_" + (slot % 2 + 1), GamepadInputs.GetAxisName((slot - 30) / 2)).m_130940_(ChatFormatting.GOLD));
        } else {
            list.add((Component)CreateTweakedControllers.translateDirect("tweaked_linked_controller.frequency_slot_" + (slot % 2 + 1), GamepadInputs.GetButtonName(slot / 2)).m_130940_(ChatFormatting.GOLD));
        }
        return list;
    }

    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

