/*
 * Decompiled with CFR 0.152.
 */
package com.getitemfromblock.create_tweaked_controllers.controller;

import com.getitemfromblock.create_tweaked_controllers.CreateTweakedControllers;
import com.getitemfromblock.create_tweaked_controllers.input.GenericInput;
import com.getitemfromblock.create_tweaked_controllers.input.JoystickAxisInput;
import com.getitemfromblock.create_tweaked_controllers.input.JoystickButtonInput;
import com.getitemfromblock.create_tweaked_controllers.input.KeyboardInput;
import com.getitemfromblock.create_tweaked_controllers.input.MouseAxisInput;
import com.getitemfromblock.create_tweaked_controllers.input.MouseButtonInput;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;

public class ControlProfile {
    public GenericInput[] layout = new GenericInput[25];
    public boolean hasJoystickInput = false;
    public ArrayList<KeyMapping> duplicatedKeys = new ArrayList();
    static final int[] keys = new int[]{59, 80, 76, 79, 85, 73, 82, 89, 84, 72, 74, 265, 262, 264, 263};

    public ControlProfile() {
        this(0);
    }

    public ControlProfile(int id) {
        this.Load(0);
        this.Save(0);
    }

    public void Load(int id) {
        this.Load("config/gamepad_profiles/gamepad_profile_" + id);
        this.UpdateProfileData();
    }

    public void Save(int id) {
        this.Save("config/gamepad_profiles/gamepad_profile_" + id);
    }

    public void InitDefaultLayout() {
        int i;
        for (i = 0; i < 15; ++i) {
            this.layout[i] = i == 9 || i == 10 ? new MouseButtonInput(i - 9) : new KeyboardInput(keys[i]);
        }
        for (i = 15; i < 25; ++i) {
            if (i == 16 || i == 18 || i == 20 || i == 22) {
                if (i > 18) {
                    this.layout[i] = new MouseAxisInput(i == 22, 0.0f, -1000.0f, false);
                    continue;
                }
                this.layout[i] = new KeyboardInput(i == 16 ? 65 : 87);
                continue;
            }
            this.layout[i] = i > 22 ? new KeyboardInput(i == 23 ? 66 : 78) : (i > 18 ? new MouseAxisInput(i == 21, 0.0f, 1000.0f, false) : new KeyboardInput(i == 15 ? 68 : 83));
        }
    }

    public void Load(String path) {
        File f = new File(path);
        if (!f.exists() || f.isDirectory()) {
            this.InitDefaultLayout();
            return;
        }
        try {
            FileInputStream file = new FileInputStream(f);
            DataInputStream buf = new DataInputStream(file);
            for (int i = 0; i < this.layout.length; ++i) {
                switch (GenericInput.InputType.GetType(buf.readByte())) {
                    case NONE: {
                        this.layout[i] = null;
                        break;
                    }
                    case JOYSTICK_BUTTON: {
                        this.layout[i] = new JoystickButtonInput();
                        break;
                    }
                    case JOYSTICK_AXIS: {
                        this.layout[i] = new JoystickAxisInput();
                        break;
                    }
                    case MOUSE_BUTTON: {
                        this.layout[i] = new MouseButtonInput();
                        break;
                    }
                    case MOUSE_AXIS: {
                        this.layout[i] = new MouseAxisInput();
                        break;
                    }
                    case KEYBOARD_KEY: {
                        this.layout[i] = new KeyboardInput();
                        break;
                    }
                    default: {
                        throw new IOException("Corrupted Profile Data!");
                    }
                }
                if (this.layout[i] == null) continue;
                this.layout[i].Deserialize(buf);
            }
            file.close();
        }
        catch (IOException e) {
            CreateTweakedControllers.log("Error loading controller profile \"" + path + "\"!");
            for (StackTraceElement line : e.getStackTrace()) {
                CreateTweakedControllers.log(line.toString());
            }
            return;
        }
    }

    public void Save(String path) {
        try {
            File f = new File(path);
            File p = f.getParentFile();
            if (!p.exists()) {
                p.mkdirs();
            }
            f.createNewFile();
            FileOutputStream file = new FileOutputStream(f);
            DataOutputStream buf = new DataOutputStream(file);
            for (int i = 0; i < this.layout.length; ++i) {
                if (this.layout[i] != null) {
                    buf.writeByte(GenericInput.InputType.GetValue(this.layout[i].GetType()));
                    this.layout[i].Serialize(buf);
                    continue;
                }
                buf.writeByte(GenericInput.InputType.GetValue(GenericInput.InputType.NONE));
            }
            file.close();
        }
        catch (IOException e) {
            CreateTweakedControllers.log("Error loading controller profile \"" + path + "\"!");
            for (StackTraceElement line : e.getStackTrace()) {
                CreateTweakedControllers.log(line.toString());
            }
            return;
        }
    }

    protected int GetUniqueKeyIndex(InputConstants.Key k) {
        switch (k.m_84868_()) {
            case MOUSE: {
                return k.m_84873_();
            }
            case KEYSYM: {
                return k.m_84873_() + 512;
            }
        }
        return k.m_84873_() + 1024;
    }

    protected int GetUniqueKeyIndex(GenericInput i) {
        switch (i.GetType()) {
            case MOUSE_BUTTON: {
                return i.GetValue();
            }
            case MOUSE_AXIS: {
                return i.GetValue() + 60;
            }
            case KEYBOARD_KEY: {
                return i.GetValue() + 512;
            }
            case JOYSTICK_AXIS: {
                return i.GetValue() + 64;
            }
        }
        return i.GetValue() + 128;
    }

    public void UpdateProfileData() {
        this.duplicatedKeys.clear();
        this.hasJoystickInput = false;
        for (int i = 0; i < 25; ++i) {
            if (this.layout[i] == null || this.layout[i].GetType() != GenericInput.InputType.JOYSTICK_AXIS && this.layout[i].GetType() != GenericInput.InputType.JOYSTICK_BUTTON) continue;
            this.hasJoystickInput = true;
            break;
        }
        for (KeyMapping key : Minecraft.m_91087_().f_91066_.f_92059_) {
            if (key.m_90862_()) continue;
            int id = this.GetUniqueKeyIndex(key.getKey());
            for (int i = 0; i < 25; ++i) {
                if (this.layout[i] == null || !this.layout[i].IsInputValid() || id != this.GetUniqueKeyIndex(this.layout[i])) continue;
                this.duplicatedKeys.add(key);
            }
        }
    }

    public boolean GetButton(int id) {
        return this.layout[id] != null ? this.layout[id].GetButtonValue() : false;
    }

    public float GetAxis(int id) {
        if (id < 4) {
            return (this.layout[15 + id * 2] != null ? this.layout[15 + id * 2].GetAxisValue() : 0.0f) - (this.layout[16 + id * 2] != null ? this.layout[16 + id * 2].GetAxisValue() : 0.0f);
        }
        return this.layout[id + 19] != null ? this.layout[id + 19].GetAxisValue() * 2.0f - 1.0f : -1.0f;
    }
}

