/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.items;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.zeith.solarflux.block.SolarPanelTile;
import org.zeith.solarflux.items.UpgradeItem;
import org.zeith.solarflux.util.BlockPosFace;

public class ItemTraversalUpgrade
extends UpgradeItem {
    static List<BlockPos> cache = new ArrayList<BlockPos>();
    private static final Direction[] DIRECTIONS = Direction.values();

    public ItemTraversalUpgrade() {
        super(1);
        this.setRegistryName("traversal_upgrade");
    }

    @Override
    public void update(SolarPanelTile tile, ItemStack stack, int amount) {
        if (tile.m_58904_().m_46468_() % 20L == 0L) {
            cache.clear();
            tile.traversal.clear();
            cache.add(tile.m_58899_());
            ItemTraversalUpgrade.findMachines(tile, cache, tile.traversal);
        }
    }

    public static void findMachines(SolarPanelTile tile, List<BlockPos> cache, List<BlockPosFace> acceptors) {
        for (int i = 0; i < cache.size(); ++i) {
            BlockPos pos = cache.get(i);
            for (Direction face : DIRECTIONS) {
                BlockEntity t;
                BlockPos p = pos.m_142300_(face);
                if (p.m_123331_((Vec3i)cache.get(0)) > 25.0 || (t = tile.m_58904_().m_7702_(p)) == null) continue;
                t.getCapability(CapabilityEnergy.ENERGY, face.m_122424_()).filter(IEnergyStorage::canReceive).ifPresent(e -> {
                    if (!cache.contains(p)) {
                        cache.add(p);
                        BlockPosFace bpf = new BlockPosFace(p, face.m_122424_());
                        acceptors.add(bpf);
                    }
                });
            }
        }
    }
}

