/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.zeith.hammerlib.client.screen.ScreenWTFMojang;
import org.zeith.hammerlib.client.utils.FXUtils;
import org.zeith.hammerlib.client.utils.RenderUtils;
import org.zeith.solarflux.block.SolarPanelTile;
import org.zeith.solarflux.container.SolarPanelContainer;
import org.zeith.solarflux.util.ComplexProgressManager;

public class SolarPanelScreen
extends ScreenWTFMojang<SolarPanelContainer> {
    private static final ResourceLocation ELEMENTS = new ResourceLocation("solarflux", "textures/gui/elements.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("solarflux", "textures/gui/solar.png");
    private static final int GAUGE_WIDTH = 18;
    private static final int GAUGE_HEIGHT = 50;
    private static final int GAUGE_INNER_WIDTH = 16;
    private static final int GAUGE_INNER_HEIGHT = 48;
    private static final int GAUGE_INNER_OFFSET_X = 1;
    private static final int GAUGE_INNER_OFFSET_Y = 1;
    private static final int GAUGE_SRC_X = 64;
    private static final int GAUGE_SRC_Y = 62;
    private static final int GAUGE_INNER_SRC_X = 0;
    private static final int GAUGE_INNER_SRC_Y = 64;
    private static final int BORDER_OFFSET = 8;
    public final SolarPanelTile solar;
    private final Inventory pinv;
    public final ComplexProgressManager data;
    private final List<FormattedCharSequence> tooltip = Lists.newArrayList();
    long energy;
    long capacity;
    long currentGeneration;
    long generation;
    float sunIntensity;

    public SolarPanelScreen(SolarPanelContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.data = screenContainer.progressHandler;
        this.pinv = inv;
        this.solar = screenContainer.panel;
        this.f_97726_ = 176;
        this.f_97727_ = 180;
    }

    public void m_181908_() {
        this.energy = this.data.getLong(0);
        this.capacity = this.data.getLong(8);
        this.currentGeneration = this.data.getLong(16);
        this.generation = this.data.getLong(24);
        this.sunIntensity = this.data.getFloat(32);
        super.m_181908_();
    }

    protected boolean renderForeground(PoseStack pose, int mouseX, int mouseY) {
        pose.m_85836_();
        this.f_96547_.m_92883_(pose, this.pinv.m_7755_().getString(), 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
        this.f_96547_.m_92889_(pose, (Component)this.solar.m_58900_().m_60734_().m_49954_(), 8.0f, 4.0f, 0x404040);
        pose.m_85837_(8.0, 14.0, 0.0);
        pose.m_85841_(0.9f, 0.9f, 0.9f);
        this.f_96547_.m_92883_(pose, I18n.m_118938_((String)"info.solarflux.energy.stored1", (Object[])new Object[]{this.energy}), 0.0f, 0.0f, 0x404040);
        this.f_96547_.m_92883_(pose, I18n.m_118938_((String)"info.solarflux.energy.capacity", (Object[])new Object[]{this.capacity}), 0.0f, 10.0f, 0x404040);
        this.f_96547_.m_92883_(pose, I18n.m_118938_((String)"info.solarflux.energy.generation", (Object[])new Object[]{this.currentGeneration}), 0.0f, 20.0f, 0x404040);
        this.f_96547_.m_92883_(pose, I18n.m_118938_((String)"info.solarflux.energy.efficiency", (Object[])new Object[]{this.generation > 0L ? Math.round(100.0 * (double)this.currentGeneration / (double)this.generation) : 0L}), 0.0f, 30.0f, 0x404040);
        pose.m_85849_();
        int x = this.f_97726_ - 18 - 8;
        int y = 40;
        boolean hover = this.inBounds(x + this.f_97735_, y + this.f_97736_, 18, 50, mouseX, mouseY);
        if (hover) {
            RenderSystem.m_69472_();
            this.m_93179_(pose, x + 1, y + 1, x + 18 - 1, y + 50 - 1, -1996488705, -1996488705);
            RenderSystem.m_69493_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            FXUtils.bindTexture((ResourceLocation)ELEMENTS);
            this.drawTMR(pose, x, y, 82.0f, 62.0f, 18.0f, 50.0f);
            if (((SolarPanelContainer)this.f_97732_).m_142621_().m_41619_()) {
                this.drawMouseOver(I18n.m_118938_((String)"info.solarflux.energy.stored2", (Object[])new Object[]{this.energy, this.capacity}));
            }
        }
        if (hover = this.inBounds((x = this.f_97726_ - 36 - 8 - 4) + this.f_97735_, (y = 40) + this.f_97736_, 18, 50, mouseX, mouseY)) {
            RenderSystem.m_69472_();
            this.m_93179_(pose, x + 1, y + 1, x + 18 - 1, y + 50 - 1, -1996488705, -1996488705);
            RenderSystem.m_69493_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            FXUtils.bindTexture((ResourceLocation)ELEMENTS);
            this.drawTMR(pose, x, y, 82.0f, 62.0f, 18.0f, 50.0f);
            if (((SolarPanelContainer)this.f_97732_).m_142621_().m_41619_()) {
                this.drawMouseOver(I18n.m_118938_((String)"info.solarflux.sun.intensity", (Object[])new Object[]{Math.round(100.0f * this.sunIntensity)}));
            }
        }
        return true;
    }

    protected void renderBackground(PoseStack pose, float partialTime, int mouseX, int mouseY) {
        int xStart = (this.f_96543_ - this.f_97726_) / 2;
        int yStart = (this.f_96544_ - this.f_97727_) / 2;
        FXUtils.bindTexture((ResourceLocation)TEXTURE);
        this.drawTMR(pose, xStart, yStart, 0.0f, 0.0f, this.f_97726_, this.f_97727_);
        FXUtils.bindTexture((ResourceLocation)ELEMENTS);
        this.drawPower(pose, xStart + this.f_97726_ - 18 - 8, yStart + 8 + 32, mouseX, mouseY);
        this.drawSun(pose, xStart + this.f_97726_ - 36 - 8 - 4, yStart + 8 + 32, mouseX, mouseY);
        for (int i = 0; i < this.solar.upgradeInventory.getSlots(); ++i) {
            this.drawTMR(pose, xStart + i * 18 + 8, yStart + 60, 18.0f, 0.0f, 18.0f, 18.0f);
        }
        this.drawTMR(pose, xStart + 150, yStart + 8, 18.0f, 18.0f, 18.0f, 18.0f);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.tooltip.clear();
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.m_96617_(pose, this.tooltip, mouseX, mouseY);
    }

    private void drawPower(PoseStack mstack, int x, int y, int mx, int my) {
        this.drawTMR(mstack, x + 1, y + 1, 16.0f, 64.0f, 16.0f, 48.0f);
        float height = (float)this.energy * 48.0f / (float)this.capacity;
        float offset = 48.0f - height;
        this.drawTMR(mstack, x + 1, (float)(y + 1) + offset, 0.0f, 64.0f + offset, 16.0f, height);
        this.drawTMR(mstack, x, y, 64.0f, 62.0f, 18.0f, 50.0f);
    }

    private void drawSun(PoseStack mstack, int x, int y, int mouseX, int mouseY) {
        this.drawTMR(mstack, x + 1, y + 1, 48.0f, 64.0f, 16.0f, 48.0f);
        float height = 48.0f * this.sunIntensity;
        float offset = 48.0f - height;
        this.drawTMR(mstack, x + 1, (float)(y + 1) + offset, 32.0f, 64.0f + offset, 16.0f, height);
        this.drawTMR(mstack, x, y, 64.0f, 62.0f, 18.0f, 50.0f);
    }

    public void drawTMR(PoseStack pose, float x, float y, float textureX, float textureY, float width, float height) {
        RenderUtils.drawTexturedModalRect((PoseStack)pose, (float)x, (float)y, (float)textureX, (float)textureY, (float)width, (float)height);
    }

    public boolean inBounds(int x, int y, int w, int h, int mx, int my) {
        return mx >= x && mx < x + w && my >= y && my <= y + h;
    }

    public void drawMouseOver(String line) {
        if (line != null) {
            Arrays.stream(line.split("\n")).map(TextComponent::new).map(BaseComponent::m_7532_).forEach(this.tooltip::add);
        }
    }
}

