/*
 * Decompiled with CFR 0.152.
 */
package com.dugkse.moderntrainparts.content.containers;

import com.dugkse.moderntrainparts.config.ModernTrainPartsServerConfig;
import com.dugkse.moderntrainparts.content.containers.ContainerWall;
import com.dugkse.moderntrainparts.init.MTPBlockEntitiesInit;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class ItemContainerTileEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Inventory {
    protected LazyOptional<IItemHandler> itemCapability;
    protected ItemStackHandler inventory = new ItemStackHandler((Integer)ModernTrainPartsServerConfig.CONTAINER_CAPACITY.get()){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ItemContainerTileEntity.this.updateComparators();
        }
    };
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity;
    protected int radius = 1;
    protected int length = 1;
    protected Direction.Axis axis;

    public ItemContainerTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.itemCapability = LazyOptional.empty();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    protected void updateComparators() {
        ItemContainerTileEntity controllerTE = this.getControllerBE();
        if (controllerTE == null) {
            return;
        }
        BlockPos pos = controllerTE.m_58899_();
        for (int y = 0; y < controllerTE.radius; ++y) {
            for (int z = 0; z < (controllerTE.axis == Direction.Axis.X ? controllerTE.radius : controllerTE.length); ++z) {
                for (int x = 0; x < (controllerTE.axis == Direction.Axis.Z ? controllerTE.radius : controllerTE.length); ++x) {
                    this.f_58857_.m_46717_(pos.m_142082_(x, y, z), this.m_58900_().m_60734_());
                }
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    public ItemContainerTileEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity tileEntity = this.f_58857_.m_7702_(this.controller);
        if (tileEntity instanceof ItemContainerTileEntity) {
            return (ItemContainerTileEntity)tileEntity;
        }
        return null;
    }

    public void removeController(boolean keepContents) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.updateConnectivity = true;
        this.controller = null;
        this.radius = 1;
        this.length = 1;
        BlockState state = this.m_58900_();
        if (ContainerWall.isContainer(state)) {
            this.m_58904_().m_7731_(this.f_58858_, state, 22);
        }
        this.itemCapability.invalidate();
        this.m_6596_();
        this.sendData();
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.itemCapability.invalidate();
        this.m_6596_();
        this.sendData();
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.radius;
        int prevLength = this.length;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.radius = compound.m_128451_("Size");
            this.length = compound.m_128451_("Length");
        }
        if (!clientPacket) {
            this.inventory.deserializeNBT(compound.m_128469_("Inventory"));
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (this.m_58898_() && (changeOfController || prevSize != this.radius || prevLength != this.length)) {
            this.f_58857_.m_6550_(this.m_58899_(), Blocks.f_50016_.m_49966_(), this.m_58900_());
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128405_("Size", this.radius);
            compound.m_128405_("Length", this.length);
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            compound.m_128359_("StorageType", "CombinedInv");
            compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        }
    }

    public ItemStackHandler getInventoryOfBlock() {
        return this.inventory;
    }

    public void applyInventoryToBlock(ItemStackHandler handler) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, i < handler.getSlots() ? handler.getStackInSlot(i) : ItemStack.f_41583_);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            this.initCapability();
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    private void initCapability() {
        if (this.itemCapability.isPresent()) {
            return;
        }
        if (!this.isController()) {
            ItemContainerTileEntity controllerTE = this.getControllerBE();
            if (controllerTE == null) {
                return;
            }
            controllerTE.initCapability();
            this.itemCapability = controllerTE.itemCapability;
            return;
        }
        boolean alongZ = ContainerWall.getContainerBlockAxis(this.m_58900_()) == Direction.Axis.Z;
        IItemHandlerModifiable[] invs = new IItemHandlerModifiable[this.length * this.radius * this.radius];
        for (int yOffset = 0; yOffset < this.length; ++yOffset) {
            for (int xOffset = 0; xOffset < this.radius; ++xOffset) {
                for (int zOffset = 0; zOffset < this.radius; ++zOffset) {
                    BlockPos vaultPos = alongZ ? this.f_58858_.m_142082_(xOffset, zOffset, yOffset) : this.f_58858_.m_142082_(yOffset, xOffset, zOffset);
                    ItemContainerTileEntity vaultAt = (ItemContainerTileEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)MTPBlockEntitiesInit.CONTAINER_ENTITY.get()), (BlockGetter)this.f_58857_, (BlockPos)vaultPos);
                    invs[yOffset * this.radius * this.radius + xOffset * this.radius + zOffset] = vaultAt != null ? vaultAt.getInventoryOfBlock() : new ItemStackHandler();
                }
            }
        }
        CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(invs);
        this.itemCapability = LazyOptional.of(() -> combinedInvWrapper);
    }

    public static int getMaxLength(int radius) {
        return 16;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (ContainerWall.isContainer(state)) {
            this.f_58857_.m_7731_(this.m_58899_(), state, 6);
        }
        this.itemCapability.invalidate();
        this.m_6596_();
    }

    public Direction.Axis getMainConnectionAxis() {
        return this.getMainAxisOf((BlockEntity)this);
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return this.getMaxWidth();
        }
        return ItemContainerTileEntity.getMaxLength(width);
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.length;
    }

    public int getWidth() {
        return this.radius;
    }

    public void setHeight(int height) {
        this.length = height;
    }

    public void setWidth(int width) {
        this.radius = width;
    }

    public boolean hasInventory() {
        return true;
    }

    public void destroy() {
    }

    public void dropContents(Level world, BlockPos pos) {
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.inventory.getStackInSlot(slot));
        }
    }
}

