/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.block;

import java.util.Random;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.block.IQuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.world.module.BlossomTreesModule;

public class BlossomLeavesBlock
extends LeavesBlock
implements IQuarkBlock {
    private final QuarkModule module;
    private BooleanSupplier enabledSupplier = () -> true;

    public BlossomLeavesBlock(String colorName, QuarkModule module, MaterialColor color) {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76274_, (MaterialColor)color).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_((s, r, p, t) -> false).m_60960_((s, r, p) -> false).m_60971_((s, r, p) -> false));
        this.module = module;
        RegistryHelper.registerBlock((Block)this, (String)(colorName + "_blossom_leaves"));
        RegistryHelper.setCreativeTab((Block)this, (CreativeModeTab)CreativeModeTab.f_40750_);
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT_MIPPED);
    }

    public void m_7100_(@Nonnull BlockState stateIn, Level worldIn, BlockPos pos, @Nonnull Random rand) {
        if (worldIn.m_46859_(pos.m_7495_()) && rand.nextInt(5) == 0 && BlossomTreesModule.dropLeafParticles) {
            double windStrength = 5.0 + Math.cos((double)worldIn.m_46467_() / 2000.0) * 2.0;
            double windX = Math.cos((double)worldIn.m_46467_() / 1200.0) * windStrength;
            double windZ = Math.sin((double)worldIn.m_46467_() / 1000.0) * windStrength;
            worldIn.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, stateIn), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, windX, -1.0, windZ);
        }
    }

    @Override
    @Nullable
    public QuarkModule getModule() {
        return this.module;
    }

    @Override
    public BlossomLeavesBlock setCondition(BooleanSupplier enabledSupplier) {
        this.enabledSupplier = enabledSupplier;
        return this;
    }

    @Override
    public boolean doesConditionApply() {
        return this.enabledSupplier.getAsBoolean();
    }
}

