/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import java.util.Arrays;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.content.world.block.CorundumClusterBlock;
import vazkii.quark.content.world.module.CorundumModule;

@LoadModule(category=ModuleCategory.TOOLS)
public class BeaconRedirectionModule
extends QuarkModule {
    public static boolean staticEnabled;

    @Override
    public void configChanged() {
        staticEnabled = this.enabled;
    }

    public static int tickBeacon(BeaconBlockEntity beacon) {
        BlockPos beaconPos;
        if (!staticEnabled) {
            return 0;
        }
        Level world = beacon.m_58904_();
        BlockPos currPos = beaconPos = beacon.m_58899_();
        int horizontalMoves = 64;
        int targetHeight = world.m_6924_(Heightmap.Types.WORLD_SURFACE, beaconPos.m_123341_(), beaconPos.m_123343_());
        beacon.f_58649_.clear();
        boolean broke = false;
        float[] currColor = new float[]{1.0f, 1.0f, 1.0f};
        ExtendedBeamSegment currSegment = new ExtendedBeamSegment(Direction.UP, Vec3i.f_123288_, currColor);
        LinkedList<BlockPos> seenPositions = new LinkedList<BlockPos>();
        boolean check = true;
        boolean setColor = false;
        while (world.m_46739_(currPos) && horizontalMoves > 0) {
            currPos = currPos.m_142300_(currSegment.dir);
            if (currSegment.dir.m_122434_().m_122479_()) {
                --horizontalMoves;
            }
            BlockState blockstate = world.m_8055_(currPos);
            Block block = blockstate.m_60734_();
            float[] targetColor = blockstate.getBeaconColorMultiplier((LevelReader)world, currPos, beaconPos);
            if (BeaconRedirectionModule.isValidBlock(block)) {
                Direction dir = (Direction)blockstate.m_61143_((Property)BlockStateProperties.f_61372_);
                if (dir == currSegment.dir) {
                    currSegment.m_58719_();
                } else {
                    check = true;
                    beacon.f_58649_.add(currSegment);
                    targetColor = BeaconRedirectionModule.getTargetColor(block);
                    if (targetColor[0] == 1.0f && targetColor[1] == 1.0f && targetColor[2] == 1.0f) {
                        targetColor = currColor;
                    }
                    float[] mixedColor = new float[]{(currColor[0] + targetColor[0] * 3.0f) / 4.0f, (currColor[1] + targetColor[1] * 3.0f) / 4.0f, (currColor[2] + targetColor[2] * 3.0f) / 4.0f};
                    currColor = mixedColor;
                    currSegment = new ExtendedBeamSegment(dir, (Vec3i)currPos.m_141950_((Vec3i)beaconPos), currColor);
                }
            } else if (targetColor != null) {
                if (Arrays.equals(targetColor, currColor)) {
                    currSegment.m_58719_();
                } else {
                    check = true;
                    beacon.f_58649_.add(currSegment);
                    float[] mixedColor = new float[]{(currColor[0] + targetColor[0]) / 2.0f, (currColor[1] + targetColor[1]) / 2.0f, (currColor[2] + targetColor[2]) / 2.0f};
                    if (!setColor) {
                        mixedColor = targetColor;
                        setColor = true;
                    }
                    currColor = mixedColor;
                    currSegment = new ExtendedBeamSegment(currSegment.dir, (Vec3i)currPos.m_141950_((Vec3i)beaconPos), mixedColor);
                }
            } else {
                if (block == Blocks.f_50752_) continue;
                if (blockstate.m_60739_((BlockGetter)world, currPos) >= 15) {
                    broke = true;
                    break;
                }
                currSegment.m_58719_();
            }
            if (!check) continue;
            if (seenPositions.contains(currPos)) {
                broke = true;
                break;
            }
            seenPositions.add(currPos);
        }
        if (horizontalMoves == 0 || currPos.m_123342_() <= 0) {
            broke = true;
        }
        if (!broke) {
            beacon.f_58649_.add(currSegment);
            beacon.f_58651_ = targetHeight + 1;
        } else {
            beacon.f_58649_.clear();
            beacon.f_58651_ = targetHeight;
        }
        return Integer.MAX_VALUE;
    }

    private static boolean isValidBlock(Block block) {
        return CorundumModule.staticEnabled ? block instanceof CorundumClusterBlock : block == Blocks.f_152492_;
    }

    private static float[] getTargetColor(Block block) {
        float[] fArray;
        if (block instanceof CorundumClusterBlock) {
            fArray = ((CorundumClusterBlock)block).base.colorComponents;
        } else {
            float[] fArray2 = new float[3];
            fArray2[0] = 1.0f;
            fArray2[1] = 1.0f;
            fArray = fArray2;
            fArray2[2] = 1.0f;
        }
        return fArray;
    }

    public static class ExtendedBeamSegment
    extends BeaconBlockEntity.BeaconBeamSection {
        public final Direction dir;
        public final Vec3i offset;
        private boolean isTurn = false;

        public ExtendedBeamSegment(Direction dir, Vec3i offset, float[] colorsIn) {
            super(colorsIn);
            this.offset = offset;
            this.dir = dir;
        }

        public void makeTurn() {
            this.isTurn = true;
        }

        public boolean isTurn() {
            return this.isTurn;
        }

        public void m_58719_() {
            super.m_58719_();
        }
    }
}

