/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world.generator;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import vazkii.quark.base.world.generator.IGenerator;

public class CombinedGenerator
implements IGenerator {
    private List<? extends IGenerator> children;

    public CombinedGenerator(List<? extends IGenerator> children) {
        this.children = children;
    }

    @Override
    public int generate(int seedIncrement, long seed, GenerationStep.Decoration stage, WorldGenRegion worldIn, ChunkGenerator generator, WorldgenRandom rand, BlockPos pos) {
        for (IGenerator iGenerator : this.children) {
            if (!iGenerator.canGenerate((ServerLevelAccessor)worldIn)) continue;
            seedIncrement = iGenerator.generate(seedIncrement, seed, stage, worldIn, generator, rand, pos);
        }
        return seedIncrement;
    }

    @Override
    public boolean canGenerate(ServerLevelAccessor world) {
        return this.children.stream().anyMatch(it -> it.canGenerate(world));
    }
}

