/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle;

import cofh.core.client.particle.LevelMatrixStackParticle;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.SplittableRandom;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.particles.SimpleParticleType;

public class WindVortexParticle
extends LevelMatrixStackParticle {
    protected static final float defaultLifetime = 8.0f;
    protected float fLifetime;
    protected int seed;
    protected float scale;
    protected float height;

    private WindVortexParticle(ClientLevel level, double xPos, double yPos, double zPos, double speed, double width, double height) {
        super(level, xPos, yPos, zPos, speed, width, height);
        this.fLifetime = 8.0f / (float)speed;
        this.f_107225_ = MathHelper.ceil(this.fLifetime * 1.2f);
        this.seed = this.f_107223_.nextInt();
        this.m_107250_((float)(width * (1.0 + this.f_107223_.nextGaussian() * (double)0.1f)), (float)height * this.f_107223_.nextFloat());
        this.f_107219_ = false;
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
        this.f_107230_ = 0.2f * (1.0f + this.f_107223_.nextFloat());
        this.f_107228_ = this.f_107229_ = 1.0f - 0.1f * this.f_107223_.nextFloat();
        this.f_107227_ = this.f_107229_;
        this.f_107204_ = this.f_107231_ = this.f_107223_.nextFloat() * ((float)Math.PI * 2);
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, int packedLight, float partialTicks) {
        SplittableRandom rand = new SplittableRandom(this.seed);
        float time = (float)this.f_107224_ + partialTicks - (float)rand.nextDouble(this.fLifetime * 0.2f);
        if (time < 0.0f || time > this.fLifetime) {
            return;
        }
        float progress = time / this.fLifetime;
        float easeSin = 1.0f - MathHelper.sin(progress * (float)Math.PI * 0.5f);
        float easePlat = MathHelper.easePlateau(progress);
        float a = this.f_107230_ * easePlat;
        float halfHeight = 0.5f * this.f_107222_;
        stack.m_85841_(this.f_107221_, halfHeight, this.f_107221_);
        stack.m_85836_();
        float hScale = easeSin + 0.5f;
        if (halfHeight > 0.0f) {
            stack.m_85837_(0.0, rand.nextDouble(-halfHeight, halfHeight), 0.0);
        }
        stack.m_85841_(hScale, 2.0f, hScale);
        stack.m_85845_(Vector3f.f_122225_.m_122270_(this.f_107231_ + progress * (float)rand.nextDouble(2.0, 3.0)));
        Vector4f[] poss = new Vector4f[rand.nextInt(10, 20)];
        for (int i = 0; i < poss.length; ++i) {
            float rot = (float)i * 0.1309f;
            float r = 0.95f + (float)i * 0.08f;
            poss[i] = new Vector4f(r * MathHelper.cos(rot), easeSin + (float)i * 0.05f, r * MathHelper.sin(rot), 1.0f);
        }
        VFXHelper.renderStreamLine(stack, buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT), packedLight, poss, VFXHelper.packRGBA(this.f_107227_, this.f_107228_, this.f_107229_, a), VFXHelper.getWidthFunc((float)rand.nextDouble(0.02f, 0.04f)));
        stack.m_85849_();
        VFXHelper.renderCyclone(stack, buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT), packedLight, 1, (float)rand.nextDouble(0.02f, 0.04f), progress * 0.5f + (float)rand.nextDouble(420.0), a);
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet sprite) {
        }

        @Nullable
        public Particle createParticle(SimpleParticleType data, ClientLevel level, double x, double y, double z, double speed, double width, double height) {
            return new WindVortexParticle(level, x, y, z, speed, width, height);
        }
    }
}

