/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle;

import cofh.core.client.particle.CustomRenderParticle;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockAndTintGetter;

public class ShockwaveParticle
extends CustomRenderParticle {
    protected float heightScale;
    protected float speed;

    private ShockwaveParticle(ClientLevel levelIn, double xCoordIn, double yCoordIn, double zCoordIn, double speed, double radius, double heightScale) {
        super(levelIn, xCoordIn, yCoordIn, zCoordIn, radius, speed, heightScale);
        this.f_107225_ = MathHelper.ceil((radius + 6.0) / speed);
        this.speed = (float)speed;
        this.m_107250_((float)radius * 2.0f, (float)heightScale);
        this.heightScale = (float)heightScale;
        this.f_107219_ = false;
        this.f_107217_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107215_ = 0.0;
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, int packedLightIn, float partialTicks) {
        VFXHelper.renderShockwave(stack, buffer, (BlockAndTintGetter)this.f_107208_, new BlockPos(this.f_107212_, this.f_107213_, this.f_107214_), ((float)this.f_107224_ + partialTicks) * this.speed, this.f_107221_ * 0.5f, this.heightScale);
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet sprite) {
        }

        @Nullable
        public Particle createParticle(SimpleParticleType data, ClientLevel level, double x, double y, double z, double speed, double radius, double heightScale) {
            return new ShockwaveParticle(level, x, y, z, speed, radius, heightScale);
        }
    }
}

