/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.goals;

import com.google.common.base.Predicate;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.GuardItems;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;

public class RangedCrossbowAttackPassiveGoal<T extends PathfinderMob & CrossbowAttackMob>
extends Goal {
    private final T entity;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private final double speed;
    private final float distanceMoveToEntity;
    private int seeTicks;
    private int timeUntilStrike;

    public RangedCrossbowAttackPassiveGoal(T entity, double p_i50322_2_, float p_i50322_4_) {
        this.entity = entity;
        this.speed = p_i50322_2_;
        this.distanceMoveToEntity = p_i50322_4_ * p_i50322_4_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.hasAttackTarget() && this.isHoldingCrossbow() && !((Guard)((Object)this.entity)).isEating();
    }

    private boolean isHoldingCrossbow() {
        return this.entity.m_21205_().m_41720_() instanceof CrossbowItem;
    }

    public boolean m_8045_() {
        return this.hasAttackTarget() && (this.m_8036_() || !this.entity.m_21573_().m_26571_()) && this.isHoldingCrossbow();
    }

    private boolean hasAttackTarget() {
        return this.entity.m_5448_() != null && this.entity.m_5448_().m_6084_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.entity.m_21561_(false);
        this.entity.m_6710_((LivingEntity)null);
        ((Guard)((Object)this.entity)).setKicking(false);
        this.seeTicks = 0;
        if (this.entity.m_20089_() == Pose.CROUCHING) {
            this.entity.m_20124_(Pose.STANDING);
        }
        if (this.entity.m_6117_()) {
            this.entity.m_5810_();
            ((CrossbowAttackMob)this.entity).m_6136_(false);
        }
    }

    public boolean checkFriendlyFire() {
        List list = ((PathfinderMob)this.entity).f_19853_.m_45976_(LivingEntity.class, this.entity.m_142469_().m_82377_(5.0, 1.0, 5.0));
        for (LivingEntity guard : list) {
            boolean isVillager;
            if (this.entity == guard && guard == this.entity || guard == this.entity.m_5448_() || !(isVillager = guard.m_6095_() == EntityType.f_20492_ || guard.m_6095_() == GuardEntityType.GUARD.get() || guard.m_6095_() == EntityType.f_20460_)) continue;
            Vec3 vector3d = this.entity.m_20154_();
            Vec3 vector3d1 = guard.m_20182_().m_82505_(this.entity.m_20182_()).m_82541_();
            vector3d1 = new Vec3(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_);
            if (!(vector3d1.m_82526_(vector3d) < 1.0) || !this.entity.m_142582_((Entity)guard)) continue;
            return GuardConfig.FriendlyFire;
        }
        return false;
    }

    public void m_8037_() {
        LivingEntity livingentity = this.entity.m_5448_();
        if (livingentity != null) {
            double d0;
            boolean flag2;
            double d1;
            boolean flag1;
            this.entity.m_21561_(true);
            boolean flag = this.entity.m_21574_().m_148306_((Entity)livingentity);
            boolean bl = flag1 = this.seeTicks > 0;
            if (flag != flag1) {
                this.seeTicks = 0;
            }
            this.seeTicks = flag ? ++this.seeTicks : --this.seeTicks;
            if (this.entity.m_20089_() == Pose.STANDING && ((PathfinderMob)this.entity).f_19853_.f_46441_.nextInt(4) == 0 && ((PathfinderMob)this.entity).f_19797_ % 50 == 0) {
                this.entity.m_20124_(Pose.CROUCHING);
            }
            if (this.entity.m_20089_() == Pose.CROUCHING && ((PathfinderMob)this.entity).f_19853_.f_46441_.nextInt(4) == 0 && ((PathfinderMob)this.entity).f_19797_ % 100 == 0) {
                this.entity.m_20124_(Pose.STANDING);
            }
            if ((d1 = (double)livingentity.m_20270_(this.entity)) <= 2.0) {
                this.entity.m_21566_().m_24988_(this.entity.m_6117_() ? -0.5f : -3.0f, 0.0f);
                this.entity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            }
            boolean bl2 = flag2 = ((d0 = this.entity.m_20280_((Entity)livingentity)) > (double)this.distanceMoveToEntity || this.seeTicks < 5) && this.timeUntilStrike == 0;
            if (flag2) {
                this.entity.m_21573_().m_5624_((Entity)livingentity, this.isCrossbowUncharged() ? this.speed : this.speed * 0.5);
            } else {
                this.entity.m_21573_().m_26573_();
            }
            this.entity.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            this.entity.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            if (this.crossbowState == CrossbowState.UNCHARGED && !CrossbowItem.m_40932_((ItemStack)this.entity.m_21211_()) && !this.entity.m_21254_()) {
                if (flag) {
                    this.entity.m_6672_(GuardItems.getHandWith(this.entity, (Predicate<Item>)((Predicate)item -> item instanceof CrossbowItem)));
                    this.crossbowState = CrossbowState.CHARGING;
                    ((CrossbowAttackMob)this.entity).m_6136_(true);
                }
            } else if (this.crossbowState == CrossbowState.CHARGING) {
                ItemStack itemstack;
                int i;
                if (!this.entity.m_6117_()) {
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
                if ((i = this.entity.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)(itemstack = this.entity.m_21211_())) || CrossbowItem.m_40932_((ItemStack)this.entity.m_21211_())) {
                    this.entity.m_21253_();
                    this.crossbowState = CrossbowState.CHARGED;
                    this.timeUntilStrike = 20 + this.entity.m_21187_().nextInt(20);
                    ((CrossbowAttackMob)this.entity).m_6136_(false);
                }
            } else if (this.crossbowState == CrossbowState.CHARGED) {
                --this.timeUntilStrike;
                if (this.timeUntilStrike == 0) {
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && flag && !this.checkFriendlyFire() && !this.entity.m_21254_()) {
                ((RangedAttackMob)this.entity).m_6504_(livingentity, 1.0f);
                ItemStack itemstack1 = this.entity.m_21120_(GuardItems.getHandWith(this.entity, (Predicate<Item>)((Predicate)item -> item instanceof CrossbowItem)));
                CrossbowItem.m_40884_((ItemStack)itemstack1, (boolean)false);
                this.crossbowState = CrossbowState.UNCHARGED;
            }
        }
    }

    private boolean isCrossbowUncharged() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

