/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.recipe;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class AbstractRouteCopyRecipe
extends CustomRecipe {
    private final Item item;

    public AbstractRouteCopyRecipe(ResourceLocation resourceLocation, Item matchingItem) {
        super(resourceLocation);
        this.item = matchingItem;
    }

    public abstract boolean stackHasNodes(ItemStack var1);

    @Nonnull
    public abstract RecipeSerializer<?> m_7707_();

    private boolean isRouteWithNodes(ItemStack stack, boolean hasNodes) {
        if (stack.m_41720_() == this.item) {
            return !this.stackHasNodes(stack) ^ hasNodes;
        }
        return false;
    }

    private Optional<Pair<ItemStack, Integer>> checkTugRoutes(CraftingContainer inventory) {
        int i = 0;
        ItemStack filledRoute = ItemStack.f_41583_;
        for (int j = 0; j < inventory.m_6643_(); ++j) {
            ItemStack stack = inventory.m_8020_(j);
            if (stack.m_41619_()) continue;
            if (this.isRouteWithNodes(stack, true)) {
                if (!filledRoute.m_41619_()) {
                    return Optional.empty();
                }
                filledRoute = stack;
                continue;
            }
            if (!this.isRouteWithNodes(stack, false)) {
                return Optional.empty();
            }
            ++i;
        }
        if (!filledRoute.m_41619_() && i <= filledRoute.m_41741_() - 1) {
            return Optional.of(new Pair((Object)filledRoute, (Object)i));
        }
        return Optional.empty();
    }

    public boolean matches(@Nonnull CraftingContainer inventory, @Nonnull Level level) {
        return this.checkTugRoutes(inventory).isPresent();
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inventory) {
        Optional<Pair<ItemStack, Integer>> matchOpt = this.checkTugRoutes(inventory);
        if (!matchOpt.isPresent()) {
            return ItemStack.f_41583_;
        }
        Pair<ItemStack, Integer> match = matchOpt.get();
        ItemStack filled = (ItemStack)match.getFirst();
        int num = (Integer)match.getSecond();
        if (num == 0) {
            return new ItemStack((ItemLike)this.item, 1);
        }
        ItemStack output = filled.m_41777_();
        output.m_41764_(num + 1);
        return output;
    }

    public boolean m_8004_(int x, int y) {
        return x * y >= 2;
    }
}

