/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.item;

import dev.murad.shipping.entity.accessor.TugRouteScreenDataAccessor;
import dev.murad.shipping.item.container.TugRouteContainer;
import dev.murad.shipping.util.LegacyTugRouteUtil;
import dev.murad.shipping.util.TugRoute;
import dev.murad.shipping.util.TugRouteNode;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TugRouteItem
extends Item {
    private static final Logger LOGGER = LogManager.getLogger(TugRouteItem.class);
    private static final String ROUTE_NBT = "route";

    public TugRouteItem(Item.Properties properties) {
        super(properties);
    }

    protected MenuProvider createContainerProvider(final InteractionHand hand) {
        return new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent("screen.littlelogistics.tug_route");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player Player2) {
                return new TugRouteContainer(i, Player2.f_19853_, TugRouteItem.this.getDataAccessor(Player2, hand), playerInventory, Player2);
            }
        };
    }

    public TugRouteScreenDataAccessor getDataAccessor(Player entity, InteractionHand hand) {
        return new TugRouteScreenDataAccessor.Builder(entity.m_142049_()).withOffHand(hand == InteractionHand.OFF_HAND).build();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!player.f_19853_.f_46443_) {
            if (player.m_6144_()) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.createContainerProvider(hand), this.getDataAccessor(player, hand)::write);
            } else {
                int z;
                int x = (int)Math.floor(player.m_20185_());
                if (!TugRouteItem.tryRemoveSpecific(itemstack, x, z = (int)Math.floor(player.m_20189_()))) {
                    player.m_5661_((Component)new TranslatableComponent("item.littlelogistics.tug_route.added", new Object[]{x, z}), false);
                    TugRouteItem.pushRoute(itemstack, x, z);
                } else {
                    player.m_5661_((Component)new TranslatableComponent("item.littlelogistics.tug_route.removed", new Object[]{x, z}), false);
                }
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public void m_142312_(@Nonnull CompoundTag nbt) {
        super.m_142312_(nbt);
        CompoundTag tag = nbt.m_128469_("tag");
        if (tag.m_128425_(ROUTE_NBT, 8)) {
            LOGGER.info("Found legacy tug route tag, replacing now");
            String routeString = tag.m_128461_(ROUTE_NBT);
            List<Vec2> legacyRoute = LegacyTugRouteUtil.parseLegacyRouteString(routeString);
            TugRoute route = LegacyTugRouteUtil.convertLegacyRoute(legacyRoute);
            tag.m_128365_(ROUTE_NBT, (Tag)route.toNBT());
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("item.littlelogistics.tug_route.description"));
        tooltip.add((Component)new TranslatableComponent("item.littlelogistics.tug_route.num_nodes", new Object[]{TugRouteItem.getRoute(stack).size()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW)));
    }

    public static TugRoute getRoute(ItemStack itemStack) {
        CompoundTag nbt = TugRouteItem.getTag(itemStack);
        if (nbt == null || !nbt.m_128425_(ROUTE_NBT, 10)) {
            return new TugRoute();
        }
        return TugRoute.fromNBT(nbt.m_128469_(ROUTE_NBT));
    }

    public static boolean popRoute(ItemStack itemStack) {
        TugRoute route = TugRouteItem.getRoute(itemStack);
        if (route.size() == 0) {
            return false;
        }
        route.remove(route.size() - 1);
        TugRouteItem.saveRoute(route, itemStack);
        return true;
    }

    public static boolean tryRemoveSpecific(ItemStack itemStack, int x, int z) {
        TugRoute route = TugRouteItem.getRoute(itemStack);
        if (route.size() == 0) {
            return false;
        }
        boolean removed = route.removeIf(v -> v.getX() == (double)x && v.getZ() == (double)z);
        TugRouteItem.saveRoute(route, itemStack);
        return removed;
    }

    public static void pushRoute(ItemStack itemStack, int x, int y) {
        TugRoute route = TugRouteItem.getRoute(itemStack);
        route.add(new TugRouteNode(x, y));
        TugRouteItem.saveRoute(route, itemStack);
    }

    public static void saveRoute(TugRoute route, ItemStack itemStack) {
        CompoundTag nbt = TugRouteItem.getTag(itemStack);
        if (nbt == null) {
            nbt = new CompoundTag();
            itemStack.m_41751_(nbt);
        }
        nbt.m_128365_(ROUTE_NBT, (Tag)route.toNBT());
    }

    @Nullable
    private static CompoundTag getTag(ItemStack stack) {
        return stack.m_41783_();
    }
}

