/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.vessel.barge;

import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.entity.container.FishingBargeContainer;
import dev.murad.shipping.entity.custom.vessel.barge.AbstractBargeEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.InventoryUtils;
import dev.murad.shipping.util.LinkableEntity;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public class FishingBargeEntity
extends AbstractBargeEntity
implements Container,
WorldlyContainer {
    protected final ItemStackHandler itemHandler = this.createHandler();
    protected final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    protected boolean contentsChanged = false;
    private int ticksDeployable = 0;
    private int fishCooldown = 0;
    private final Set<Pair<Integer, Integer>> overFishedCoords = new HashSet<Pair<Integer, Integer>>();
    private final Queue<Pair<Integer, Integer>> overFishedQueue = new LinkedList<Pair<Integer, Integer>>();
    private static final ResourceLocation FISHING_LOOT_TABLE = new ResourceLocation((String)ShippingConfig.Server.FISHING_LOOT_TABLE.get());
    private static final int FISHING_COOLDOWN = (Integer)ShippingConfig.Server.FISHING_COOLDOWN.get();
    private static final double FISHING_TREASURE_CHANCE = (Double)ShippingConfig.Server.FISHING_TREASURE_CHANCE_MODIFIER.get();

    public FishingBargeEntity(EntityType<? extends FishingBargeEntity> type, Level world) {
        super((EntityType<? extends AbstractBargeEntity>)type, world);
    }

    public FishingBargeEntity(Level worldIn, double x, double y, double z) {
        super((EntityType<? extends AbstractBargeEntity>)((EntityType)ModEntityTypes.FISHING_BARGE.get()), worldIn, x, y, z);
    }

    @Override
    protected void doInteract(Player player) {
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.createContainerProvider(), buffer -> buffer.writeInt(this.m_142049_()));
    }

    protected MenuProvider createContainerProvider() {
        return new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent("screen.littlelogistics.fishing_barge");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player Player2) {
                return new FishingBargeContainer(i, FishingBargeEntity.this.f_19853_, FishingBargeEntity.this.m_142049_(), playerInventory, Player2);
            }
        };
    }

    @Override
    public void m_142687_(Entity.RemovalReason r) {
        if (!this.f_19853_.f_46443_ && r.equals((Object)Entity.RemovalReason.KILLED)) {
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this);
        }
        super.m_142687_(r);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(27);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.tickWaterOnSidesCheck();
        if (!this.f_19853_.f_46443_ && this.getStatus() == Status.DEPLOYED) {
            if (this.fishCooldown < 0) {
                this.tickFish();
                this.fishCooldown = FISHING_COOLDOWN;
            } else {
                --this.fishCooldown;
            }
        }
    }

    private void tickWaterOnSidesCheck() {
        this.ticksDeployable = this.hasWaterOnSides() ? ++this.ticksDeployable : 0;
    }

    private double computeDepthPenalty() {
        int count = 0;
        BlockPos pos = this.m_20097_();
        while (this.f_19853_.m_8055_(pos).m_60734_().equals(Blocks.f_49990_)) {
            ++count;
            pos = pos.m_7495_();
        }
        count = Math.min(count, 20);
        return (double)count / 20.0;
    }

    private void tickFish() {
        double overFishPenalty = this.isOverFished() ? 0.05 : 1.0;
        double shallowPenalty = this.computeDepthPenalty();
        double chance = 0.25 * overFishPenalty * shallowPenalty;
        double treasure_chance = shallowPenalty > 0.4 ? chance * (shallowPenalty / 2.0) * FISHING_TREASURE_CHANCE : 0.0;
        double r = Math.random();
        if (r < chance) {
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78972_(LootContextParams.f_81455_, (Object)this).m_78972_(LootContextParams.f_81463_, (Object)new ItemStack((ItemLike)Items.f_42523_)).m_78977_(this.f_19796_);
            lootcontext$builder.m_78972_(LootContextParams.f_81458_, (Object)this).m_78972_(LootContextParams.f_81455_, (Object)this);
            LootTable loottable = this.f_19853_.m_142572_().m_129898_().m_79217_(r < treasure_chance ? BuiltInLootTables.f_78722_ : FISHING_LOOT_TABLE);
            List list = loottable.m_79129_(lootcontext$builder.m_78975_(LootContextParamSets.f_81414_));
            for (ItemStack stack : list) {
                int slot = InventoryUtils.findSlotFotItem(this, stack);
                if (slot != -1) {
                    this.itemHandler.insertItem(slot, stack, false);
                }
                if (this.isOverFished()) continue;
                this.addOverFish();
            }
        }
    }

    private String overFishedString() {
        return this.overFishedQueue.stream().map(t -> t.getFirst() + ":" + t.getSecond()).reduce("", (acc, curr) -> String.join((CharSequence)",", acc, curr));
    }

    private void populateOverfish(String string) {
        Arrays.stream(string.split(",")).filter(s -> !s.isEmpty()).map(s -> s.split(":")).map(arr -> new Pair((Object)Integer.parseInt(arr[0]), (Object)Integer.parseInt(arr[1]))).forEach(this.overFishedQueue::add);
        this.overFishedCoords.addAll(this.overFishedQueue);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        CompoundTag inv = compound.m_128469_("inv");
        inv.m_128473_("Size");
        this.itemHandler.deserializeNBT(inv);
        this.populateOverfish(compound.m_128461_("overfish"));
        super.m_7378_(compound);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        compound.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        compound.m_128359_("overfish", this.overFishedString());
        super.m_7380_(compound);
    }

    private void addOverFish() {
        int x = (int)Math.floor(this.m_20185_());
        int z = (int)Math.floor(this.m_20189_());
        this.overFishedCoords.add((Pair<Integer, Integer>)new Pair((Object)x, (Object)z));
        this.overFishedQueue.add((Pair<Integer, Integer>)new Pair((Object)x, (Object)z));
        if (this.overFishedQueue.size() > 30) {
            this.overFishedCoords.remove(this.overFishedQueue.poll());
        }
    }

    private boolean isOverFished() {
        int x = (int)Math.floor(this.m_20185_());
        int z = (int)Math.floor(this.m_20189_());
        return this.overFishedCoords.contains(new Pair((Object)x, (Object)z));
    }

    @Override
    public Item getDropItem() {
        return (Item)ModItems.FISHING_BARGE.get();
    }

    public int[] m_7071_(Direction p_180463_1_) {
        return IntStream.range(0, this.m_6643_()).toArray();
    }

    public boolean m_7155_(int p_180462_1_, ItemStack p_180462_2_, @Nullable Direction p_180462_3_) {
        return false;
    }

    public boolean m_7157_(int p_180461_1_, ItemStack p_180461_2_, Direction p_180461_3_) {
        return this.isDockable();
    }

    public boolean m_7013_(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    public int m_6643_() {
        return this.itemHandler.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_() || this.itemHandler.getStackInSlot(i).m_41720_().equals(Items.f_41852_)) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int p_70301_1_) {
        return this.itemHandler.getStackInSlot(p_70301_1_);
    }

    public ItemStack m_7407_(int p_70298_1_, int p_70298_2_) {
        return this.itemHandler.extractItem(p_70298_1_, p_70298_2_, false);
    }

    public ItemStack m_8016_(int p_70304_1_) {
        ItemStack itemstack = this.itemHandler.getStackInSlot(p_70304_1_);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.itemHandler.setStackInSlot(p_70304_1_, ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int p_70299_1_, ItemStack p_70299_2_) {
        this.itemHandler.setStackInSlot(p_70299_1_, p_70299_2_);
    }

    public void m_6596_() {
        this.contentsChanged = true;
    }

    public boolean m_6542_(Player p_70300_1_) {
        if (this.f_20890_) {
            return false;
        }
        return !(p_70300_1_.m_20280_((Entity)this) > 64.0);
    }

    public Status getStatus() {
        return this.hasWaterOnSides() ? this.getNonStashedStatus() : Status.STASHED;
    }

    private Status getNonStashedStatus() {
        if (this.ticksDeployable < 40) {
            return Status.TRANSITION;
        }
        return this.applyWithDominant(LinkableEntity::hasWaterOnSides).reduce(true, Boolean::logicalAnd) != false ? Status.DEPLOYED : Status.TRANSITION;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_6211_() {
    }

    public static enum Status {
        STASHED,
        DEPLOYED,
        TRANSITION;

    }
}

