/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.container;

import dev.murad.shipping.entity.accessor.EnergyHeadVehicleDataAccessor;
import dev.murad.shipping.entity.container.AbstractHeadVehicleContainer;
import dev.murad.shipping.setup.ModMenuTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class EnergyHeadVehicleContainer<T extends Entity>
extends AbstractHeadVehicleContainer<EnergyHeadVehicleDataAccessor, T> {
    public EnergyHeadVehicleContainer(int windowId, Level world, EnergyHeadVehicleDataAccessor data, Inventory playerInventory, Player player) {
        super((MenuType)ModMenuTypes.ENERGY_LOCOMOTIVE_CONTAINER.get(), windowId, world, data, playerInventory, player);
        if (this.entity != null) {
            this.entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> this.m_38897_(new SlotItemHandler(h, 0, 32, 35).setBackground(EMPTY_ATLAS_LOC, EMPTY_ENERGY)));
        }
    }

    public int getEnergy() {
        return ((EnergyHeadVehicleDataAccessor)this.data).getEnergy();
    }

    public int getCapacity() {
        return ((EnergyHeadVehicleDataAccessor)this.data).getCapacity();
    }

    public double getEnergyCapacityRatio() {
        if (this.getCapacity() == 0) {
            return 1.0;
        }
        return (double)this.getEnergy() / (double)this.getCapacity();
    }

    public boolean isLit() {
        return ((EnergyHeadVehicleDataAccessor)this.data).isLit();
    }

    @Override
    public boolean isOn() {
        return ((EnergyHeadVehicleDataAccessor)this.data).isOn();
    }

    @Override
    public int routeSize() {
        return ((EnergyHeadVehicleDataAccessor)this.data).routeSize();
    }

    @Override
    public int visitedSize() {
        return ((EnergyHeadVehicleDataAccessor)this.data).visitedSize();
    }
}

