/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.capability;

import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class ReadWriteEnergyStorage
implements IEnergyStorage {
    public static final String ENERGY_TAG = "energy";
    private final int maxCapacity;
    private final int maxReceive;
    private final int maxExtract;
    private EnergyStorage proxyStorage;

    public ReadWriteEnergyStorage(int maxCapacity, int maxReceive, int maxExtract) {
        this.maxCapacity = maxCapacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.proxyStorage = null;
    }

    private int clampInclusive(int n, int lo, int hi) {
        return Math.max(lo, Math.min(n, hi));
    }

    public void setEnergy(int energy) {
        this.proxyStorage = new EnergyStorage(this.maxCapacity, this.maxReceive, this.maxExtract, this.clampInclusive(energy, 0, this.maxCapacity));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        int energy = compound.m_128441_(ENERGY_TAG) ? compound.m_128451_(ENERGY_TAG) : 0;
        this.proxyStorage = new EnergyStorage(this.maxCapacity, this.maxReceive, this.maxExtract, this.clampInclusive(energy, 0, this.maxCapacity));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.m_128405_(ENERGY_TAG, this.proxyStorage.getEnergyStored());
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.proxyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.proxyStorage.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored() {
        return this.proxyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.proxyStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return this.proxyStorage.canExtract();
    }

    public boolean canReceive() {
        return this.proxyStorage.canReceive();
    }
}

